package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import flash.display.DisplayObject;
import mx.core.*;
import mx.events.ScrollEvent;
import mx.events.ScrollEventDirection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import mx.core.EdgeMetrics;
import mx.core.ScrollControlBase;
import mx.core.ScrollPolicy;
import mx.controls.scrollClasses.ScrollBar;
import mx.core.Container;
import org.eclipse.swt.SWT;
import mx.core.UIComponent;
import java.lang.Arguments;
dynamic public class Scrollable extends Control {
  internal var horizontalBar: org.eclipse.swt.widgets.ScrollBar;
  internal var verticalBar: org.eclipse.swt.widgets.ScrollBar;
  public function Scrollable__(): Object {
    return this;
  }
  public function Scrollable__Lorg_eclipse_swt_widgets_Composite_2I(parent: Composite, style: int): Object {
    return this;
  }
  public override function checkComponent__Lflash_display_DisplayObject_2(component: DisplayObject): Boolean {
    if (object === component)
      return false;
    if (verticalBar !== null && verticalBar.getBar__() === component)
      return false;
    if (horizontalBar !== null && horizontalBar.getBar__() === component)
      return false;
    return true;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var size: Point = super.computeSize__IIZ(wHint, hHint, changed);
    var trim: Rectangle = this.computeTrim__IIII(0, 0, size.x, size.y);
    return new Point(trim.width, trim.height);
  }
  public function computeTrim__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    this.checkWidget__();
    var view: EdgeMetrics;
    if (object is ScrollControlBase) {
      var scroll: ScrollControlBase = ScrollControlBase(object);
      view = scroll.viewMetrics;
      if (verticalBar !== null && scroll.verticalScrollPolicy === ScrollPolicy.OFF) {
        width_1 += mx.controls.scrollClasses.ScrollBar.THICKNESS;
      }
      if (horizontalBar !== null && scroll.horizontalScrollPolicy === ScrollPolicy.OFF) {
        height_1 += mx.controls.scrollClasses.ScrollBar.THICKNESS;
      }
    } else if (object is Container) {
      view = (Container(object)).viewMetricsAndPadding;
    } else {
      view = new EdgeMetrics();
    }
    x_1 -= view.left;
    y_1 -= view.top;
    width_1 += (view.left + view.right);
    height_1 += (view.top + view.bottom);
    return new Rectangle(x_1, y_1, width_1, height_1);
  }
  public function createScrollBar__I(type: int): org.eclipse.swt.widgets.ScrollBar {
    var bar: org.eclipse.swt.widgets.ScrollBar = new org.eclipse.swt.widgets.ScrollBar(this, type);
    if ((state & 16) != 0) {
      bar.setValues__IIIIII(0, 0, 100, 10, 1, 10);
    }
    return bar;
  }
  public override function createWidget__(): void {
    super.createWidget__();
    if ((style & 256) != 0)
      horizontalBar = this.createScrollBar__I(256);
    if ((style & 512) != 0)
      verticalBar = this.createScrollBar__I(512);
  }
  public function getClientArea__(): Rectangle {
    this.checkWidget__();
    var topComponent: UIComponent = this.topComponent__();
    var width_1: Number = topComponent.width;
    var height_1: Number = topComponent.height;
    var view: EdgeMetrics;
    if (object is ScrollControlBase) {
      var scroll: ScrollControlBase = ScrollControlBase(object);
      view = scroll.viewMetrics;
    } else if (object is Container) {
      view = (Container(object)).viewMetricsAndPadding;
    } else {
      view = new EdgeMetrics();
    }
    width_1 -= (view.left + view.right);
    height_1 -= (view.top + view.bottom);
    return new Rectangle(0, 0, int(width_1), int(height_1));
  }
  public function getHorizontalBar__(): org.eclipse.swt.widgets.ScrollBar {
    this.checkWidget__();
    return horizontalBar;
  }
  public function getVerticalBar__(): org.eclipse.swt.widgets.ScrollBar {
    this.checkWidget__();
    return verticalBar;
  }
  public function hasBorder__(): Boolean {
    return (style & 2048) != 0;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    if (object is ScrollControlBase) {
      object.addEventListener(ScrollEvent.SCROLL, this.scrollHandlerFunction__());
    }
    return;
  }
  public function scrollHandler__Lmx_events_ScrollEvent_2(event: ScrollEvent): void {
    if (event.direction === ScrollEventDirection.HORIZONTAL) {
      if (horizontalBar !== null)
        horizontalBar.scrollHandler__Lmx_events_ScrollEvent_2(event);
    } else {
      if (verticalBar !== null)
        verticalBar.scrollHandler__Lmx_events_ScrollEvent_2(event);
    }
    return;
  }
  public function scrollHandlerFunction__(): Function {
    return scrollHandler__Lmx_events_ScrollEvent_2;
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    if (horizontalBar !== null) {
      horizontalBar.release__Z(false);
      horizontalBar = null;
    }
    if (verticalBar !== null) {
      verticalBar.release__Z(false);
      verticalBar = null;
    }
    super.releaseChildren__Z(destroy);
    return;
  }
  public function Scrollable(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Composite && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Control.Control__, []);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Control.Control__Lorg_eclipse_swt_widgets_Composite_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Scrollable__();
        break;
      case 1:
        Scrollable__Lorg_eclipse_swt_widgets_Composite_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const Scrollable__ : int = 0;
  public static const Scrollable__Lorg_eclipse_swt_widgets_Composite_2I : int = 1;
}
}
