package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.ShellListener;
import mx.containers.TitleWindow;
import mx.containers.VBox;
import mx.core.*;
import mx.events.*;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.SWT;
import mx.core.UIComponent;
import mx.events.CloseEvent;
import org.eclipse.swt.graphics.Rectangle;
import mx.core.EdgeMetrics;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Shell extends Decorations {
  internal var window: TitleWindow;
  internal var region_org_eclipse_swt_widgets_Shell: Region;
  internal var toolTips: JavaArray;
  internal var opened: Boolean;
  internal var lastActive: Control;
  public function Shell__(): Object {
    return this;
  }
  public function Shell__Lorg_eclipse_swt_widgets_Display_2(display: Display): Object {
    return this;
  }
  public function Shell__I(style: int): Object {
    return this;
  }
  public function Shell__Lorg_eclipse_swt_widgets_Display_2I(display: Display, style: int): Object {
    return this;
  }
  public function Shell__Lorg_eclipse_swt_widgets_Shell_2(parent: Shell): Object {
    return this;
  }
  public function Shell__Lorg_eclipse_swt_widgets_Shell_2I(parent: Shell, style: int): Object {
    return this;
  }
  public function Shell__Lorg_eclipse_swt_widgets_Display_2Lorg_eclipse_swt_widgets_Shell_2IIZ(display: Display, parent: Shell, style: int, handle: int, embedded: Boolean): Object {
    if (display === null)
      display = Display.getCurrent__();
    if (display === null)
      display = Display.getDefault__();
    if (!display.isValidThread__()) {
      this.error__I(22);
    }
    if (parent !== null && parent.isDisposed__()) {
      this.error__I(5);
    }
    this.style = Shell.checkStyle__I(style);
    this.parent = parent;
    this.display = display;
    if (handle != 0 && !embedded) {
      state |= 2048;
    }
    this.createWidget__();
    return this;
  }
  public static function win32_new__Lorg_eclipse_swt_widgets_Display_2I(display: Display, handle: int): Shell {
    return null;
  }
  public static function internal_new__Lorg_eclipse_swt_widgets_Display_2I(display: Display, handle: int): Shell {
    return null;
  }
  public override function addParent__I(index: int): void {
    var widget: UIComponent = this.topComponent__();
    widget.percentWidth = 100;
    widget.percentHeight = 100;
    display.root.addChild(widget);
  }
  public function addShellListener__Lorg_eclipse_swt_events_ShellListener_2(listener: ShellListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(21, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(19, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(20, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(26, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(27, typedListener);
  }
  public static function checkStyle__I(style: int): int {
    style = Decorations.checkStyle__I(style);
    var mask: int = 131072 | 65536 | 32768;
    var bits: int = style & ~mask;
    if ((style & 131072) != 0)
      return bits | 131072;
    if ((style & 65536) != 0)
      return bits | 65536;
    if ((style & 32768) != 0)
      return bits | 32768;
    return bits;
  }
  public function close__(): void {
    this.checkWidget__();
    this.closeWidget__();
  }
  public function closeHandler__Lmx_events_CloseEvent_2(event: CloseEvent): void {
    this.sendClose__();
  }
  public function closeHandlerFunction__(): Function {
    return closeHandler__Lmx_events_CloseEvent_2;
  }
  public function closeWidget__(): void {
    var event: Event = new Event();
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(21, event);
    if (event.doit && !this.isDisposed__())
      this.dispose__();
  }
  public override function computeTrim__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    this.checkWidget__();
    var trim: Rectangle = super.computeTrim__IIII(x_1, y_1, width_1, height_1);
    if (window !== null) {
      var view: EdgeMetrics = window.viewMetricsAndPadding;
      trim.x -= view.left;
      trim.y -= view.top;
      trim.width += (view.left + view.right);
      trim.height += (view.top + view.bottom);
    }
    return trim;
  }
  public override function createHandle__(): void {
    super.createHandle__();
    var boxWidget: VBox = new VBox();
    boxWidget.percentWidth = boxWidget.percentHeight = 100;
    boxWidget.addChild(object);
    boxComponent = boxWidget;
    if ((style & 8) == 0) {
      window = new TitleWindow();
      window.showCloseButton = (style & 64) != 0;
      window.layout = "vertical";
      object.percentWidth = object.percentHeight = 100;
      window.addChild(boxWidget);
    }
    var widget: UIComponent = this.topComponent__();
    widget.visible = false;
    state |= 64;
    return;
  }
  public override function deregister__(): void {
    super.deregister__();
    if (window !== null)
      display.removeWidget__Lmx_core_UIComponent_2(window);
    return;
  }
  public override function destroyWidget__(): void {
    var widget: UIComponent = this.topComponent__();
    display.root.removeChild(widget);
    this.releaseHandle__();
    return;
  }
  public override function findBackgroundControl__(): Control {
    return background !== null || backgroundImage !== null ? this : null;
  }
  public override function findCursor__(): Cursor {
    return cursor;
  }
  public override function findDeferredControl__(): Composite {
    return layoutCount > 0 ? this : null;
  }
  public function forceActive__(): void {
  }
  public override function getClientArea__(): Rectangle {
    this.checkWidget__();
    var rect: Rectangle = super.getClientArea__();
    if (window !== null) {
      var windowView: EdgeMetrics = window.viewMetricsAndPadding;
      rect.width -= (windowView.left + windowView.right);
      rect.height -= (windowView.top + windowView.bottom);
    }
    return rect;
  }
  public function getImeInputMode__(): int {
    return 0;
  }
  public function getMinimumSize__(): Point {
    return null;
  }
  public function getRegion__(): Region {
    this.checkWidget__();
    return region_org_eclipse_swt_widgets_Shell;
  }
  public override function getShell__(): Shell {
    this.checkWidget__();
    return this;
  }
  public function getShells__(): JavaArray {
    this.checkWidget__();
    var count: int = 0;
    var shells: JavaArray = display.getShells__();
    for (var i: int = 0; i < shells.length; i++) {
      var shell: Control = shells[i];
      do {
        shell = shell.parent;
      } while (shell !== null && shell !== this);
      if (shell === this)
        count++;
    }
    var index: int = 0;
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/Shell;").lengths(count);
    for (var i_1: int = 0; i_1 < shells.length; i_1++) {
      var shell_1: Control = shells[i_1];
      do {
        shell_1 = shell_1.parent;
      } while (shell_1 !== null && shell_1 !== this);
      if (shell_1 === this) {
        result[index++] = shells[i_1];
      }
    }
    return result;
  }
  public override function hasBorder__(): Boolean {
    return false;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    if (window !== null) {
      window.addEventListener(CloseEvent.CLOSE, this.closeHandlerFunction__());
    }
    return;
  }
  public override function isEnabled__(): Boolean {
    this.checkWidget__();
    return this.getEnabled__();
  }
  public override function isVisible__(): Boolean {
    this.checkWidget__();
    return this.getVisible__();
  }
  public function open__(): void {
    this.checkWidget__();
    this.setVisible__Z(true);
  }
  public override function register__(): void {
    super.register__();
    if (window !== null)
      display.addWidget__Lmx_core_UIComponent_2Lorg_eclipse_swt_widgets_Widget_2(window, this);
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    var shells: JavaArray = this.getShells__();
    for (var i: int = 0; i < shells.length; i++) {
      var shell: Shell = shells[i];
      if (shell !== null && !shell.isDisposed__()) {
        shell.release__Z(false);
      }
    }
    if (toolTips !== null) {
      for (var i_1: int = 0; i_1 < toolTips.length; i_1++) {
        var toolTip: ToolTip = toolTips[i_1];
        if (toolTip !== null && !toolTip.isDisposed__()) {
          toolTip.release__Z(false);
        }
      }
    }
    toolTips = null;
    super.releaseChildren__Z(destroy);
    return;
  }
  public override function releaseParent__(): void {
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    region_org_eclipse_swt_widgets_Shell = null;
    lastActive = null;
    return;
  }
  public function removeShellListener__Lorg_eclipse_swt_events_ShellListener_2(listener: ShellListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(21, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(19, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(20, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(26, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(27, listener);
  }
  public function sendClose__(): void {
    this.closeWidget__();
  }
  public function setActive__(): void {
  }
  public function setActiveControl__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    if (control !== null && control.isDisposed__())
      control = null;
    if (lastActive !== null && lastActive.isDisposed__())
      lastActive = null;
    if (lastActive === control)
      return;
    var activate: JavaArray = (control === null) ? new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(0) : control.getPath__();
    var deactivate: JavaArray = (lastActive === null) ? new JavaArray("[Lorg/eclipse/swt/widgets/Control;").lengths(0) : lastActive.getPath__();
    lastActive = control;
    var index: int = 0;
    var length: int = Math__.min__II(activate.length, deactivate.length);
    while (index < length) {
      if (activate[index] !== deactivate[index])
        break;
      index++;
    }
    for (var i: int = deactivate.length - 1; i >= index; --i) {
      if (!deactivate[i].isDisposed__()) {
        deactivate[i].sendEvent__I(27);
      }
    }
    for (var i_1: int = activate.length - 1; i_1 >= index; --i_1) {
      if (!activate[i_1].isDisposed__()) {
        activate[i_1].sendEvent__I(26);
      }
    }
    return;
  }
  public function setImeInputMode__I(mode: int): void {
  }
  public override function setInitialBounds__(): void {
  }
  public function setMinimumSize__II(width_1: int, height_1: int): void {
    this.checkWidget__();
    return;
  }
  public function setMinimumSize__Lorg_eclipse_swt_graphics_Point_2(size: Point): void {
    this.checkWidget__();
    if (size === null)
      this.error__I(4);
    this.setMinimumSize__II(size.x, size.y);
    return;
  }
  public override function setRegion__Lorg_eclipse_swt_graphics_Region_2(region_1: Region): void {
    this.checkWidget__();
    if ((style & 8) == 0)
      return;
    if (region_1 !== null && region_1.isDisposed__())
      this.error__I(5);
    this.region_org_eclipse_swt_widgets_Shell = region_1;
  }
  public override function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    super.setText__Ljava_lang_String_2(string);
    if (window !== null) {
      window.title = string;
    }
    return;
  }
  public override function setVisible__Z(visible: Boolean): void {
    super.setVisible__Z(visible);
    if (visible)
      opened = true;
    return;
  }
  public override function topComponent__(): UIComponent {
    return window !== null ? window : super.topComponent__();
  }
  public function Shell(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Display) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is Display && vargs[1] is int) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 1 && vargs[0] is Shell) {
        args = vargs;
        id = 4;
      } else if (vargs.length == 2 && vargs[0] is Shell && vargs[1] is int) {
        args = vargs;
        id = 5;
      } else if (vargs.length == 5 && vargs[0] is Display && vargs[1] is Shell && vargs[2] is int && vargs[3] is int && vargs[4] is Boolean) {
        args = vargs;
        id = 6;
      }
    }
    switch (id) {
      case 0:
        args1 = [Display(null)];
        args3 = [args1[0], 1264];
        args6 = [args3[0], null, args3[1], 0, false];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Decorations.Decorations__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        args3 = [args1[0], 1264];
        args6 = [args3[0], null, args3[1], 0, false];
        superArgs = new Arguments(org.eclipse.swt.widgets.Decorations.Decorations__, []);
        break;
      case 2:
        var args2: Array = [args[0]];
        args3 = [Display(null), args2[0]];
        args6 = [args3[0], null, args3[1], 0, false];
        superArgs = new Arguments(org.eclipse.swt.widgets.Decorations.Decorations__, []);
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        args6 = [args3[0], null, args3[1], 0, false];
        superArgs = new Arguments(org.eclipse.swt.widgets.Decorations.Decorations__, []);
        break;
      case 4:
        var args4: Array = [args[0]];
        args5 = [args4[0], 2144];
        args6 = [args5[0] !== null ? args5[0].display : null, args5[0], args5[1], 0, false];
        superArgs = new Arguments(org.eclipse.swt.widgets.Decorations.Decorations__, []);
        break;
      case 5:
        var args5: Array = [args[0], args[1]];
        args6 = [args5[0] !== null ? args5[0].display : null, args5[0], args5[1], 0, false];
        superArgs = new Arguments(org.eclipse.swt.widgets.Decorations.Decorations__, []);
        break;
      case 6:
        var args6: Array = [args[0], args[1], args[2], args[3], args[4]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Decorations.Decorations__, []);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        Shell__Lorg_eclipse_swt_widgets_Display_2Lorg_eclipse_swt_widgets_Shell_2IIZ(args6[0], args6[1], args6[2], args6[3], args6[4]);
        Shell__Lorg_eclipse_swt_widgets_Display_2I(args3[0], args3[1]);
        Shell__Lorg_eclipse_swt_widgets_Display_2(args1[0]);
        Shell__();
        break;
      case 1:
        Shell__Lorg_eclipse_swt_widgets_Display_2Lorg_eclipse_swt_widgets_Shell_2IIZ(args6[0], args6[1], args6[2], args6[3], args6[4]);
        Shell__Lorg_eclipse_swt_widgets_Display_2I(args3[0], args3[1]);
        Shell__Lorg_eclipse_swt_widgets_Display_2(args1[0]);
        break;
      case 2:
        Shell__Lorg_eclipse_swt_widgets_Display_2Lorg_eclipse_swt_widgets_Shell_2IIZ(args6[0], args6[1], args6[2], args6[3], args6[4]);
        Shell__Lorg_eclipse_swt_widgets_Display_2I(args3[0], args3[1]);
        Shell__I(args2[0]);
        break;
      case 3:
        Shell__Lorg_eclipse_swt_widgets_Display_2Lorg_eclipse_swt_widgets_Shell_2IIZ(args6[0], args6[1], args6[2], args6[3], args6[4]);
        Shell__Lorg_eclipse_swt_widgets_Display_2I(args3[0], args3[1]);
        break;
      case 4:
        Shell__Lorg_eclipse_swt_widgets_Display_2Lorg_eclipse_swt_widgets_Shell_2IIZ(args6[0], args6[1], args6[2], args6[3], args6[4]);
        Shell__Lorg_eclipse_swt_widgets_Shell_2I(args5[0], args5[1]);
        Shell__Lorg_eclipse_swt_widgets_Shell_2(args4[0]);
        break;
      case 5:
        Shell__Lorg_eclipse_swt_widgets_Display_2Lorg_eclipse_swt_widgets_Shell_2IIZ(args6[0], args6[1], args6[2], args6[3], args6[4]);
        Shell__Lorg_eclipse_swt_widgets_Shell_2I(args5[0], args5[1]);
        break;
      case 6:
        Shell__Lorg_eclipse_swt_widgets_Display_2Lorg_eclipse_swt_widgets_Shell_2IIZ(args6[0], args6[1], args6[2], args6[3], args6[4]);
        break;
    }
  }
  public static const Shell__ : int = 0;
  public static const Shell__Lorg_eclipse_swt_widgets_Display_2 : int = 1;
  public static const Shell__I : int = 2;
  public static const Shell__Lorg_eclipse_swt_widgets_Display_2I : int = 3;
  public static const Shell__Lorg_eclipse_swt_widgets_Shell_2 : int = 4;
  public static const Shell__Lorg_eclipse_swt_widgets_Shell_2I : int = 5;
  public static const Shell__Lorg_eclipse_swt_widgets_Display_2Lorg_eclipse_swt_widgets_Shell_2IIZ : int = 6;
}
}
