package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Point;
import mx.events.*;
import mx.controls.*;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.SWT;
import mx.controls.HScrollBar;
import mx.controls.VScrollBar;
import mx.events.ScrollEvent;
import mx.events.ScrollEventDetail;
import mx.controls.scrollClasses.ScrollBar;
import java.lang.Arguments;
dynamic public class Slider extends Control {
  internal var minimum: int;
  internal var maximum: int;
  internal var selection: int;
  internal var thumb: int;
  internal var increment: int;
  internal var pageIncrement: int;
  public function Slider(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Control.Control__Lorg_eclipse_swt_widgets_Composite_2I, [parent, Slider.checkStyle__I(style)]));
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    return Widget.checkBits__IIIIIII(style, 256, 512, 0, 0, 0, 0);
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    var size: Point = super.computeSize__IIZ(wHint, hHint, changed);
    if (wHint == -1 && hHint == -1) {
      if ((style & 256) != 0) {
        size.x = size.y * 10;
      } else {
        size.y = size.x * 10;
      }
    }
    return size;
  }
  public override function createHandle__(): void {
    if ((style & 256) != 0) {
      object = new HScrollBar();
    } else {
      object = new VScrollBar();
    }
    return;
  }
  public override function createWidget__(): void {
    super.createWidget__();
    this.setValues__IIIIII(0, 0, 100, 10, 1, 10);
    return;
  }
  public function getIncrement__(): int {
    this.checkWidget__();
    return increment;
  }
  public function getMaximum__(): int {
    this.checkWidget__();
    return maximum;
  }
  public function getMinimum__(): int {
    this.checkWidget__();
    return minimum;
  }
  public function getPageIncrement__(): int {
    this.checkWidget__();
    return pageIncrement;
  }
  public function getSelection__(): int {
    this.checkWidget__();
    return selection;
  }
  public function getThumb__(): int {
    this.checkWidget__();
    return thumb;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(ScrollEvent.SCROLL, this.scrollHandlerFunction__());
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function scrollHandler__Lmx_events_ScrollEvent_2(event: ScrollEvent): void {
    var detail: int = 0;
    if (event.detail === ScrollEventDetail.LINE_UP) {
      detail = 16777217;
    } else if (event.detail === ScrollEventDetail.LINE_DOWN) {
      detail = 16777218;
    } else if (event.detail === ScrollEventDetail.LINE_LEFT) {
      detail = 16777218;
    } else if (event.detail === ScrollEventDetail.LINE_RIGHT) {
      detail = 16777217;
    } else if (event.detail === ScrollEventDetail.PAGE_UP) {
      detail = 16777221;
    } else if (event.detail === ScrollEventDetail.PAGE_DOWN) {
      detail = 16777222;
    } else if (event.detail === ScrollEventDetail.PAGE_LEFT) {
      detail = 16777222;
    } else if (event.detail === ScrollEventDetail.PAGE_RIGHT) {
      detail = 16777221;
    } else if (event.detail === ScrollEventDetail.THUMB_TRACK) {
      detail = 1;
    } else if (event.detail === ScrollEventDetail.THUMB_POSITION) {
      detail = 0;
    } else if (event.detail === ScrollEventDetail.AT_TOP) {
      detail = 16777223;
    } else if (event.detail === ScrollEventDetail.AT_BOTTOM) {
      detail = 16777224;
    } else if (event.detail === ScrollEventDetail.AT_LEFT) {
      detail = 16777223;
    } else if (event.detail === ScrollEventDetail.AT_RIGHT) {
      detail = 16777224;
    }
    this.sendSelection__II(detail, int(event.position));
    return;
  }
  public function scrollHandlerFunction__(): Function {
    return scrollHandler__Lmx_events_ScrollEvent_2;
  }
  public function sendSelection__II(detail: int, selection_1: int): void {
    this.selection = selection_1;
    var event: Event = new Event();
    event.detail = detail;
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(13, event);
    return;
  }
  public function setIncrement__I(value: int): void {
    this.setValues__IIIIII(selection, minimum, maximum, thumb, value, pageIncrement);
    return;
  }
  public function setMaximum__I(value: int): void {
    this.setValues__IIIIII(selection, minimum, value, thumb, increment, pageIncrement);
    return;
  }
  public function setMinimum__I(value: int): void {
    this.setValues__IIIIII(selection, value, maximum, thumb, increment, pageIncrement);
    return;
  }
  public function setPageIncrement__I(value: int): void {
    this.setValues__IIIIII(selection, minimum, maximum, thumb, increment, value);
    return;
  }
  public function setSelection__I(value: int): void {
    this.setValues__IIIIII(value, minimum, maximum, thumb, increment, pageIncrement);
    return;
  }
  public function setThumb__I(value: int): void {
    this.setValues__IIIIII(selection, minimum, maximum, value, increment, pageIncrement);
    return;
  }
  public function setValues__IIIIII(selection_1: int, minimum_1: int, maximum_1: int, thumb_1: int, increment_1: int, pageIncrement_1: int): void {
    this.checkWidget__();
    if (minimum_1 < 0)
      return;
    if (maximum_1 < 0)
      return;
    if (thumb_1 < 1)
      return;
    if (increment_1 < 1)
      return;
    if (pageIncrement_1 < 1)
      return;
    this.selection = selection_1;
    this.minimum = minimum_1;
    this.maximum = maximum_1;
    this.thumb = thumb_1;
    this.increment = increment_1;
    this.pageIncrement = pageIncrement_1;
    var bar: mx.controls.scrollClasses.ScrollBar = mx.controls.scrollClasses.ScrollBar(object);
    bar.minScrollPosition = minimum_1;
    bar.maxScrollPosition = maximum_1 - thumb_1;
    bar.scrollPosition = selection_1;
    bar.pageSize = thumb_1;
    bar.lineScrollSize = increment_1;
    bar.pageScrollSize = pageIncrement_1;
  }
}
}
