package org.eclipse.swt.widgets {
import mx.controls.NumericStepper;
import mx.events.NumericStepperEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class Spinner extends Composite {
  public function Spinner(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, Spinner.checkStyle__I(style)]));
    return;
  }
  public static function checkStyle__I(style: int): int {
    return style & ~(256 | 512);
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
  }
  public function addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(listener: ModifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(24, typedListener);
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    return this.computeNativeSize__Lmx_core_UIComponent_2IIZ(object, wHint, hHint, changed);
  }
  public function copy__(): void {
    this.checkWidget__();
  }
  public override function createHandle__(): void {
    var widget: NumericStepper = new NumericStepper();
    object = widget;
  }
  public override function createWidget__(): void {
    super.createWidget__();
    this.setValues__IIIIII(0, 0, 100, 0, 1, 10);
  }
  public function cut__(): void {
    this.checkWidget__();
  }
  public function getDigits__(): int {
    this.checkWidget__();
    return int((NumericStepper(object)).stepSize);
  }
  public function getIncrement__(): int {
    this.checkWidget__();
    return 1;
  }
  public function getMaximum__(): int {
    this.checkWidget__();
    return int((NumericStepper(object)).maximum);
  }
  public function getMinimum__(): int {
    this.checkWidget__();
    return int((NumericStepper(object)).minimum);
  }
  public function getPageIncrement__(): int {
    this.checkWidget__();
    return 10;
  }
  public function getSelection__(): int {
    this.checkWidget__();
    return int((NumericStepper(object)).value);
  }
  public function handleChange__Lmx_events_NumericStepperEvent_2(event: NumericStepperEvent): void {
    this.postEvent__I(13);
  }
  public function handleChangeFunction__(): Function {
    return handleChange__Lmx_events_NumericStepperEvent_2;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(NumericStepperEvent.CHANGE, this.handleChangeFunction__());
  }
  public function paste__(): void {
    this.checkWidget__();
  }
  public function removeModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(listener: ModifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(24, listener);
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public override function sendKeyEvent__ILorg_eclipse_swt_widgets_Event_2(type: int, keyEvent: Event): Boolean {
    var result: Boolean = super.sendKeyEvent__ILorg_eclipse_swt_widgets_Event_2(type, keyEvent);
    if (this.isDisposed__())
      return false;
    if (!result)
      return result;
    if (type != 1)
      return result;
    switch (keyEvent.keyCode) {
      case 13 :
        this.postEvent__I(14);
        break;
    }
    return result;
  }
  public function setDigits__I(value: int): void {
    this.checkWidget__();
    (NumericStepper(object)).stepSize = value == 0 ? 1 : 1 / Math__.pow__DD(10, value);
  }
  public function setIncrement__I(value: int): void {
    this.checkWidget__();
  }
  public function setMaximum__I(value: int): void {
    this.checkWidget__();
    (NumericStepper(object)).maximum = value;
  }
  public function setMinimum__I(value: int): void {
    this.checkWidget__();
    (NumericStepper(object)).minimum = value;
  }
  public function setPageIncrement__I(value: int): void {
    this.checkWidget__();
  }
  public function setSelection__I(value: int): void {
    this.checkWidget__();
    (NumericStepper(object)).value = value;
  }
  public function setValues__IIIIII(selection: int, minimum: int, maximum: int, digits: int, increment: int, pageIncrement: int): void {
    this.checkWidget__();
    if (minimum < 0)
      return;
    if (maximum <= minimum)
      return;
    if (digits < 0)
      return;
    if (increment < 1)
      return;
    if (pageIncrement < 1)
      return;
    selection = Math__.min__II(Math__.max__II(minimum, selection), maximum);
    var widget: NumericStepper = NumericStepper(object);
    widget.minimum = minimum;
    widget.maximum = maximum;
    widget.value = selection;
    widget.stepSize = digits == 0 ? 1 : 1 / Math__.pow__DD(10, digits);
  }
}
}
