package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.Compatibility;
import java.lang.Thread;
import org.eclipse.swt.SWT;
import java.lang.System;
import java.lang.Runnable;
import java.lang.Throwable;
import org.eclipse.swt.graphics.Device;
import java.lang.InterruptedException;
import java.lang.Class__;
import java.lang.JavaArray;
dynamic public class Synchronizer {
  internal var display: Display;
  internal var messageCount: int;
  internal var messages: JavaArray;
  internal var messageLock: Object = new Object();
  internal var syncThread: Thread;
  public static const GROW_SIZE: int = 4;
  public static const MESSAGE_LIMIT: int = 64;
  public static var IS_CARBON: Boolean = Object("carbon").equals__Ljava_lang_Object_2(SWT.getPlatform__());
  public function Synchronizer(display: Display) {
    this.display = display;
    return;
  }
  public function addLast__Lorg_eclipse_swt_widgets_RunnableLock_2(lock: RunnableLock): void {
    var wake: Boolean = false;
    {
      if (messages === null)
        messages = new JavaArray("[Lorg/eclipse/swt/widgets/RunnableLock;").lengths(4);
      if (messageCount == messages.length) {
        var newMessages: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/RunnableLock;").lengths(messageCount + 4);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(messages, 0, newMessages, 0, messageCount);
        messages = newMessages;
      }
      messages[messageCount++] = lock;
      wake = messageCount == 1;
    }
    if (wake)
      display.wakeThread__();
    return;
  }
  public function asyncExec__Ljava_lang_Runnable_2(runnable: Runnable): void {
    if (runnable === null) {
      if (!IS_CARBON) {
        display.wake__();
        return;
      }
    }
    this.addLast__Lorg_eclipse_swt_widgets_RunnableLock_2(new RunnableLock(runnable));
    return;
  }
  public function getMessageCount__(): int {
    {
      return messageCount;
    }
    return 0;
  }
  public function releaseSynchronizer__(): void {
    display = null;
    messages = null;
    messageLock = null;
    syncThread = null;
    return;
  }
  public function removeFirst__(): RunnableLock {
    {
      if (messageCount == 0)
        return null;
      var lock: RunnableLock = messages[0];
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(messages, 1, messages, 0, --messageCount);
      messages[messageCount] = null;
      if (messageCount == 0) {
        if (messages.length > 64)
          messages = null;
      }
      return lock;
    }
    return null;
  }
  public function runAsyncMessages__(): Boolean {
    return this.runAsyncMessages__Z(false);
  }
  public function runAsyncMessages__Z(all: Boolean): Boolean {
    var run: Boolean = false;
    do {
      var lock: RunnableLock = this.removeFirst__();
      if (lock === null)
        return run;
      run = true;
      {
        syncThread = lock.thread;
        try {
          lock.run__();
        } catch (t : Throwable) {
          lock.throwable = t;
          SWT.error__ILjava_lang_Throwable_2(46, t);
        } finally {
          syncThread = null;
          Object(lock).notifyAll__();
        }
      }
    } while (all);
    return run;
  }
  public function syncExec__Ljava_lang_Runnable_2(runnable: Runnable): void {
    var lock: RunnableLock = null;
    {
      if (display === null || display.isDisposed__())
        SWT.error__I(45);
      if (!display.isValidThread__()) {
        if (runnable === null) {
          display.wake__();
          return;
        }
        lock = new RunnableLock(runnable);
        lock.thread = Thread.currentThread__();
        this.addLast__Lorg_eclipse_swt_widgets_RunnableLock_2(lock);
      }
    }
    if (lock === null) {
      if (runnable !== null)
        runnable.run__();
      return;
    }
    {
      var interrupted: Boolean = false;
      while (!lock.done__()) {
        try {
          Object(lock).wait__();
        } catch (e : InterruptedException) {
          interrupted = true;
        }
      }
      if (interrupted) {
        Compatibility.interrupt__();
      }
      if (lock.throwable !== null) {
        SWT.error__ILjava_lang_Throwable_2(46, lock.throwable);
      }
    }
    return;
  }
}
}
