package org.eclipse.swt.widgets {
import flash.display.DisplayObjectContainer;
import mx.containers.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.System;
import mx.containers.TabNavigator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.SWT;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TabFolder extends Composite {
  internal var items: JavaArray;
  internal var selection: int = -1;
  public function TabFolder(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, TabFolder.checkStyle__I(style)]));
    return;
  }
  public override function addChild__Lorg_eclipse_swt_widgets_Widget_2I(child: Widget, index: int): void {
  }
  public function addItem__Lorg_eclipse_swt_widgets_TabItem_2(item: TabItem): void {
    if (items === null)
      items = new JavaArray("[Lorg/eclipse/swt/widgets/TabItem;").lengths(4);
    var length: int = items.length;
    for (var i: int = 0; i < length; i++) {
      if (items[i] === item)
        return;
    }
    var index: int = 0;
    while (index < length) {
      if (items[index] === null)
        break;
      index++;
    }
    if (index == length) {
      var temp: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TabItem;").lengths(length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, temp, 0, length);
      items = temp;
    }
    items[index] = item;
    (TabNavigator(object)).addChild(item.object);
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public static function checkStyle__I(style: int): int {
    style = Widget.checkBits__IIIIIII(style, 128, 1024, 0, 0, 0, 0);
    return style & ~(256 | 512);
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
  }
  public override function createWidget__(): void {
    super.createWidget__();
    items = new JavaArray("[Lorg/eclipse/swt/widgets/TabItem;").lengths(4);
  }
  public override function createHandle__(): void {
    var widget: TabNavigator = new TabNavigator();
    if (widget === null)
      this.error__I(2);
    object = widget;
  }
  public function createItem__Lorg_eclipse_swt_widgets_TabItem_2I(item: TabItem, index: int): void {
    var itemCount: int = this.getItemCount__();
    if (!(0 <= index && index <= itemCount))
      this.error__I(6);
    item.createWidget__();
    this.addItem__Lorg_eclipse_swt_widgets_TabItem_2(item);
  }
  public override function _getImage__Lflash_display_DisplayObjectContainer_2(item: DisplayObjectContainer): Image {
    return items[item.parent.getChildIndex(item)].image;
  }
  public function getItem__I(index: int): TabItem {
    this.checkWidget__();
    var count: int = this.getItemCount__();
    if (!(0 <= index && index < count))
      this.error__I(6);
    return items[index];
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    var count: int = 0;
    while (count < items.length && items[count] !== null)
      count++;
    return count;
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var count: int = this.getItemCount__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TabItem;").lengths(count);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, result, 0, count);
    return result;
  }
  public function getSelection__(): JavaArray {
    this.checkWidget__();
    var index: int = this.getSelectionIndex__();
    if (index == -1)
      return new JavaArray("[Lorg/eclipse/swt/widgets/TabItem;").lengths(0);
    return new JavaArray("[Lorg/eclipse/swt/widgets/TabItem;").values(items[index]);
  }
  public function getSelectionIndex__(): int {
    this.checkWidget__();
    return selection;
  }
  public function indexOf__Lorg_eclipse_swt_widgets_TabItem_2(item: TabItem): int {
    this.checkWidget__();
    if (item === null)
      this.error__I(4);
    for (var i: int = 0; i < items.length; i++) {
      if (items[i] === item)
        return i;
    }
    return -1;
  }
  public override function minimumSize__IIZ(wHint: int, hHint: int, flushCache: Boolean): Point {
    var children_1: JavaArray = this._getChildren__();
    var width_1: int = 0;
    var height_1: int = 0;
    for (var i: int = 0; i < children_1.length; i++) {
      var child: Control = children_1[i];
      var index: int = 0;
      var count: int = items.length;
      while (index < count) {
        if (items[index].control === child)
          break;
        index++;
      }
      if (index == count) {
        var rect: Rectangle = child.getBounds__();
        width_1 = Math__.max__II(width_1, rect.x + rect.width);
        height_1 = Math__.max__II(height_1, rect.y + rect.height);
      } else {
        var size: Point = child.computeSize__IIZ(wHint, hHint, flushCache);
        width_1 = Math__.max__II(width_1, size.x);
        height_1 = Math__.max__II(height_1, size.y);
      }
    }
    return new Point(width_1, height_1);
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    if (items !== null) {
      var count: int = this.getItemCount__();
      for (var i: int = 0; i < count; i++) {
        var item: TabItem = items[i];
        if (item !== null && !item.isDisposed__()) {
          item.release__Z(false);
        }
      }
      items = null;
    }
    super.releaseChildren__Z(destroy);
    return;
  }
  public override function removeControl__Lorg_eclipse_swt_widgets_Control_2(control: Control): void {
    super.removeControl__Lorg_eclipse_swt_widgets_Control_2(control);
    for (var i: int = 0; i < items.length; i++) {
      var item: TabItem = items[i];
      if (item !== null && item.control === control) {
        item.setControl__Lorg_eclipse_swt_widgets_Control_2(null);
      }
    }
    return;
  }
  public override function removeChild__Lorg_eclipse_swt_widgets_Widget_2(child: Widget): void {
  }
  public function removeItem__Lorg_eclipse_swt_widgets_TabItem_2(item: TabItem): void {
    var index: int = 0;
    while (index < items.length) {
      if (items[index] === item)
        break;
      index++;
    }
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index + 1, items, index, items.length - index);
    items[items.length - 1] = null;
    return;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function sendSelection__I(selection_1: int): void {
    this.setSelection__IZ(selection_1, true);
  }
  public function setSelection__I(index: int): void {
    this.checkWidget__();
    var count: int = this.getItemCount__();
    if (!(0 <= index && index < count))
      return;
    this.setSelection__IZ(index, false);
  }
  public function setSelection__IZ(index: int, notify: Boolean): void {
    var oldIndex: int = selection;
    if (oldIndex == index)
      return;
    if (oldIndex != -1) {
      var item: TabItem = items[oldIndex];
      var control: Control = item.control;
      if (control !== null && !control.isDisposed__()) {
      }
    }
    var widget: TabNavigator = TabNavigator(object);
    widget.selectedIndex = index;
    var newIndex: int = widget.selectedIndex;
    if (newIndex != -1) {
      var item_1: TabItem = items[newIndex];
      var control_1: Control = item_1.control;
      if (control_1 !== null && !control_1.isDisposed__()) {
      }
      if (notify) {
        var event: Event = new Event();
        event.item = item_1;
        this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(13, event);
      }
    }
    return;
  }
  public function setSelection___3Lorg_eclipse_swt_widgets_TabItem_2(items_1: JavaArray): void {
    this.checkWidget__();
    if (items_1 === null)
      this.error__I(4);
    if (items_1.length == 0) {
      this.setSelection__IZ(-1, false);
    } else {
      for (var i: int = items_1.length - 1; i >= 0; --i) {
        var index: int = this.indexOf__Lorg_eclipse_swt_widgets_TabItem_2(items_1[i]);
        if (index != -1)
          this.setSelection__IZ(index, false);
      }
    }
    return;
  }
  public function setSelection__Lorg_eclipse_swt_widgets_TabItem_2(item: TabItem): void {
    this.checkWidget__();
    if (item === null)
      this.error__I(4);
    this.setSelection___3Lorg_eclipse_swt_widgets_TabItem_2(new JavaArray("[Lorg/eclipse/swt/widgets/TabItem;").values(item));
    return;
  }
}
}
