package org.eclipse.swt.widgets {
import mx.core.Container;
import mx.core.UIComponent;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.SWT;
import mx.containers.Canvas;
import org.eclipse.swt.graphics.Image;
import java.lang.Arguments;
dynamic public class TabItem extends Item {
  internal var parent: TabFolder;
  internal var control: Control;
  internal var toolTipText: String;
  public function TabItem__Lorg_eclipse_swt_widgets_TabFolder_2I(parent: TabFolder, style: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_TabItem_2I(this, parent.getItemCount__());
    return this;
  }
  public function TabItem__Lorg_eclipse_swt_widgets_TabFolder_2II(parent: TabFolder, style: int, index: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_TabItem_2I(this, index);
    return this;
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
    return;
  }
  public override function createHandle__(): void {
    var widget: mx.containers.Canvas = new mx.containers.Canvas();
    if (widget === null)
      this.error__I(2);
    object = widget;
    return;
  }
  public override function destroyWidget__(): void {
    parent.removeItem__Lorg_eclipse_swt_widgets_TabItem_2(this);
    super.destroyWidget__();
    return;
  }
  public function getControl__(): Control {
    this.checkWidget__();
    return control;
  }
  public function getParent__(): TabFolder {
    this.checkWidget__();
    return parent;
  }
  public function getToolTipText__(): String {
    this.checkWidget__();
    return toolTipText;
  }
  public override function releaseHandle__(): void {
    super.releaseHandle__();
    object = null;
    parent = null;
  }
  public override function releaseParent__(): void {
    super.releaseParent__();
    var index: int = parent.indexOf__Lorg_eclipse_swt_widgets_TabItem_2(this);
    if (index == parent.getSelectionIndex__()) {
      if (control !== null)
        control.setVisible__Z(false);
    }
    return;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    control = null;
    return;
  }
  public function setControl__Lorg_eclipse_swt_widgets_Control_2(control_1: Control): void {
    this.checkWidget__();
    if (control_1 !== null) {
      if (control_1.isDisposed__())
        this.error__I(5);
      if (control_1.parent !== parent)
        this.error__I(32);
    }
    if (this.control !== null && this.control.isDisposed__()) {
      this.control = null;
    }
    var oldControl: Control = this.control;
    var newControl: Control = control_1;
    this.control = control_1;
    if (newControl !== null) {
      var widget: UIComponent = newControl.topComponent__();
      widget.percentWidth = widget.percentHeight = 100;
      object.addChild(widget);
      newControl.setVisible__Z(true);
    }
    if (oldControl !== null) {
      object.removeChild(oldControl.topComponent__());
      oldControl.setVisible__Z(false);
    }
    return;
  }
  public override function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    super.setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
    (Container(object)).icon = image_1 !== null ? SWTBitmapAsset.getClazz__() : null;
    return;
  }
  public override function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if (Object(string).equals__Ljava_lang_Object_2(text))
      return;
    super.setText__Ljava_lang_String_2(string);
    (mx.containers.Canvas(object)).label = this.fixMnemonic__Ljava_lang_String_2(string);
  }
  public function setToolTipText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    toolTipText = string;
    object.toolTip = string;
  }
  public function TabItem(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is TabFolder && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is TabFolder && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args0[0], args0[1]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        TabItem__Lorg_eclipse_swt_widgets_TabFolder_2I(args0[0], args0[1]);
        break;
      case 1:
        TabItem__Lorg_eclipse_swt_widgets_TabFolder_2II(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const TabItem__Lorg_eclipse_swt_widgets_TabFolder_2I : int = 0;
  public static const TabItem__Lorg_eclipse_swt_widgets_TabFolder_2II : int = 1;
}
}
