package org.eclipse.swt.widgets {
import mx.collections.ArrayCollection;
import mx.controls.DataGrid;
import mx.controls.listClasses.ListBase;
import mx.events.ListEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.flex.TableItemRendererClassFactory;
import org.eclipse.swt.events.*;
import java.lang.System;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Font;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Table extends Composite {
  internal var columnCount: int;
  internal var columns: JavaArray;
  internal var items: ArrayCollection;
  internal var headerVisible: Boolean;
  public function Table(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, Table.checkStyle__I(style)]));
    return;
  }
  public static function checkStyle__I(style: int): int {
    style |= 256 | 512;
    style |= 65536;
    return Widget.checkBits__IIIIIII(style, 4, 2, 0, 0, 0, 0);
  }
  public function _getItem__I(index: int): TableItem {
    var item: TableItem = TableItem(items.getItemAt(index));
    if (item !== null)
      return item;
    if ((style & 268435456) == 0)
      return item;
    return null;
  }
  public function createItem__Lorg_eclipse_swt_widgets_TableColumn_2I(column: TableColumn, index: int): void {
    if (!(0 <= index && index <= columnCount))
      this.error__I(6);
    if (columnCount == columns.length) {
      var newColumns: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TableColumn;").lengths(columns.length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(columns, 0, newColumns, 0, columns.length);
      columns = newColumns;
    }
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(columns, index, columns, index + 1, columnCount++ - index);
    columns[index] = column;
    column.createWidget__();
    var array: Array = (DataGrid(object)).columns;
    array.splice(index, 0, column.column);
    (DataGrid(object)).columns = array;
    if (columnCount == 1) {
      (DataGrid(object)).showHeaders = headerVisible;
    }
    return;
  }
  public function createItem__Lorg_eclipse_swt_widgets_TableItem_2I(item: TableItem, index: int): void {
    var itemCount: int = items.length;
    if (!(0 <= index && index <= itemCount))
      this.error__I(6);
    item.createWidget__();
    items.addItemAt(item, index);
    return;
  }
  public override function createHandle__(): void {
    var widget: DataGrid = new DataGrid();
    if ((style & 2) != 0)
      widget.allowMultipleSelection = true;
    widget.dataProvider = items = new ArrayCollection();
    widget.showHeaders = false;
    widget.itemRenderer = new TableItemRendererClassFactory(this, null, false);
    object = widget;
    return;
  }
  public override function createWidget__(): void {
    super.createWidget__();
    columns = new JavaArray("[Lorg/eclipse/swt/widgets/TableColumn;").lengths(4);
    return;
  }
  public function checkData__Lorg_eclipse_swt_widgets_TableItem_2(item: TableItem): Boolean {
    if (item.cached)
      return true;
    if ((style & 268435456) != 0) {
      item.cached = true;
      var event: Event = new Event();
      event.item = item;
      event.index = this.indexOf__Lorg_eclipse_swt_widgets_TableItem_2(item);
      if (item.isDisposed__())
        return false;
    }
    return true;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
  }
  public function changeHandler__Lmx_events_ListEvent_2(event: ListEvent): void {
    this.postEvent__I(13);
  }
  public function changeHandlerFunction__(): Function {
    return changeHandler__Lmx_events_ListEvent_2;
  }
  public override function checkSubclass__(): void {
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    return this.computeNativeSize__Lmx_core_UIComponent_2IIZ(object, wHint, hHint, changed);
  }
  public function clear__I(index: int): void {
  }
  public function clear__II(start: int, end: int): void {
  }
  public function clear___3I(indices: JavaArray): void {
  }
  public function clearAll__(): void {
  }
  public function deselect___3I(indices: JavaArray): void {
  }
  public function deselect__I(index: int): void {
  }
  public function deselect__II(start: int, end: int): void {
  }
  public function deselectAll__(): void {
  }
  public function destroyItem__Lorg_eclipse_swt_widgets_TableItem_2(item: TableItem): void {
    var index: int = items.getItemIndex(item);
    items.removeItemAt(index);
  }
  public function destroyItem__Lorg_eclipse_swt_widgets_TableColumn_2(column: TableColumn): void {
    var array: Array = (DataGrid(object)).columns;
    var index: int = array.indexOf(column.column, 0);
    array.splice(index, 1);
    (DataGrid(object)).columns = array;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(columns, index + 1, columns, index, --columnCount - index);
    columns[columnCount] = null;
    if (columnCount == 0) {
      (DataGrid(object)).showHeaders = false;
    }
    return;
  }
  public function getColumn__I(index: int): TableColumn {
    this.checkWidget__();
    if (!(0 <= index && index < columnCount))
      this.error__I(6);
    return columns[index];
  }
  public function getColumnCount__(): int {
    this.checkWidget__();
    return columnCount;
  }
  public function getColumnOrder__(): JavaArray {
    return null;
  }
  public function getColumns__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TableColumn;").lengths(columnCount);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(columns, 0, result, 0, columnCount);
    return result;
  }
  public function getGridLineWidth__(): int {
    return 0;
  }
  public function getHeaderHeight__(): int {
    return int((DataGrid(object)).headerHeight);
  }
  public function getHeaderVisible__(): Boolean {
    return headerVisible;
  }
  public function getItem__I(index: int): TableItem {
    this.checkWidget__();
    var itemCount: int = items.length;
    if (!(0 <= index && index < itemCount))
      this.error__I(6);
    return this._getItem__I(index);
  }
  public function getItem__Lorg_eclipse_swt_graphics_Point_2(point: Point): TableItem {
    return null;
  }
  public function getItemCount__(): int {
    return items.length;
  }
  public function getItemHeight__(): int {
    return int((ListBase(object)).rowHeight);
  }
  public function getItems__(): JavaArray {
    var itemCount: int = items.length;
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TableItem;").lengths(itemCount);
    for (var i: int = 0; i < itemCount; i++) {
      result[i] = TableItem(items.getItemAt(i));
    }
    return result;
  }
  public function getLinesVisible__(): Boolean {
    return true;
  }
  public function getSelection__(): JavaArray {
    this.checkWidget__();
    var array: Array = (ListBase(object)).selectedIndices;
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TableItem;").lengths(array.length);
    for (var i: int = 0; i < result.length; i++) {
      result[i] = TableItem(items.getItemAt(this.arrayGetInt__LArray_2I(array, i)));
    }
    return result;
  }
  public function getSelectionCount__(): int {
    return 0;
  }
  public function getSelectionIndex__(): int {
    return 0;
  }
  public function getSelectionIndices__(): JavaArray {
    return null;
  }
  public function getSortColumn__(): TableColumn {
    return null;
  }
  public function getSortDirection__(): int {
    return 0;
  }
  public function getTopIndex__(): int {
    return 0;
  }
  public function indexOf__Lorg_eclipse_swt_widgets_TableColumn_2(column: TableColumn): int {
    this.checkWidget__();
    if (column === null)
      this.error__I(4);
    var array: Array = (DataGrid(object)).columns;
    return array.indexOf(column.column, 0);
  }
  public function indexOf__Lorg_eclipse_swt_widgets_TableItem_2(item: TableItem): int {
    this.checkWidget__();
    return items.getItemIndex(item);
  }
  public function invalidateItem__Lorg_eclipse_swt_widgets_TableItem_2I(item: TableItem, columnIndex: int): void {
    items.itemUpdated(item);
  }
  public function isSelected__I(index: int): Boolean {
    return false;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(ListEvent.CHANGE, this.changeHandlerFunction__());
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    if (items !== null) {
      var itemCount: int = items.length;
      for (var i: int = 0; i < itemCount; i++) {
        var item: TableItem = TableItem(items.getItemAt(i));
        if (item !== null && !item.isDisposed__()) {
          item.release__Z(false);
        }
      }
    }
    if (columns !== null) {
      for (var i_1: int = 0; i_1 < columnCount; i_1++) {
        var column: TableColumn = columns[i_1];
        if (column !== null && !column.isDisposed__()) {
          column.release__Z(false);
        }
      }
      columns = null;
    }
    super.releaseChildren__Z(destroy);
    return;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    items = null;
    return;
  }
  public function remove___3I(indices: JavaArray): void {
  }
  public function remove__I(index: int): void {
  }
  public function remove__II(start: int, end: int): void {
  }
  public function removeAll__(): void {
    this.checkWidget__();
    items.removeAll();
    return;
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function select___3I(indices: JavaArray): void {
  }
  public function select__I(index: int): void {
  }
  public function select__II(start: int, end: int): void {
  }
  public function selectAll__(): void {
  }
  public function setColumnOrder___3I(order: JavaArray): void {
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
  }
  public function setHeaderVisible__Z(show: Boolean): void {
    this.checkWidget__();
    headerVisible = show;
    if (columnCount > 0) {
      (DataGrid(object)).showHeaders = show;
    }
    return;
  }
  public function setItemCount__I(count: int): void {
  }
  public function setLinesVisible__Z(show: Boolean): void {
  }
  public override function setRedraw__Z(redraw: Boolean): void {
  }
  public function setSelection___3I(indices: JavaArray): void {
  }
  public function setSelection__Lorg_eclipse_swt_widgets_TableItem_2(item: TableItem): void {
  }
  public function setSelection___3Lorg_eclipse_swt_widgets_TableItem_2(items_1: JavaArray): void {
  }
  public function setSelection__I(index: int): void {
  }
  public function setSelection__II(start: int, end: int): void {
  }
  public function setSortColumn__Lorg_eclipse_swt_widgets_TableColumn_2(column: TableColumn): void {
  }
  public function setSortDirection__I(direction: int): void {
  }
  public function setTopIndex__I(index: int): void {
  }
  public function showColumn__Lorg_eclipse_swt_widgets_TableColumn_2(column: TableColumn): void {
  }
  public function showItem__Lorg_eclipse_swt_widgets_TableItem_2(item: TableItem): void {
  }
  public function showSelection__(): void {
  }
}
}
