package org.eclipse.swt.widgets {
import mx.controls.dataGridClasses.DataGridColumn;
import mx.controls.listClasses.ListBase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.flex.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.flex.TableItemRendererClassFactory;
import org.eclipse.swt.graphics.Image;
import java.lang.Arguments;
dynamic public class TableColumn extends Item {
  internal var column: DataGridColumn;
  internal var parent: Table;
  public function TableColumn__Lorg_eclipse_swt_widgets_Table_2I(parent: Table, style: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_TableColumn_2I(this, parent.getColumnCount__());
    return this;
  }
  public function TableColumn__Lorg_eclipse_swt_widgets_Table_2II(parent: Table, style: int, index: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_TableColumn_2I(this, index);
    return this;
  }
  public function addControlListener__Lorg_eclipse_swt_events_ControlListener_2(listener: ControlListener): void {
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
  }
  public static function checkStyle__I(style: int): int {
    return Widget.checkBits__IIIIIII(style, 16384, 16777216, 131072, 0, 0, 0);
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
  }
  public override function createHandle__(): void {
    column = new DataGridColumn();
    if (column === null)
      this.error__I(2);
    column.sortable = false;
    column.itemRenderer = new TableItemRendererClassFactory(parent, this, false);
    column.headerRenderer = new TableItemRendererClassFactory(parent, this, true);
  }
  public override function destroyWidget__(): void {
    parent.destroyItem__Lorg_eclipse_swt_widgets_TableColumn_2(this);
    this.releaseHandle__();
  }
  public function getAlignment__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getParent__(): Table {
    this.checkWidget__();
    return parent;
  }
  public function getMoveable__(): Boolean {
    this.checkWidget__();
    return column.draggable;
  }
  public function getResizable__(): Boolean {
    this.checkWidget__();
    return column.resizable;
  }
  public function getToolTipText__(): String {
    return "";
  }
  public function getWidth__(): int {
    this.checkWidget__();
    return int(column.width);
  }
  public function pack__(): void {
  }
  public function removeControlListener__Lorg_eclipse_swt_events_ControlListener_2(listener: ControlListener): void {
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
  }
  public override function releaseHandle__(): void {
    super.releaseHandle__();
    column = null;
    parent = null;
  }
  public function setAlignment__I(alignment: int): void {
  }
  public override function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    super.setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
    (ListBase(parent.object)).invalidateList();
  }
  public function setMoveable__Z(moveable: Boolean): void {
    this.checkWidget__();
    column.draggable = moveable;
  }
  public function setResizable__Z(resizable: Boolean): void {
    this.checkWidget__();
    column.resizable = resizable;
  }
  public override function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if (Object(string).equals__Ljava_lang_Object_2(text))
      return;
    text = string;
    column.headerText = text;
  }
  public function setToolTipText__Ljava_lang_String_2(string: String): void {
  }
  public function setWidth__I(width: int): void {
    this.checkWidget__();
    if (width < 0)
      return;
    column.width = width;
  }
  public function TableColumn(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is Table && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is Table && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args0[0], TableColumn.checkStyle__I(args0[1])]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], TableColumn.checkStyle__I(args1[1])]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        TableColumn__Lorg_eclipse_swt_widgets_Table_2I(args0[0], args0[1]);
        break;
      case 1:
        TableColumn__Lorg_eclipse_swt_widgets_Table_2II(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const TableColumn__Lorg_eclipse_swt_widgets_Table_2I : int = 0;
  public static const TableColumn__Lorg_eclipse_swt_widgets_Table_2II : int = 1;
}
}
