package org.eclipse.swt.widgets {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TableItem extends Item {
  internal var parent: Table;
  internal var images: JavaArray;
  internal var strings: JavaArray;
  internal var checked: Boolean;
  internal var grayed: Boolean;
  internal var cached: Boolean;
  public function TableItem__Lorg_eclipse_swt_widgets_Table_2I(parent: Table, style: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_TableItem_2I(this, parent.getItemCount__());
    return this;
  }
  public function TableItem__Lorg_eclipse_swt_widgets_Table_2II(parent: Table, style: int, index: int): Object {
    this.parent = parent;
    parent.createItem__Lorg_eclipse_swt_widgets_TableItem_2I(this, index);
    return this;
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
    return;
  }
  public function clear__(): void {
    text = "";
    image = null;
    strings = null;
    images = null;
    checked = grayed = cached = false;
    return;
  }
  public override function destroyWidget__(): void {
    parent.destroyItem__Lorg_eclipse_swt_widgets_TableItem_2(this);
    this.releaseHandle__();
    return;
  }
  public function getBackground__(): Color {
    return parent.getBackground__();
  }
  public function getBackground__I(index: int): Color {
    return this.getBackground__();
  }
  public function getBounds__(): Rectangle {
    return null;
  }
  public function getBounds__I(index: int): Rectangle {
    return null;
  }
  public function getChecked__(): Boolean {
    this.checkWidget__();
    return checked;
  }
  public function getFont__(): Font {
    return parent.getFont__();
  }
  public function getFont__I(index: int): Font {
    return this.getFont__();
  }
  public function getForeground__(): Color {
    return parent.getForeground__();
  }
  public function getForeground__I(index: int): Color {
    return this.getForeground__();
  }
  public function getGrayed__(): Boolean {
    return false;
  }
  public override function getImage__(): Image {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TableItem_2(this))
      this.error__I(24);
    return super.getImage__();
  }
  public function getImage__I(index: int): Image {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TableItem_2(this))
      this.error__I(24);
    if (index == 0)
      return this.getImage__();
    if (images !== null) {
      if (0 <= index && index < images.length)
        return images[index];
    }
    return null;
  }
  public function getImageBounds__I(index: int): Rectangle {
    return null;
  }
  public function getImageIndent__(): int {
    return 0;
  }
  public function getParent__(): Table {
    this.checkWidget__();
    return parent;
  }
  public override function getText__(): String {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TableItem_2(this))
      this.error__I(24);
    return super.getText__();
  }
  public function getText__I(index: int): String {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TableItem_2(this))
      this.error__I(24);
    if (index == 0)
      return this.getText__();
    if (strings !== null) {
      if (0 <= index && index < strings.length) {
        var string: String = strings[index];
        return string !== null ? string : "";
      }
    }
    return "";
  }
  public function getTextBounds__I(index: int): Rectangle {
    return null;
  }
  public override function releaseHandle__(): void {
    super.releaseHandle__();
    object = null;
    parent = null;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    strings = null;
    images = null;
  }
  public function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
  }
  public function setBackground__ILorg_eclipse_swt_graphics_Color_2(index: int, color: Color): void {
  }
  public function setChecked__Z(checked_1: Boolean): void {
    this.checkWidget__();
    if ((parent.style & 32) == 0)
      return;
    if (this.checked == checked_1)
      return;
    this.checked = checked_1;
    cached = true;
    parent.invalidateItem__Lorg_eclipse_swt_widgets_TableItem_2I(this, 0);
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font: Font): void {
  }
  public function setFont__ILorg_eclipse_swt_graphics_Font_2(index: int, font: Font): void {
  }
  public function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
  }
  public function setForeground__ILorg_eclipse_swt_graphics_Color_2(index: int, color: Color): void {
  }
  public function setGrayed__Z(grayed_1: Boolean): void {
  }
  public function setImage___3Lorg_eclipse_swt_graphics_Image_2(images_1: JavaArray): void {
    this.checkWidget__();
    if (images_1 === null)
      this.error__I(4);
    for (var i: int = 0; i < images_1.length; i++) {
      this.setImage__ILorg_eclipse_swt_graphics_Image_2(i, images_1[i]);
    }
    return;
  }
  public function setImage__ILorg_eclipse_swt_graphics_Image_2(index: int, image_1: Image): void {
    this.checkWidget__();
    if (image_1 !== null && image_1.isDisposed__()) {
      this.error__I(5);
    }
    var itemIndex: int = parent.indexOf__Lorg_eclipse_swt_widgets_TableItem_2(this);
    if (itemIndex == -1)
      return;
    if (index == 0) {
      if (image_1 !== null && image_1.type == 1) {
        if (image_1.equals__Ljava_lang_Object_2(this.image))
          return;
      }
      super.setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
    }
    var count: int = Math__.max__II(1, parent.getColumnCount__());
    if (0 <= index && index < count) {
      if (images === null)
        images = new JavaArray("[Lorg/eclipse/swt/graphics/Image;").lengths(count);
      if (image_1 !== null && image_1.type == 1) {
        if (image_1.equals__Ljava_lang_Object_2(images[index]))
          return;
      }
      images[index] = image_1;
    }
    cached = true;
    parent.invalidateItem__Lorg_eclipse_swt_widgets_TableItem_2I(this, index);
    return;
  }
  public override function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    this.setImage__ILorg_eclipse_swt_graphics_Image_2(0, image_1);
    return;
  }
  public function setImageIndent__I(indent: int): void {
    this.checkWidget__();
    if (indent < 0)
      return;
    cached = true;
  }
  public function setText___3Ljava_lang_String_2(strings_1: JavaArray): void {
    this.checkWidget__();
    if (strings_1 === null)
      this.error__I(4);
    for (var i: int = 0; i < strings_1.length; i++) {
      var string: String = strings_1[i];
      if (string !== null)
        this.setText__ILjava_lang_String_2(i, string);
    }
    return;
  }
  public function setText__ILjava_lang_String_2(index: int, string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if (index == 0) {
      if (Object(string).equals__Ljava_lang_Object_2(text))
        return;
      super.setText__Ljava_lang_String_2(string);
    }
    var count: int = Math__.max__II(1, parent.getColumnCount__());
    if (0 <= index && index < count) {
      if (strings === null)
        strings = new JavaArray("[Ljava/lang/String;").lengths(count);
      if (Object(string).equals__Ljava_lang_Object_2(strings[index]))
        return;
      strings[index] = string;
    }
    cached = true;
    parent.invalidateItem__Lorg_eclipse_swt_widgets_TableItem_2I(this, index);
    return;
  }
  public override function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    this.setText__ILjava_lang_String_2(0, string);
    return;
  }
  public function TableItem(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is Table && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is Table && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args0[0], args0[1]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args1[0], args1[1]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        TableItem__Lorg_eclipse_swt_widgets_Table_2I(args0[0], args0[1]);
        break;
      case 1:
        TableItem__Lorg_eclipse_swt_widgets_Table_2II(args1[0], args1[1], args1[2]);
        break;
    }
  }
  public static const TableItem__Lorg_eclipse_swt_widgets_Table_2I : int = 0;
  public static const TableItem__Lorg_eclipse_swt_widgets_Table_2II : int = 1;
}
}
