package org.eclipse.swt.widgets {
import mx.controls.*;
import mx.core.EdgeMetrics;
import mx.core.ScrollControlBase;
import mx.events.FlexEvent;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import mx.controls.TextInput;
import mx.controls.TextArea;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class Text extends Scrollable {
  public static const LIMIT: int = 0x7FFFFFFF;
  public static const DELIMITER: String = "\n";
  public function Text(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Scrollable.Scrollable__Lorg_eclipse_swt_widgets_Composite_2I, [parent, Text.checkStyle__I(style)]));
    return;
  }
  public function addModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(listener: ModifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(24, typedListener);
    return;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(13, typedListener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(14, typedListener);
    return;
  }
  public function addVerifyListener__Lorg_eclipse_swt_events_VerifyListener_2(listener: VerifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(25, typedListener);
    return;
  }
  public function append__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if ((style & 4) != 0) {
      (TextInput(object)).text += string;
    } else {
      (TextArea(object)).text += string;
    }
    return;
  }
  public static function checkStyle__I(style: int): int {
    if ((style & 128) != 0) {
      style |= 4 | 2048;
      style &= ~4194304;
    }
    style &= ~128;
    if ((style & 4) != 0 && (style & 2) != 0) {
      style &= ~2;
    }
    style = Widget.checkBits__IIIIIII(style, 16384, 16777216, 131072, 0, 0, 0);
    if ((style & 4) != 0)
      style &= ~(256 | 512 | 64);
    if ((style & 64) != 0) {
      style |= 2;
      style &= ~256;
    }
    if ((style & 2) != 0)
      style &= ~4194304;
    if ((style & (4 | 2)) != 0)
      return style;
    if ((style & (256 | 512)) != 0)
      return style | 2;
    return style | 4;
  }
  public function clearSelection__(): void {
    this.checkWidget__();
    var selection: Point = this.getSelection__();
    this.setSelection__I(selection.x);
  }
  public function copy__(): void {
    this.checkWidget__();
  }
  public override function computeTrim__IIII(x_1: int, y_1: int, width_1: int, height_1: int): Rectangle {
    this.checkWidget__();
    if ((style & 2) != 0) {
      var widget: ScrollControlBase = ScrollControlBase(object);
      var view: EdgeMetrics = widget.viewMetrics;
      x_1 -= view.left;
      y_1 -= view.top;
      width_1 += (view.left + view.right);
      height_1 += (view.top + view.bottom);
    }
    return new Rectangle(x_1, y_1, width_1, height_1);
  }
  public override function createHandle__(): void {
    if ((style & 4) != 0) {
      var widget: TextInput = new TextInput();
      if (widget === null)
        this.error__I(2);
      widget.editable = (style & 8) == 0;
      object = widget;
    } else {
      var widget_1: TextArea = new TextArea();
      if (widget_1 === null)
        this.error__I(2);
      widget_1.editable = (style & 8) == 0;
      object = widget_1;
    }
    object.setStyle("borderStyle", this.hasBorder__() ? "inset" : "none");
    return;
  }
  public function cut__(): void {
    this.checkWidget__();
    return;
  }
  public function enterHandler__Lmx_events_FlexEvent_2(event: FlexEvent): void {
    this.postEvent__I(14);
    return;
  }
  public function enterHandlerFunction__(): Function {
    return enterHandler__Lmx_events_FlexEvent_2;
  }
  public function getCaretLineNumber__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getCaretLocation__(): Point {
    this.checkWidget__();
    return null;
  }
  public function getCaretPosition__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getCharCount__(): int {
    this.checkWidget__();
    if ((style & 4) != 0) {
      return (TextInput(object)).length;
    } else {
      return (TextArea(object)).length;
    }
    return 0;
  }
  public function getDoubleClickEnabled__(): Boolean {
    this.checkWidget__();
    return false;
  }
  public function getEchoChar__(): uint {
    this.checkWidget__();
    return 0;
  }
  public function getEditable__(): Boolean {
    this.checkWidget__();
    if ((style & 4) != 0) {
      return (TextInput(object)).editable;
    } else {
      return (TextArea(object)).editable;
    }
    return false;
  }
  public function getLineCount__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getLineDelimiter__(): String {
    this.checkWidget__();
    return "\n";
  }
  public function getLineHeight__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getOrientation__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getMessage__(): String {
    this.checkWidget__();
    return "";
  }
  public function getSelection__(): Point {
    this.checkWidget__();
    if ((style & 4) != 0) {
      var widget: TextInput = TextInput(object);
      return new Point(widget.selectionBeginIndex, widget.selectionEndIndex);
    } else {
      var widget_1: TextArea = TextArea(object);
      return new Point(widget_1.selectionBeginIndex, widget_1.selectionEndIndex);
    }
    return null;
  }
  public function getSelectionCount__(): int {
    this.checkWidget__();
    var selection: Point = this.getSelection__();
    return selection.y - selection.x;
  }
  public function getSelectionText__(): String {
    this.checkWidget__();
    var selection: Point = this.getSelection__();
    return this.getText__II(selection.x, selection.y);
  }
  public function getTabs__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getText__(): String {
    this.checkWidget__();
    if ((style & 4) != 0) {
      return (TextInput(object)).text;
    } else {
      return (TextArea(object)).text;
    }
    return null;
  }
  public function getText__II(start: int, end: int): String {
    this.checkWidget__();
    if (!(start <= end && 0 <= end))
      return "";
    var length: int = this.getCharCount__();
    start = Math__.max__II(0, start);
    end = Math__.min__II(end, length - 1);
    if ((style & 4) != 0) {
      return Object((TextInput(object)).text).substring__II(start, end);
    } else {
      return Object((TextArea(object)).text).substring__II(start, end);
    }
    return null;
  }
  public function getTextLimit__(): int {
    this.checkWidget__();
    var limit: int;
    if ((style & 4) != 0) {
      limit = (TextInput(object)).maxChars;
    } else {
      limit = (TextArea(object)).maxChars;
    }
    return limit != 0 ? limit : 2147483647;
  }
  public function getTopIndex__(): int {
    this.checkWidget__();
    return 0;
  }
  public function getTopPixel__(): int {
    this.checkWidget__();
    return 0;
  }
  public override function hookEvents__(): void {
    super.hookEvents__();
    object.addEventListener(FlexEvent.ENTER, this.enterHandlerFunction__());
  }
  public function insert__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
  }
  public function paste__(): void {
    this.checkWidget__();
  }
  public function removeModifyListener__Lorg_eclipse_swt_events_ModifyListener_2(listener: ModifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(24, listener);
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(13, listener);
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(14, listener);
  }
  public function removeVerifyListener__Lorg_eclipse_swt_events_VerifyListener_2(listener: VerifyListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(25, listener);
  }
  public function selectAll__(): void {
    this.checkWidget__();
    this.setSelection__II(0, this.getCharCount__());
  }
  public function setDoubleClickEnabled__Z(doubleClick: Boolean): void {
    this.checkWidget__();
  }
  public function setEchoChar__C(echo: uint): void {
    this.checkWidget__();
  }
  public function setEditable__Z(editable: Boolean): void {
    this.checkWidget__();
    if ((style & 4) != 0) {
      (TextInput(object)).editable = editable;
    } else {
      (TextArea(object)).editable = editable;
    }
    return;
  }
  public function setMessage__Ljava_lang_String_2(message: String): void {
    this.checkWidget__();
    return;
  }
  public function setOrientation__I(orientation: int): void {
    this.checkWidget__();
    return;
  }
  public function setSelection__I(start: int): void {
    this.checkWidget__();
    this.setSelection__II(start, start);
    return;
  }
  public function setSelection__II(start: int, end: int): void {
    this.checkWidget__();
    if ((style & 4) != 0) {
      (TextInput(object)).setSelection(start, end);
    } else {
      (TextArea(object)).setSelection(start, end);
    }
    return;
  }
  public function setSelection__Lorg_eclipse_swt_graphics_Point_2(selection: Point): void {
    this.checkWidget__();
    return;
  }
  public function setTabs__I(tabs: int): void {
    this.checkWidget__();
    return;
  }
  public function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if ((style & 4) != 0) {
      (TextInput(object)).text = string;
    } else {
      (TextArea(object)).text = string;
    }
    return;
  }
  public function setTextLimit__I(limit: int): void {
    this.checkWidget__();
    if (limit == 2147483647)
      limit = 0;
    if ((style & 4) != 0) {
      (TextInput(object)).maxChars = limit;
    } else {
      (TextArea(object)).maxChars = limit;
    }
    return;
  }
  public function setTopIndex__I(index: int): void {
    this.checkWidget__();
    return;
  }
  public function showSelection__(): void {
    this.checkWidget__();
    return;
  }
}
}
