package org.eclipse.swt.widgets {
import flash.display.DisplayObjectContainer;
import mx.collections.ArrayCollection;
import mx.containers.BoxDirection;
import mx.controls.ButtonBar;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Image;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ToolBar extends Composite {
  internal var items: ArrayCollection;
  public function ToolBar(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, ToolBar.checkStyle__I(style)]));
    if ((style & 512) != 0) {
      this.style |= 512;
    } else {
      this.style |= 256;
    }
    var orientation: String = (style & 512) != 0 ? BoxDirection.VERTICAL : BoxDirection.HORIZONTAL;
    (ButtonBar(object)).direction = orientation;
    return;
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
    return;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): Point {
    this.checkWidget__();
    return this.computeNativeSize__Lmx_core_UIComponent_2IIZ(object, wHint, hHint, changed);
  }
  public override function createHandle__(): void {
    var widget: ButtonBar = new ButtonBar();
    widget.dataProvider = items = new ArrayCollection();
    widget.labelFunction = this.getLabelFunction__();
    widget.iconField = "_image";
    object = widget;
  }
  public function createItem__Lorg_eclipse_swt_widgets_ToolItem_2I(item: ToolItem, index: int): void {
    if (!(0 <= index && index <= items.length))
      this.error__I(6);
    items.addItemAt(item, index);
  }
  public static function checkStyle__I(style: int): int {
    if ((style & 64) != 0)
      style &= ~64;
    return style & ~(256 | 512);
  }
  public override function _getImage__Lflash_display_DisplayObjectContainer_2(item: DisplayObjectContainer): Image {
    return (ToolItem(items.getItemAt(item.parent.getChildIndex(item)))).image;
  }
  public function getItem__I(index: int): ToolItem {
    this.checkWidget__();
    if (!(0 <= index && index < items.length))
      this.error__I(6);
    return ToolItem(items.getItemAt(index));
  }
  public function getItem__Lorg_eclipse_swt_graphics_Point_2(point: Point): ToolItem {
    this.checkWidget__();
    return null;
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    return items.length;
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/ToolItem;").lengths(items.length);
    for (var i: int = 0; i < result.length; i++) {
      result[i] = ToolItem(items.getItemAt(i));
    }
    return result;
  }
  public function labelFunction__Lorg_eclipse_swt_widgets_ToolItem_2(item: ToolItem): String {
    return item.getText__();
  }
  public function getLabelFunction__(): Function {
    return labelFunction__Lorg_eclipse_swt_widgets_ToolItem_2;
  }
  public function getRowCount__(): int {
    this.checkWidget__();
    return 1;
  }
  public function indexOf__Lorg_eclipse_swt_widgets_ToolItem_2(item: ToolItem): int {
    this.checkWidget__();
    return items.getItemIndex(item);
  }
}
}
