package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.SWT;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Tray extends Widget {
  internal var itemCount: int;
  internal var items: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TrayItem;").lengths(4);
  function Tray(display: Display, style: int) {
    if (display === null)
      display = Display.getCurrent__();
    if (display === null)
      display = Display.getDefault__();
    if (!display.isValidThread__()) {
      this.error__I(22);
    }
    this.display = display;
    return;
  }
  public function createItem__Lorg_eclipse_swt_widgets_TrayItem_2I(item: TrayItem, index: int): void {
    if (!(0 <= index && index <= itemCount))
      this.error__I(6);
    if (itemCount == items.length) {
      var newItems: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TrayItem;").lengths(items.length + 4);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, newItems, 0, items.length);
      items = newItems;
    }
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index, items, index + 1, itemCount++ - index);
    items[index] = item;
    return;
  }
  public function destroyItem__Lorg_eclipse_swt_widgets_TrayItem_2(item: TrayItem): void {
    var index: int = 0;
    while (index < itemCount) {
      if (items[index] === item)
        break;
      index++;
    }
    if (index == itemCount)
      return;
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, index + 1, items, index, --itemCount - index);
    items[itemCount] = null;
  }
  public function getItem__I(index: int): TrayItem {
    this.checkWidget__();
    if (!(0 <= index && index < itemCount))
      this.error__I(6);
    return items[index];
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    return itemCount;
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TrayItem;").lengths(itemCount);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(items, 0, result, 0, result.length);
    return result;
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    if (items !== null) {
      for (var i: int = 0; i < items.length; i++) {
        var item: TrayItem = items[i];
        if (item !== null && !item.isDisposed__()) {
          item.release__Z(false);
        }
      }
      items = null;
    }
    super.releaseChildren__Z(destroy);
    return;
  }
  public override function releaseParent__(): void {
    super.releaseParent__();
    if (display.tray === this)
      display.tray = null;
    return;
  }
}
}
