package org.eclipse.swt.widgets {
import flash.display.DisplayObjectContainer;
import mx.collections.ArrayCollection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.internal.flex.SWTTreeDataDescriptor;
import org.eclipse.swt.events.*;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import mx.controls.Tree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Font;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Tree extends Composite {
  internal var items: ArrayCollection;
  public function Tree(parent: Composite, style: int) {
    super(new Arguments(org.eclipse.swt.widgets.Composite.Composite__Lorg_eclipse_swt_widgets_Composite_2I, [parent, org.eclipse.swt.widgets.Tree.checkStyle__I(style)]));
    return;
  }
  public static function checkStyle__I(style: int): int {
    style |= 256 | 512;
    style |= 65536;
    return Widget.checkBits__IIIIIII(style, 4, 2, 0, 0, 0, 0);
  }
  public function createItem__Lorg_eclipse_swt_widgets_TreeItem_2Lorg_eclipse_swt_widgets_TreeItem_2I(item: TreeItem, parentItem: TreeItem, index: int): void {
    var items_1: ArrayCollection = parentItem !== null ? parentItem.items : this.items;
    var itemCount: int = items_1.length;
    if (!(0 <= index && index <= itemCount))
      this.error__I(6);
    item.createWidget__();
    items_1.addItemAt(item, index);
  }
  public function checkData__Lorg_eclipse_swt_widgets_TreeItem_2Z(item: TreeItem, redraw: Boolean): Boolean {
    if (item.cached)
      return true;
    if ((style & 268435456) != 0) {
      item.cached = true;
      var event: Event = new Event();
      var parentItem: TreeItem = item.getParentItem__();
      event.item = item;
      event.index = parentItem === null ? this.indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(item) : parentItem.indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(item);
      this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(36, event);
      if (this.isDisposed__() || item.isDisposed__())
        return false;
    }
    return true;
  }
  public function addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
  }
  public function addTreeListener__Lorg_eclipse_swt_events_TreeListener_2(listener: TreeListener): void {
  }
  public override function checkSubclass__(): void {
  }
  public function clear__IZ(index: int, all: Boolean): void {
  }
  public function clearAll__Z(all: Boolean): void {
  }
  public override function createHandle__(): void {
    var widget: mx.controls.Tree = new mx.controls.Tree();
    if ((style & 2) != 0)
      widget.allowMultipleSelection = true;
    widget.dataProvider = items = new ArrayCollection();
    widget.dataDescriptor = new SWTTreeDataDescriptor();
    widget.labelFunction = this.getLabelHandlerFunction__();
    widget.iconFunction = this.getImageHandlerFunction__();
    object = widget;
  }
  public function deselectAll__(): void {
  }
  public function destroyItem__Lorg_eclipse_swt_widgets_TreeItem_2(item: TreeItem): void {
    var index: int = items.getItemIndex(item);
    items.removeItemAt(index);
  }
  public function getGridLineWidth__(): int {
    return 0;
  }
  public function getHeaderHeight__(): int {
    return 0;
  }
  public function getHeaderVisible__(): Boolean {
    return false;
  }
  public function getColumn__I(index: int): TreeColumn {
    this.checkWidget__();
    var count: int = 0;
    if (!(0 <= index && index < count))
      this.error__I(6);
    return null;
  }
  public function getColumnCount__(): int {
    return 0;
  }
  public function getColumnOrder__(): JavaArray {
    return null;
  }
  public function getColumns__(): JavaArray {
    this.checkWidget__();
    return new JavaArray("[Lorg/eclipse/swt/widgets/TreeColumn;").lengths(0);
  }
  public function getItem__I(index: int): TreeItem {
    this.checkWidget__();
    if (!(0 <= index && index < items.length))
      this.error__I(6);
    return TreeItem(items.getItemAt(index));
  }
  public function getItem__Lorg_eclipse_swt_graphics_Point_2(point: Point): TreeItem {
    return null;
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    return items.length;
  }
  public function getItemHeight__(): int {
    return 0;
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TreeItem;").lengths(items.length);
    for (var i: int = 0; i < result.length; i++) {
      result[i] = TreeItem(items.getItemAt(i));
    }
    return result;
  }
  public override function _getImage__Lflash_display_DisplayObjectContainer_2(item: DisplayObjectContainer): Image {
    var widget: mx.controls.Tree = mx.controls.Tree(object);
    for (var i: int = 0; i < items.length; i++) {
      if (widget.itemToItemRenderer(items.getItemAt(i)) === item) {
        var treeItem: TreeItem = TreeItem(items.getItemAt(i));
        return treeItem.image;
      }
    }
    return null;
  }
  public function getImageHandler__Ljava_lang_Object_2(object_1: Object): Class {
    var item: TreeItem = TreeItem(object_1);
    var image: Image = item.getImage__();
    return image !== null ? SWTBitmapAsset.getClazz__() : null;
  }
  public function getImageHandlerFunction__(): Function {
    return getImageHandler__Ljava_lang_Object_2;
  }
  public function getLabelHandler__Ljava_lang_Object_2(object_1: Object): String {
    var item: TreeItem = TreeItem(object_1);
    return item.getText__();
  }
  public function getLabelHandlerFunction__(): Function {
    return getLabelHandler__Ljava_lang_Object_2;
  }
  public function getLinesVisible__(): Boolean {
    return false;
  }
  public function getParentItem__(): TreeItem {
    return null;
  }
  public function getSelection__(): JavaArray {
    return null;
  }
  public function getSelectionCount__(): int {
    return 0;
  }
  public function getSortColumn__(): TreeColumn {
    return null;
  }
  public function getSortDirection__(): int {
    return 0;
  }
  public function getTopItem__(): TreeItem {
    return null;
  }
  public function indexOf__Lorg_eclipse_swt_widgets_TreeColumn_2(column: TreeColumn): int {
    return 0;
  }
  public function indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(item: TreeItem): int {
    return 0;
  }
  public function invalidateItem__Lorg_eclipse_swt_widgets_TreeItem_2I(item: TreeItem, columnIndex: int): void {
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    if (items !== null) {
      var itemCount: int = items.length;
      for (var i: int = 0; i < itemCount; i++) {
        var item: TreeItem = TreeItem(items.getItemAt(i));
        if (item !== null && !item.isDisposed__()) {
          item.release__Z(false);
        }
      }
    }
    super.releaseChildren__Z(destroy);
    return;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    items = null;
    return;
  }
  public function removeAll__(): void {
  }
  public function removeSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(listener: SelectionListener): void {
  }
  public function removeTreeListener__Lorg_eclipse_swt_events_TreeListener_2(listener: TreeListener): void {
  }
  public function setInsertMark__Lorg_eclipse_swt_widgets_TreeItem_2Z(item: TreeItem, before: Boolean): void {
  }
  public function setItemCount__I(count: int): void {
  }
  public function setLinesVisible__Z(show: Boolean): void {
  }
  public function selectAll__(): void {
  }
  public function setColumnOrder___3I(order: JavaArray): void {
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
  }
  public function setHeaderVisible__Z(show: Boolean): void {
  }
  public override function setRedraw__Z(redraw: Boolean): void {
  }
  public function setSelection__Lorg_eclipse_swt_widgets_TreeItem_2(item: TreeItem): void {
  }
  public function setSelection___3Lorg_eclipse_swt_widgets_TreeItem_2(items_1: JavaArray): void {
  }
  public function setSortColumn__Lorg_eclipse_swt_widgets_TreeColumn_2(column: TreeColumn): void {
  }
  public function setSortDirection__I(direction: int): void {
  }
  public function setTopItem__Lorg_eclipse_swt_widgets_TreeItem_2(item: TreeItem): void {
  }
  public function showColumn__Lorg_eclipse_swt_widgets_TreeColumn_2(column: TreeColumn): void {
  }
  public function showItem__Lorg_eclipse_swt_widgets_TreeItem_2(item: TreeItem): void {
  }
  public function showSelection__(): void {
  }
}
}
