package org.eclipse.swt.widgets {
import mx.collections.ArrayCollection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class TreeItem extends Item {
  public var items: ArrayCollection;
  internal var parent: Tree;
  internal var parentItem: TreeItem;
  internal var images: JavaArray;
  internal var strings: JavaArray;
  internal var checked: Boolean;
  internal var grayed: Boolean;
  internal var cached: Boolean;
  public function TreeItem__Lorg_eclipse_swt_widgets_Tree_2I(parent: Tree, style: int): Object {
    return this;
  }
  public function TreeItem__Lorg_eclipse_swt_widgets_Tree_2II(parent: Tree, style: int, index: int): Object {
    return this;
  }
  public function TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2I(parentItem: TreeItem, style: int): Object {
    return this;
  }
  public function TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2II(parentItem: TreeItem, style: int, index: int): Object {
    return this;
  }
  public function TreeItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2IIZ(parent: Tree, parentItem: TreeItem, style: int, index: int, create: Boolean): Object {
    this.parent = parent;
    this.parentItem = parentItem;
    if (create)
      parent.createItem__Lorg_eclipse_swt_widgets_TreeItem_2Lorg_eclipse_swt_widgets_TreeItem_2I(this, parentItem, index);
    return this;
  }
  public static function checkNull__Lorg_eclipse_swt_widgets_TreeItem_2(item: TreeItem): TreeItem {
    if (item === null)
      SWT.error__I(4);
    return item;
  }
  public static function checkNull__Lorg_eclipse_swt_widgets_Tree_2(tree: Tree): Tree {
    if (tree === null)
      SWT.error__I(4);
    return tree;
  }
  public override function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
  }
  public function clear__(): void {
    cached = false;
    text = "";
    image = null;
    strings = null;
    images = null;
    checked = grayed = false;
  }
  public function clear__IZ(index: int, all: Boolean): void {
    this.checkWidget__();
    var count: int = items.length;
    if (index < 0 || index >= count)
      SWT.error__I(6);
    var item: TreeItem = TreeItem(items.getItemAt(index));
    item.clear__();
    if (all)
      item.clearAll__Z(true);
    parent.invalidateItem__Lorg_eclipse_swt_widgets_TreeItem_2I(item, 0);
  }
  public function clearAll__Z(all: Boolean): void {
    this.checkWidget__();
    var count: int = items.length;
    for (var i: int = 0; i < count; i++) {
      this.clear__IZ(i, all);
    }
    return;
  }
  public override function createWidget__(): void {
    super.createWidget__();
    items = new ArrayCollection();
    return;
  }
  public override function destroyWidget__(): void {
    parent.destroyItem__Lorg_eclipse_swt_widgets_TreeItem_2(this);
    this.releaseHandle__();
    return;
  }
  public function getBackground__(): Color {
    return parent.getBackground__();
  }
  public function getBackground__I(index: int): Color {
    return this.getBackground__();
  }
  public function getBounds__(): Rectangle {
    return null;
  }
  public function getBounds__I(index: int): Rectangle {
    return null;
  }
  public function getChecked__(): Boolean {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TreeItem_2Z(this, true))
      this.error__I(24);
    if ((parent.style & 32) == 0)
      return false;
    return checked;
  }
  public function getExpanded__(): Boolean {
    return false;
  }
  public function getFont__(): Font {
    return parent.getFont__();
  }
  public function getFont__I(index: int): Font {
    return this.getFont__();
  }
  public function getForeground__(): Color {
    return parent.getForeground__();
  }
  public function getForeground__I(index: int): Color {
    return this.getForeground__();
  }
  public function getGrayed__(): Boolean {
    return false;
  }
  public function getItem__I(index: int): TreeItem {
    this.checkWidget__();
    if (!(0 <= index && index < items.length))
      this.error__I(6);
    return TreeItem(items.getItemAt(index));
  }
  public function getItemCount__(): int {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TreeItem_2Z(this, true))
      this.error__I(24);
    return items.length;
  }
  public function getItems__(): JavaArray {
    this.checkWidget__();
    var result: JavaArray = new JavaArray("[Lorg/eclipse/swt/widgets/TreeItem;").lengths(items.length);
    for (var i: int = 0; i < result.length; i++) {
      result[i] = TreeItem(items.getItemAt(i));
    }
    return result;
  }
  public override function getImage__(): Image {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TreeItem_2Z(this, true))
      this.error__I(24);
    return super.getImage__();
  }
  public function getImage__I(index: int): Image {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TreeItem_2Z(this, true))
      this.error__I(24);
    if (index == 0)
      return this.getImage__();
    if (images !== null) {
      if (0 <= index && index < images.length)
        return images[index];
    }
    return null;
  }
  public function getImageBounds__I(index: int): Rectangle {
    return null;
  }
  public function getParent__(): Tree {
    this.checkWidget__();
    return parent;
  }
  public function getParentItem__(): TreeItem {
    this.checkWidget__();
    return parentItem;
  }
  public override function getText__(): String {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TreeItem_2Z(this, true))
      this.error__I(24);
    return super.getText__();
  }
  public function getText__I(index: int): String {
    this.checkWidget__();
    if (!parent.checkData__Lorg_eclipse_swt_widgets_TreeItem_2Z(this, true))
      this.error__I(24);
    if (index == 0)
      return this.getText__();
    if (strings !== null) {
      if (0 <= index && index < strings.length) {
        var string: String = strings[index];
        return string !== null ? string : "";
      }
    }
    return "";
  }
  public function getTextBounds__I(index: int): Rectangle {
    return null;
  }
  public function indexOf__Lorg_eclipse_swt_widgets_TreeItem_2(item: TreeItem): int {
    this.checkWidget__();
    if (item === null)
      this.error__I(4);
    if (item.isDisposed__())
      this.error__I(5);
    if (item.parentItem !== this)
      return -1;
    return 0;
  }
  public override function releaseChildren__Z(destroy: Boolean): void {
    if (destroy) {
    }
    super.releaseChildren__Z(destroy);
    return;
  }
  public override function releaseHandle__(): void {
    super.releaseHandle__();
    object = null;
    items = null;
    parentItem = null;
    parent = null;
    return;
  }
  public override function releaseWidget__(): void {
    super.releaseWidget__();
    strings = null;
    images = null;
    return;
  }
  public function removeAll__(): void {
  }
  public function setBackground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
  }
  public function setBackground__ILorg_eclipse_swt_graphics_Color_2(index: int, color: Color): void {
  }
  public function setChecked__Z(checked_1: Boolean): void {
  }
  public function setExpanded__Z(expanded: Boolean): void {
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font: Font): void {
  }
  public function setFont__ILorg_eclipse_swt_graphics_Font_2(index: int, font: Font): void {
  }
  public function setForeground__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
  }
  public function setForeground__ILorg_eclipse_swt_graphics_Color_2(index: int, color: Color): void {
  }
  public function setGrayed__Z(grayed_1: Boolean): void {
  }
  public function setImage___3Lorg_eclipse_swt_graphics_Image_2(images_1: JavaArray): void {
    this.checkWidget__();
    if (images_1 === null)
      this.error__I(4);
    for (var i: int = 0; i < images_1.length; i++) {
      this.setImage__ILorg_eclipse_swt_graphics_Image_2(i, images_1[i]);
    }
    return;
  }
  public function setImage__ILorg_eclipse_swt_graphics_Image_2(index: int, image_1: Image): void {
    this.checkWidget__();
    if (image_1 !== null && image_1.isDisposed__()) {
      this.error__I(5);
    }
    if (index == 0) {
      if (image_1 !== null && image_1.type == 1) {
        if (image_1.equals__Ljava_lang_Object_2(this.image))
          return;
      }
      super.setImage__Lorg_eclipse_swt_graphics_Image_2(image_1);
    }
    var count: int = 1;
    if (0 <= index && index < count) {
      if (images === null)
        images = new JavaArray("[Lorg/eclipse/swt/graphics/Image;").lengths(count);
      if (image_1 !== null && image_1.type == 1) {
        if (image_1.equals__Ljava_lang_Object_2(images[index]))
          return;
      }
      images[index] = image_1;
    }
    cached = true;
    parent.invalidateItem__Lorg_eclipse_swt_widgets_TreeItem_2I(this, index);
    return;
  }
  public override function setImage__Lorg_eclipse_swt_graphics_Image_2(image_1: Image): void {
    this.checkWidget__();
    this.setImage__ILorg_eclipse_swt_graphics_Image_2(0, image_1);
    return;
  }
  public function setItemCount__I(count: int): void {
  }
  public function setText___3Ljava_lang_String_2(strings_1: JavaArray): void {
    this.checkWidget__();
    if (strings_1 === null)
      this.error__I(4);
    for (var i: int = 0; i < strings_1.length; i++) {
      var string: String = strings_1[i];
      if (string !== null)
        this.setText__ILjava_lang_String_2(i, string);
    }
    return;
  }
  public function setText__ILjava_lang_String_2(index: int, string: String): void {
    this.checkWidget__();
    if (string === null)
      this.error__I(4);
    if (index == 0) {
      if (Object(string).equals__Ljava_lang_Object_2(text))
        return;
      super.setText__Ljava_lang_String_2(string);
    }
    var count: int = 1;
    if (0 <= index && index < count) {
      if (strings === null)
        strings = new JavaArray("[Ljava/lang/String;").lengths(count);
      if (Object(string).equals__Ljava_lang_Object_2(strings[index]))
        return;
      strings[index] = string;
    }
    cached = true;
    parent.invalidateItem__Lorg_eclipse_swt_widgets_TreeItem_2I(this, index);
    return;
  }
  public override function setText__Ljava_lang_String_2(string: String): void {
    this.checkWidget__();
    this.setText__ILjava_lang_String_2(0, string);
    return;
  }
  public function TreeItem(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 2 && vargs[0] is Tree && vargs[1] is int) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 3 && vargs[0] is Tree && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is TreeItem && vargs[1] is int) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 3 && vargs[0] is TreeItem && vargs[1] is int && vargs[2] is int) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 5 && vargs[0] is Tree && vargs[1] is TreeItem && vargs[2] is int && vargs[3] is int && vargs[4] is Boolean) {
        args = vargs;
        id = 4;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1]];
        args4 = [TreeItem.checkNull__Lorg_eclipse_swt_widgets_Tree_2(args0[0]), null, args0[1], args0[0].getItemCount__(), true];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1], args[2]];
        args4 = [TreeItem.checkNull__Lorg_eclipse_swt_widgets_Tree_2(args1[0]), null, args1[1], args1[2], true];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        args4 = [TreeItem.checkNull__Lorg_eclipse_swt_widgets_TreeItem_2(args2[0]).parent, args2[0], args2[1], args2[0].getItemCount__(), true];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
      case 3:
        var args3: Array = [args[0], args[1], args[2]];
        args4 = [TreeItem.checkNull__Lorg_eclipse_swt_widgets_TreeItem_2(args3[0]).parent, args3[0], args3[1], args3[2], true];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
      case 4:
        var args4: Array = [args[0], args[1], args[2], args[3], args[4]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Item.Item__Lorg_eclipse_swt_widgets_Widget_2I, [args4[0], args4[2]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        TreeItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2IIZ(args4[0], args4[1], args4[2], args4[3], args4[4]);
        TreeItem__Lorg_eclipse_swt_widgets_Tree_2I(args0[0], args0[1]);
        break;
      case 1:
        TreeItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2IIZ(args4[0], args4[1], args4[2], args4[3], args4[4]);
        TreeItem__Lorg_eclipse_swt_widgets_Tree_2II(args1[0], args1[1], args1[2]);
        break;
      case 2:
        TreeItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2IIZ(args4[0], args4[1], args4[2], args4[3], args4[4]);
        TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2I(args2[0], args2[1]);
        break;
      case 3:
        TreeItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2IIZ(args4[0], args4[1], args4[2], args4[3], args4[4]);
        TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2II(args3[0], args3[1], args3[2]);
        break;
      case 4:
        TreeItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2IIZ(args4[0], args4[1], args4[2], args4[3], args4[4]);
        break;
    }
  }
  public static const TreeItem__Lorg_eclipse_swt_widgets_Tree_2I : int = 0;
  public static const TreeItem__Lorg_eclipse_swt_widgets_Tree_2II : int = 1;
  public static const TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2I : int = 2;
  public static const TreeItem__Lorg_eclipse_swt_widgets_TreeItem_2II : int = 3;
  public static const TreeItem__Lorg_eclipse_swt_widgets_Tree_2Lorg_eclipse_swt_widgets_TreeItem_2IIZ : int = 4;
}
}
