package org.eclipse.swt.widgets {
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.*;
import org.eclipse.swt.events.*;
import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import mx.core.*;
import mx.core.UIComponent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.SWT;
import java.lang.Thread;
import org.eclipse.swt.internal.SWTEventListener;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class Widget {
  internal var style: int;
  internal var state: int;
  internal var display: Display;
  internal var eventTable: EventTable;
  internal var data: Object;
  public var object: UIComponent;
  public static const DISPOSED: int = 1 << 0;
  public static const RELEASED: int = 1 << 1;
  public static const DISPOSE_SENT: int = 1 << 2;
  public static const KEYED_DATA: int = 1 << 3;
  public static const CANVAS: int = 1 << 4;
  public static const DISABLED: int = 1 << 5;
  public static const HIDDEN: int = 1 << 6;
  public static const LAYOUT_NEEDED: int = 1 << 7;
  public static const LAYOUT_CHANGED: int = 1 << 8;
  public static const LAYOUT_CHILD: int = 1 << 9;
  public static const DEFAULT_WIDTH: int = 64;
  public static const DEFAULT_HEIGHT: int = 64;
  public static const DRAG_DETECT: int = 1 << 10;
  public static const FOREIGN_HANDLE: int = 1 << 11;
  public static const MOVED: int = 1 << 12;
  public static const RESIZED: int = 1 << 13;
  public static const PARENT_BACKGROUND: int = 1 << 14;
  public function Widget__(): Object {
    this.checkSubclass__();
    return this;
  }
  public function Widget__Lorg_eclipse_swt_widgets_Widget_2I(parent: Widget, style: int): Object {
    this.checkSubclass__();
    this.checkParent__Lorg_eclipse_swt_widgets_Widget_2(parent);
    this.style = style;
    display = parent.display;
    return this;
  }
  public function addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(listener: DisposeListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    var typedListener: TypedListener = new TypedListener(listener);
    this.addListener__ILorg_eclipse_swt_widgets_Listener_2(12, typedListener);
    return;
  }
  public function _addListener__ILorg_eclipse_swt_widgets_Listener_2(eventType: int, listener: Listener): void {
    if (eventTable === null)
      eventTable = new EventTable();
    eventTable.hook__ILorg_eclipse_swt_widgets_Listener_2(eventType, listener);
    return;
  }
  public function addListener__ILorg_eclipse_swt_widgets_Listener_2(eventType: int, listener: Listener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    this._addListener__ILorg_eclipse_swt_widgets_Listener_2(eventType, listener);
    return;
  }
  public static function checkBits__IIIIIII(style: int, int0: int, int1: int, int2: int, int3: int, int4: int, int5: int): int {
    var mask: int = int0 | int1 | int2 | int3 | int4 | int5;
    if ((style & mask) == 0)
      style |= int0;
    if ((style & int0) != 0)
      style = (style & ~mask) | int0;
    if ((style & int1) != 0)
      style = (style & ~mask) | int1;
    if ((style & int2) != 0)
      style = (style & ~mask) | int2;
    if ((style & int3) != 0)
      style = (style & ~mask) | int3;
    if ((style & int4) != 0)
      style = (style & ~mask) | int4;
    if ((style & int5) != 0)
      style = (style & ~mask) | int5;
    return style;
  }
  public function checkComponent__Lflash_display_DisplayObject_2(component: DisplayObject): Boolean {
    return true;
  }
  public function checkHandle__I(handle: int): Boolean {
    return false;
  }
  public function checkOpened__(): void {
  }
  public function checkParent__Lorg_eclipse_swt_widgets_Widget_2(parent: Widget): void {
    if (parent === null)
      this.error__I(4);
    if (parent.isDisposed__())
      this.error__I(5);
    parent.checkWidget__();
    parent.checkOpened__();
  }
  public function checkSubclass__(): void {
    if (!this.isValidSubclass__())
      this.error__I(43);
  }
  public function checkWidget__(): void {
    var display_1: Display = this.display;
    if (display_1 === null)
      this.error__I(24);
    if (display_1.thread !== Thread.currentThread__())
      this.error__I(22);
    if ((state & 1) != 0)
      this.error__I(24);
  }
  public function createHandle__(): void {
  }
  public function createWidget__(): void {
    this.createHandle__();
    this.hookEvents__();
    this.register__();
  }
  public function arrayGet__LArray_2I(array: Array, index: int): Object {
    return array[index];
  }
  public function arrayGetInt__LArray_2I(array: Array, index: int): int {
    return array[index];
  }
  public function arraySet__LArray_2ILjava_lang_Object_2(array: Array, index: int, value: Object): void {
    array[index] = value;
  }
  public function deregister__(): void {
    display.removeWidget__Lmx_core_UIComponent_2(object);
  }
  public function destroyWidget__(): void {
    this.releaseHandle__();
  }
  public function dispose__(): void {
    if (this.isDisposed__())
      return;
    if (!this.isValidThread__())
      this.error__I(22);
    this.release__Z(true);
  }
  public function error__I(code: int): void {
    SWT.error__I(code);
  }
  public function filters__I(eventType: int): Boolean {
    return display.filters__I(eventType);
  }
  public function fixMnemonic__Ljava_lang_String_2(str: String): String {
    var buffer: JavaArray = new JavaArray("[C").lengths(Object(str).length__());
    Object(str).getChars__II_3CI(0, buffer.length, buffer, 0);
    var i: int = 0;
    var j: int = 0;
    while (i < buffer.length) {
      if ((buffer[j++] = buffer[i++]) == 38) {
        if (i != buffer.length) {
          if (buffer[i] == 38) {
            i++;
            j++;
          }
          j--;
        }
      }
    }
    return Object(String).__init___3CII(buffer, 0, j);
  }
  public function getData__(): Object {
    this.checkWidget__();
    return (state & 8) != 0 ? (JavaArray(data))[0] : data;
  }
  public function getData__Ljava_lang_String_2(key: String): Object {
    this.checkWidget__();
    if (key === null)
      this.error__I(4);
    if ((state & 8) != 0) {
      var table: JavaArray = JavaArray(data);
      for (var i: int = 1; i < table.length; i += 2) {
        if (Object(key).equals__Ljava_lang_Object_2(table[i]))
          return table[i + 1];
      }
    }
    return null;
  }
  public function getDisplay__(): Display {
    var display_1: Display = this.display;
    if (display_1 === null)
      this.error__I(24);
    return display_1;
  }
  public function _getImage__Lflash_display_DisplayObjectContainer_2(item: DisplayObjectContainer): Image {
    return null;
  }
  public function getListeners__I(eventType: int): JavaArray {
    this.checkWidget__();
    if (eventTable === null)
      return new JavaArray("[Lorg/eclipse/swt/widgets/Listener;").lengths(0);
    return eventTable.getListeners__I(eventType);
  }
  public function getName__(): String {
    var string: String = Object(this).getClass__().getName__();
    var index: int = Object(string).lastIndexOf__I(46);
    if (index == -1)
      return string;
    return Object(string).substring__II(index + 1, Object(string).length__());
  }
  public function getNameText__(): String {
    return "";
  }
  public function getStyle__(): int {
    this.checkWidget__();
    return style;
  }
  public function hookEvents__(): void {
  }
  public function hooks__I(eventType: int): Boolean {
    if (eventTable === null)
      return false;
    return eventTable.hooks__I(eventType);
  }
  public function isDisposed__(): Boolean {
    return (state & 1) != 0;
  }
  public function isListening__I(eventType: int): Boolean {
    this.checkWidget__();
    return this.hooks__I(eventType);
  }
  public function isValidSubclass__(): Boolean {
    return Display.isValidClass__Ljava_lang_Class_2(Object(this).getClass__());
  }
  public function isValidThread__(): Boolean {
    return this.getDisplay__().isValidThread__();
  }
  public function notifyListeners__ILorg_eclipse_swt_widgets_Event_2(eventType: int, event: Event): void {
    this.checkWidget__();
    if (event === null)
      event = new Event();
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2(eventType, event);
  }
  public function postEvent__I(eventType: int): void {
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2Z(eventType, null, false);
  }
  public function postEvent__ILorg_eclipse_swt_widgets_Event_2(eventType: int, event: Event): void {
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2Z(eventType, event, false);
  }
  public function register__(): void {
    display.addWidget__Lmx_core_UIComponent_2Lorg_eclipse_swt_widgets_Widget_2(object, this);
  }
  public function release__Z(destroy: Boolean): void {
    if ((state & 4) == 0) {
      state |= 4;
      this.sendEvent__I(12);
    }
    if ((state & 1) == 0) {
      this.releaseChildren__Z(destroy);
    }
    if ((state & 2) == 0) {
      state |= 2;
      if (destroy) {
        this.releaseParent__();
        this.releaseWidget__();
        this.destroyWidget__();
      } else {
        this.releaseWidget__();
        this.releaseHandle__();
      }
    }
    return;
  }
  public function releaseChildren__Z(destroy: Boolean): void {
  }
  public function releaseHandle__(): void {
    state |= 1;
    display = null;
    return;
  }
  public function releaseParent__(): void {
  }
  public function releaseWidget__(): void {
    this.deregister__();
    eventTable = null;
    data = null;
    return;
  }
  public function removeDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(listener: DisposeListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(12, listener);
  }
  public function removeListener__ILorg_eclipse_swt_widgets_Listener_2(eventType: int, listener: Listener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_widgets_Listener_2(eventType, listener);
  }
  public function removeListener__ILorg_eclipse_swt_internal_SWTEventListener_2(eventType: int, listener: SWTEventListener): void {
    this.checkWidget__();
    if (listener === null)
      this.error__I(4);
    if (eventTable === null)
      return;
    eventTable.unhook__ILorg_eclipse_swt_internal_SWTEventListener_2(eventType, listener);
  }
  public function sendEvent__Lorg_eclipse_swt_widgets_Event_2(event: Event): void {
    var display_1: Display = event.display;
    if (!display_1.filterEvent__Lorg_eclipse_swt_widgets_Event_2(event)) {
      if (eventTable !== null)
        eventTable.sendEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function sendEvent__I(eventType: int): void {
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2Z(eventType, null, true);
    return;
  }
  public function sendEvent__ILorg_eclipse_swt_widgets_Event_2(eventType: int, event: Event): void {
    this.sendEvent__ILorg_eclipse_swt_widgets_Event_2Z(eventType, event, true);
    return;
  }
  public function sendEvent__ILorg_eclipse_swt_widgets_Event_2Z(eventType: int, event: Event, send: Boolean): void {
    if (eventTable === null && !display.filters__I(eventType)) {
      return;
    }
    if (event === null)
      event = new Event();
    event.type = eventType;
    event.display = display;
    event.widget = this;
    if (event.time == 0) {
      event.time = display.getLastEventTime__();
    }
    if (send) {
      this.sendEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    } else {
      display.postEvent__Lorg_eclipse_swt_widgets_Event_2(event);
    }
    return;
  }
  public function setData__Ljava_lang_Object_2(data_1: Object): void {
    this.checkWidget__();
    if ((state & 8) != 0) {
      (JavaArray(this.data))[0] = data_1;
    } else {
      this.data = data_1;
    }
    return;
  }
  public function setData__Ljava_lang_String_2Ljava_lang_Object_2(key: String, value: Object): void {
    this.checkWidget__();
    if (key === null)
      this.error__I(4);
    var index: int = 1;
    var table: JavaArray = null;
    if ((state & 8) != 0) {
      table = JavaArray(data);
      while (index < table.length) {
        if (Object(key).equals__Ljava_lang_Object_2(table[index]))
          break;
        index += 2;
      }
    }
    if (value !== null) {
      if ((state & 8) != 0) {
        if (index == table.length) {
          var newTable: JavaArray = new JavaArray("[Ljava/lang/Object;").lengths(table.length + 2);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(table, 0, newTable, 0, table.length);
          data = table = newTable;
        }
      } else {
        table = new JavaArray("[Ljava/lang/Object;").lengths(3);
        table[0] = data;
        data = table;
        state |= 8;
      }
      table[index] = key;
      table[index + 1] = value;
    } else {
      if ((state & 8) != 0) {
        if (index != table.length) {
          var length: int = table.length - 2;
          if (length == 1) {
            data = table[0];
            state &= ~8;
          } else {
            var newTable_1: JavaArray = new JavaArray("[Ljava/lang/Object;").lengths(length);
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(table, 0, newTable_1, 0, index);
            System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(table, index + 2, newTable_1, index, length - index);
            data = newTable_1;
          }
        }
      }
    }
    return;
  }
  public function topComponent__(): UIComponent {
    return object;
  }
  public function toString__(): String {
    var string: String = "*Disposed*";
    if (!this.isDisposed__()) {
      string = "*Wrong Thread*";
      if (this.isValidThread__())
        string = this.getNameText__();
    }
    return this.getName__() + " {" + string + "}";
  }
  public function Widget(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Widget && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Widget__();
        break;
      case 1:
        Widget__Lorg_eclipse_swt_widgets_Widget_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const Widget__ : int = 0;
  public static const Widget__Lorg_eclipse_swt_widgets_Widget_2I : int = 1;
}
}
