/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtiltities;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtility
implements ISWTResourceUtiltities {
    public static final String PROTOCOL = "bundle-resource://";
    private ImageRegistry IMAGE_REGISTRY = new ImageRegistry();
    private ColorRegistry COLOR_REGISTRY = new ColorRegistry();
    private final PackageAdmin packageAdmin;

    public ResourceUtility(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public ImageDescriptor resolveIconResource(String string) {
        String string2 = string.substring(PROTOCOL.length(), string.indexOf("/", PROTOCOL.length()));
        String string3 = string.substring(string2.length() + PROTOCOL.length());
        Image image = this.IMAGE_REGISTRY.get(string);
        if (image == null) {
            ImageDescriptor imageDescriptor = this.imageDescriptorFromPlugin(string2, string3);
            image = imageDescriptor.createImage();
            this.IMAGE_REGISTRY.put(string, image);
        }
        return ImageDescriptor.createFromImage((Image)image);
    }

    private Bundle getBundle(String string) {
        Bundle[] bundleArray = this.packageAdmin.getBundles(string, null);
        if (bundleArray == null) {
            return null;
        }
        int n = 0;
        while (n < bundleArray.length) {
            if ((bundleArray[n].getState() & 3) == 0) {
                return bundleArray[n];
            }
            ++n;
        }
        return null;
    }

    public ImageDescriptor imageDescriptorFromPlugin(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        Bundle bundle = this.getBundle(string);
        if ((bundle.getState() & 0x3C) == 0) {
            return null;
        }
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)new Path(string2), null);
        if (uRL == null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (uRL == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)uRL);
    }

    public ColorDescriptor getColor(String string) {
        Pattern pattern;
        RGB rGB = new RGB(255, 255, 255);
        if (string.indexOf("rgb") != -1) {
            pattern = Pattern.compile("\\d+");
            Matcher matcher = pattern.matcher(string);
            int n = 0;
            while (matcher.find()) {
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(matcher.group());
                }
                catch (NumberFormatException numberFormatException) {}
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > 255) {
                    n2 = 255;
                }
                if (n == 0) {
                    rGB.red = n2;
                } else if (n == 1) {
                    rGB.green = n2;
                } else {
                    rGB.blue = n2;
                }
                if (++n == 3) break;
            }
        }
        if (!this.COLOR_REGISTRY.hasValueFor(rGB.toString())) {
            this.COLOR_REGISTRY.put(rGB.toString(), rGB);
            pattern = this.COLOR_REGISTRY.getColorDescriptor(rGB.toString());
        } else {
            pattern = this.COLOR_REGISTRY.getColorDescriptor(rGB.toString());
        }
        return pattern;
    }

    public IResourceUtiltities.Gradient<ColorDescriptor> getGradientColors(String string) {
        Object object;
        String[] stringArray = string.split(";");
        String[] stringArray2 = stringArray[0].split("-");
        ArrayList<ColorDescriptor> arrayList = new ArrayList<ColorDescriptor>(stringArray2.length);
        int n = 0;
        Object[] objectArray = stringArray2;
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            object = objectArray[n3];
            arrayList.add(this.getColor((String)object));
            ++n3;
        }
        object = Pattern.compile("\\d+");
        Matcher matcher = ((Pattern)object).matcher(stringArray[1]);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        while (matcher.find()) {
            int n4 = 0;
            try {
                n4 = Integer.parseInt(matcher.group());
            }
            catch (NumberFormatException numberFormatException) {}
            if (n4 > 100) {
                n4 = 100;
            }
            arrayList2.add(n4);
        }
        objectArray = new int[arrayList2.size()];
        n = 0;
        for (Integer n5 : arrayList2) {
            objectArray[n++] = (String)((Object)n5);
        }
        return new IResourceUtiltities.Gradient(arrayList, (int[])objectArray, stringArray.length == 3 && stringArray[2].indexOf("true") != -1);
    }

    public ImageDescriptor imageDescriptorFromURI(URI uRI) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(uRI.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

