/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.examples.css.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.core.serializers.CSSHTMLSerializerConfiguration;
import org.eclipse.e4.ui.css.core.serializers.CSSSerializer;
import org.eclipse.e4.ui.css.core.serializers.CSSSerializerConfiguration;

public abstract class AbstractCSSEditor {
    protected CSSEngine engine;
    protected CSSSerializer serializer;
    protected String nativeWidgetDir;
    protected List cssFiles = new ArrayList();

    protected AbstractCSSEditor(String string) {
        this.nativeWidgetDir = string;
    }

    protected CSSEngine getCSSEngine() {
        if (this.engine == null) {
            this.engine = this.createCSSEngine();
            this.engine.setErrorHandler(new CSSErrorHandler(){

                public void error(Exception exception) {
                    AbstractCSSEditor.this.handleExceptions(exception);
                }
            });
        } else {
            this.engine.reset();
        }
        if (this.isHTMLSelector()) {
            this.engine.setElementProvider(this.getHTMLElementProvider());
        } else {
            this.engine.setElementProvider(this.getNativeWidgetElementProvider());
        }
        return this.engine;
    }

    protected void applyStyles(Object object) {
        try {
            Date date = new Date();
            this.engine = this.getCSSEngine();
            StringReader stringReader = new StringReader(this.getStyleSheetContent());
            this.engine.parseStyleSheet((Reader)stringReader);
            this.engine.applyStyles(object, true, true);
            Date date2 = new Date();
            this.setCSSEngineStatuts("Apply style with " + (date2.getTime() - date.getTime()) + "ms.");
        }
        catch (Exception exception) {
            this.handleExceptions(exception);
        }
    }

    protected void applyStyles() {
        if (this.mustApplyStylesToWindow()) {
            this.applyStyles(this.getWindowNativeWidget());
        } else {
            this.applyStyles(this.getLeftPanelNativeWidget());
        }
    }

    protected void fillTextareaWithStyleSheetContent(File file) {
        try {
            this.fillTextareaWithStyleSheetContent(new FileInputStream(file));
        }
        catch (Exception exception) {
            this.handleExceptions(exception);
        }
    }

    protected void fillTextareaWithStyleSheetContent(InputStream inputStream) {
        try {
            StringWriter stringWriter = new StringWriter();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = "";
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    stringWriter.write("\n");
                }
                stringWriter.write(string);
                bl = true;
            }
            bufferedReader.close();
            inputStreamReader.close();
            String string2 = stringWriter.toString();
            this.setStyleSheetContent(string2);
        }
        catch (Exception exception) {
            this.handleExceptions(exception);
        }
    }

    protected void fillTextareaWithDefaultStyleSheetContent() {
        if (this.mustApplyStylesToWindow()) {
            this.fillTextareaWithDefaultStyleSheetContent(this.getWindowNativeWidget());
        } else {
            this.fillTextareaWithDefaultStyleSheetContent(this.getLeftPanelNativeWidget());
        }
    }

    protected void fillTextareaWithDefaultStyleSheetContent(Object object) {
        if (this.serializer == null) {
            this.serializer = new CSSSerializer();
        }
        StringWriter stringWriter = new StringWriter();
        try {
            CSSSerializerConfiguration cSSSerializerConfiguration = this.isHTMLSelector() ? this.getCSSHTMLSerializerConfiguration() : this.getCSSNativeWidgetSerializerConfiguration();
            this.serializer.serialize((Writer)stringWriter, this.getCSSEngine(), object, true, cSSSerializerConfiguration);
            this.setStyleSheetContent(stringWriter.toString());
        }
        catch (Exception exception) {
            this.handleExceptions(exception);
        }
    }

    protected void applyStylesFromSelectedFile() {
        int n = this.getCSSFilesWidgetSelectionIndex();
        if (n == -1 && this.getCSSFilesWidgetItemCount() > 1) {
            n = 1;
            this.selectCSSFilesWidget(n);
        }
        if (n < 1) {
            this.setStyleSheetContent("");
            return;
        }
        File file = (File)this.cssFiles.get(n - 1);
        this.fillTextareaWithStyleSheetContent(file);
    }

    protected void populateCSSFiles() {
        this.removeAllCSSFilesWidget();
        int n = this.cssFiles.size();
        int n2 = 0;
        while (n2 < n) {
            this.cssFiles.remove(0);
            ++n2;
        }
        this.addItemCSSFilesWidget("None");
        File file = this.getBaseStyleDir();
        File[] fileArray = file.listFiles();
        int n3 = 0;
        while (n3 < fileArray.length) {
            File file2 = fileArray[n3];
            if (file2.isFile()) {
                this.addItemCSSFilesWidget(file2.getName());
                this.cssFiles.add(file2);
            }
            ++n3;
        }
    }

    protected void handleExceptions(Exception exception) {
        exception.printStackTrace();
    }

    protected File getBaseStyleDir() {
        if (this.isHTMLSelector()) {
            return new File(String.valueOf(this.getBaseStyleDirName()) + "/html");
        }
        if (this.nativeWidgetDir != null) {
            return new File(String.valueOf(this.getBaseStyleDirName()) + "/" + this.nativeWidgetDir);
        }
        return new File(this.getBaseStyleDirName());
    }

    protected String getBaseStyleDirName() {
        return "styles";
    }

    protected abstract CSSEngine createCSSEngine();

    protected abstract boolean isHTMLSelector();

    protected abstract IElementProvider getNativeWidgetElementProvider();

    protected abstract IElementProvider getHTMLElementProvider();

    protected abstract String getStyleSheetContent();

    protected abstract void setStyleSheetContent(String var1);

    protected abstract void setCSSEngineStatuts(String var1);

    protected abstract boolean mustApplyStylesToWindow();

    protected abstract Object getWindowNativeWidget();

    protected abstract Object getLeftPanelNativeWidget();

    protected abstract CSSSerializerConfiguration getCSSNativeWidgetSerializerConfiguration();

    protected CSSSerializerConfiguration getCSSHTMLSerializerConfiguration() {
        return CSSHTMLSerializerConfiguration.INSTANCE;
    }

    protected abstract int getCSSFilesWidgetSelectionIndex();

    protected abstract int getCSSFilesWidgetItemCount();

    protected abstract void selectCSSFilesWidget(int var1);

    protected abstract void removeAllCSSFilesWidget();

    protected abstract void addItemCSSFilesWidget(String var1);
}

