/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.examples.css.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.css2.CSS2FontPropertiesHelpers;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.serializers.CSSSerializerConfiguration;
import org.eclipse.e4.ui.css.swt.dom.SWTElementProvider;
import org.eclipse.e4.ui.css.swt.dom.html.SWTHTMLElementProvider;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.css.swt.serializers.CSSSWTSerializerConfiguration;
import org.eclipse.e4.ui.examples.css.editor.AbstractCSSEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractCSSSWTEditor
extends AbstractCSSEditor {
    protected static final String[] CSS_FILE_EXTENSION = new String[]{"*.css"};
    private Display display;
    private StyledText textArea;
    private Button cacheResourcesCheckbox;
    private Button htmlCheckbox;
    private Label statusLabel;
    private Button applyStyleWhenTextAreaChangeCheckbox;
    private Button applyStyleToShellCheckbox;
    protected Shell shell;
    private Composite leftPanel;
    private org.eclipse.swt.widgets.List cssFilesWidget;
    private List cssFiles = new ArrayList();
    private Text selectedCSSPropertyNameText = null;
    private Text selectedCSSPropertyValueText = null;
    protected int currentLine = -1;

    protected AbstractCSSSWTEditor(String string, String[] stringArray) {
        super(string);
    }

    protected AbstractCSSSWTEditor() {
        super("swt");
    }

    public void display() {
        this.display = new Display();
        this.shell = new Shell(this.display, 1264);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 3;
        this.shell.setLayout((Layout)gridLayout);
        this.createMenus(this.shell);
        SashForm sashForm = new SashForm((Composite)this.shell, 0);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createLeftPanel((Composite)sashForm);
        this.createRightPanel((Composite)sashForm);
        sashForm.setWeights(new int[]{30, 80});
        this.shell.setSize(new Point(800, 600));
        this.shell.open();
        this.shell.setText("CSS Editors");
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    protected void createMenus(Shell shell) {
        Menu menu = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menu);
        this.createMenuItemFile(menu, shell);
    }

    protected void createMenuItemFile(Menu menu, final Shell shell) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("&File");
        Menu menu2 = new Menu((Decorations)shell, 4);
        menuItem.setMenu(menu2);
        MenuItem menuItem2 = new MenuItem(menu2, 8);
        menuItem2.setText("&New...");
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractCSSSWTEditor.this.fillTextareaWithDefaultStyleSheetContent();
            }
        });
        MenuItem menuItem3 = new MenuItem(menu2, 8);
        menuItem3.setText("&Open...");
        menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(shell, 0);
                fileDialog.setFilterExtensions(CSS_FILE_EXTENSION);
                fileDialog.setText("Select CSS style file");
                fileDialog.setFilterPath(AbstractCSSSWTEditor.this.getBaseStyleDir().getAbsolutePath());
                String string = fileDialog.open();
                if (string != null) {
                    File file = new File(string);
                    AbstractCSSSWTEditor.this.fillTextareaWithStyleSheetContent(file);
                }
            }
        });
    }

    protected void createMenuItemOptions(Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 64);
        menuItem.setText("&Options");
        Menu menu2 = new Menu((Decorations)this.shell, 4);
        menuItem.setMenu(menu2);
        MenuItem menuItem2 = new MenuItem(menu2, 32);
        menuItem2.setText("&Cache Resource...");
    }

    protected void createLeftPanel(Composite composite) {
        this.leftPanel = new Composite(composite, 0);
        this.leftPanel.setLayout((Layout)new FillLayout());
        this.createContent(this.leftPanel);
    }

    protected void createRightPanel(Composite composite) {
        SashForm sashForm = new SashForm(composite, 0);
        sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 3;
        Composite composite2 = new Composite((Composite)sashForm, 0);
        composite2.setLayout((Layout)gridLayout);
        this.statusLabel = new Label(composite2, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.textArea = new StyledText(composite2, 2562);
        this.textArea.setLayoutData((Object)new GridData(1808));
        this.textArea.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (AbstractCSSSWTEditor.this.applyStyleWhenTextAreaChangeCheckbox.getSelection()) {
                    AbstractCSSSWTEditor.this.applyStyles();
                }
            }
        });
        this.textArea.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                AbstractCSSSWTEditor.this.displaySelectedCSSProperty();
            }
        });
        this.textArea.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                AbstractCSSSWTEditor.this.displaySelectedCSSProperty();
            }
        });
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 3;
        composite2 = new Composite((Composite)sashForm, 0);
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Selected CSS Property");
        gridLayout = new GridLayout(2, true);
        gridLayout.verticalSpacing = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText("CSS Property name");
        this.selectedCSSPropertyNameText = new Text((Composite)group, 2056);
        this.selectedCSSPropertyNameText.setLayoutData((Object)new GridData(768));
        label = new Label((Composite)group, 0);
        label.setText("CSS Property value");
        this.selectedCSSPropertyValueText = new Text((Composite)group, 2048);
        this.selectedCSSPropertyValueText.setLayoutData((Object)new GridData(768));
        this.selectedCSSPropertyValueText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                String string = AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText();
                string = String.valueOf(string) + ":";
                string = String.valueOf(string) + AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                AbstractCSSSWTEditor.this.updateSelectedCSSPropertyValue(string);
            }
        });
        Button button = new Button((Composite)group, 2056);
        button.setText("Change Color");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                Object object2;
                ColorDialog colorDialog = new ColorDialog(AbstractCSSSWTEditor.this.shell);
                colorDialog.setText("ColorDialog Demo");
                String string = AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                if (string != null && string.length() > 0) {
                    try {
                        object2 = AbstractCSSSWTEditor.this.engine.parsePropertyValue(string);
                        object = (RGB)AbstractCSSSWTEditor.this.engine.convert((CSSValue)object2, RGB.class, null);
                        if (object != null) {
                            colorDialog.setRGB(object);
                        }
                    }
                    catch (Exception exception) {
                        AbstractCSSSWTEditor.this.handleExceptions(exception);
                    }
                }
                if ((object2 = colorDialog.open()) != null) {
                    try {
                        string = AbstractCSSSWTEditor.this.engine.convert(object2, RGB.class, (Object)AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText());
                        if (string == null) {
                            return;
                        }
                        AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.setText(string);
                        object = AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText();
                        object = String.valueOf(object) + ":";
                        object = String.valueOf(object) + AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                        AbstractCSSSWTEditor.this.updateSelectedCSSPropertyValue((String)object);
                    }
                    catch (Exception exception) {
                        AbstractCSSSWTEditor.this.handleExceptions(exception);
                    }
                }
            }
        });
        Button button2 = new Button((Composite)group, 2056);
        button2.setText("Change Font");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                Object object2;
                String string;
                FontDialog fontDialog = new FontDialog(AbstractCSSSWTEditor.this.shell);
                fontDialog.setText("Choose the font");
                String string2 = AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                try {
                    string = AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText();
                    object2 = AbstractCSSSWTEditor.this.engine.parsePropertyValue(string2);
                    object = CSS2FontPropertiesHelpers.createCSS2FontProperties((CSSValue)object2, (String)string);
                    FontData fontData = (FontData)AbstractCSSSWTEditor.this.engine.convert((CSSValue)object, FontData.class, (Object)AbstractCSSSWTEditor.this.display);
                    if (fontData != null) {
                        FontData[] fontDataArray = new FontData[]{fontData};
                        fontDialog.setFontList(fontDataArray);
                    }
                }
                catch (Exception exception) {
                    AbstractCSSSWTEditor.this.handleExceptions(exception);
                }
                if ((string = fontDialog.open()) != null) {
                    try {
                        object2 = AbstractCSSSWTEditor.this.engine.convert((Object)string, FontData.class, (Object)AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText());
                        if (object2 == null) {
                            return;
                        }
                        AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.setText((String)object2);
                        object = AbstractCSSSWTEditor.this.selectedCSSPropertyNameText.getText();
                        object = String.valueOf(object) + ":";
                        object = String.valueOf(object) + AbstractCSSSWTEditor.this.selectedCSSPropertyValueText.getText();
                        AbstractCSSSWTEditor.this.updateSelectedCSSPropertyValue((String)object);
                    }
                    catch (Exception exception) {
                        AbstractCSSSWTEditor.this.handleExceptions(exception);
                    }
                }
            }
        });
        group = new Group(composite2, 0);
        group.setText("CSS Engine options");
        gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1808));
        this.cacheResourcesCheckbox = new Button((Composite)group, 32);
        this.cacheResourcesCheckbox.setText("Cache Color, Font and Cursor");
        this.cacheResourcesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!AbstractCSSSWTEditor.this.cacheResourcesCheckbox.getSelection()) {
                    AbstractCSSSWTEditor.this.engine.getResourcesRegistry().dispose();
                }
            }
        });
        this.cacheResourcesCheckbox.setSelection(true);
        this.applyStyleWhenTextAreaChangeCheckbox = new Button((Composite)group, 32);
        this.applyStyleWhenTextAreaChangeCheckbox.setText("Apply style when textarea change");
        this.applyStyleWhenTextAreaChangeCheckbox.setSelection(true);
        this.htmlCheckbox = new Button((Composite)group, 32);
        this.htmlCheckbox.setText("is HTML Selector? (otherwise it's SWT Selector)");
        this.htmlCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractCSSSWTEditor.this.populateCSSFiles();
                AbstractCSSSWTEditor.this.applyStylesFromSelectedFile();
            }
        });
        this.cssFilesWidget = new org.eclipse.swt.widgets.List((Composite)group, 0);
        this.cssFilesWidget.setLayoutData((Object)new GridData(768));
        this.cssFilesWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractCSSSWTEditor.this.applyStylesFromSelectedFile();
            }
        });
        this.populateCSSFiles();
        this.applyStyleToShellCheckbox = new Button((Composite)group, 32);
        this.applyStyleToShellCheckbox.setText("Apply style to Shell?");
        this.applyStyleToShellCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AbstractCSSSWTEditor.this.applyStyleToShellCheckbox.getSelection()) {
                    AbstractCSSSWTEditor.this.applyStyles();
                } else {
                    AbstractCSSSWTEditor.this.engine = AbstractCSSSWTEditor.this.getCSSEngine();
                    AbstractCSSSWTEditor.this.engine.applyStyles((Object)AbstractCSSSWTEditor.this.shell, true);
                    AbstractCSSSWTEditor.this.applyStyles();
                }
            }
        });
        Button button3 = new Button((Composite)group, 2048);
        button3.setText("Apply style");
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractCSSSWTEditor.this.applyStyles();
            }
        });
        sashForm.setWeights(new int[]{120, 90});
        this.applyStylesFromSelectedFile();
    }

    public abstract void createContent(Composite var1);

    protected void displaySelectedCSSProperty() {
        this.selectedCSSPropertyNameText.setText("");
        this.selectedCSSPropertyValueText.setText("");
        int n = -1;
        int n2 = -1;
        this.currentLine = this.textArea.getLineAtOffset(this.textArea.getCaretOffset());
        if (this.currentLine + 1 >= this.textArea.getLineCount()) {
            return;
        }
        n = this.textArea.getOffsetAtLine(this.currentLine);
        if (n <= (n2 = this.textArea.getOffsetAtLine(this.currentLine + 1) - 2)) {
            String string = this.textArea.getText(n, n2);
            int n3 = (string = string.trim()).indexOf(":");
            if (n3 > 0) {
                if (string.indexOf("{") != -1) {
                    return;
                }
                String string2 = string.substring(0, n3);
                String string3 = string.substring(n3 + 1, string.length());
                int n4 = (string3 = string3.replaceAll(";", "")).indexOf("/*");
                if (n4 > 0) {
                    string3 = string3.substring(0, n4);
                }
                this.selectedCSSPropertyNameText.setText(string2);
                this.selectedCSSPropertyValueText.setText(string3);
            }
        }
    }

    protected void updateSelectedCSSPropertyValue(String string) {
        if (this.currentLine != -1 && this.currentLine + 1 >= this.textArea.getLineCount()) {
            return;
        }
        int n = this.textArea.getOffsetAtLine(this.currentLine);
        int n2 = this.textArea.getOffsetAtLine(this.currentLine + 1) - 2;
        String string2 = this.textArea.getText(0, n);
        String string3 = this.textArea.getText(n2, this.textArea.getCharCount() - 1);
        if (!string.endsWith(";") && !string3.startsWith(";")) {
            string = String.valueOf(string) + ";";
        }
        if (string3.startsWith(":")) {
            string3.substring(1, string3.length());
        }
        String string4 = String.valueOf(string2) + string + string3;
        this.textArea.setText(string4);
    }

    protected CSSEngine createCSSEngine() {
        return new CSSSWTEngineImpl(this.shell.getDisplay());
    }

    protected IElementProvider getHTMLElementProvider() {
        return SWTHTMLElementProvider.INSTANCE;
    }

    protected IElementProvider getNativeWidgetElementProvider() {
        return SWTElementProvider.INSTANCE;
    }

    protected boolean isHTMLSelector() {
        return this.htmlCheckbox.getSelection();
    }

    protected String getStyleSheetContent() {
        return this.textArea.getText();
    }

    protected void setStyleSheetContent(String string) {
        this.textArea.setText(string);
    }

    protected void setCSSEngineStatuts(String string) {
        this.statusLabel.setText(string);
    }

    protected boolean mustApplyStylesToWindow() {
        return this.applyStyleToShellCheckbox.getSelection();
    }

    protected Object getLeftPanelNativeWidget() {
        return this.leftPanel;
    }

    protected Object getWindowNativeWidget() {
        return this.shell;
    }

    protected CSSSerializerConfiguration getCSSNativeWidgetSerializerConfiguration() {
        return CSSSWTSerializerConfiguration.INSTANCE;
    }

    protected int getCSSFilesWidgetItemCount() {
        return this.cssFilesWidget.getItemCount();
    }

    protected int getCSSFilesWidgetSelectionIndex() {
        return this.cssFilesWidget.getSelectionIndex();
    }

    protected void selectCSSFilesWidget(int n) {
        this.cssFilesWidget.select(n);
    }

    protected void addItemCSSFilesWidget(String string) {
        this.cssFilesWidget.add(string);
    }

    protected void removeAllCSSFilesWidget() {
        this.cssFilesWidget.removeAll();
    }
}

