/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public class CascadeTest
extends TestCase {
    private Display display;
    private CSSSWTEngineImpl engine;

    protected void setUp() throws Exception {
        this.display = Display.getDefault();
        this.engine = new CSSSWTEngineImpl(this.display);
    }

    public void testPosition() throws Exception {
        String string = "Button { color: blue; font-weight: bold; }\nButton { color: black }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(string);
        TestElement testElement = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement), null);
        CascadeTest.assertEquals((String)"black", (String)cSSStyleDeclaration.getPropertyCSSValue("color").getCssText());
        CascadeTest.assertEquals((String)"bold", (String)cSSStyleDeclaration.getPropertyCSSValue("font-weight").getCssText());
    }

    public void testSpecificity() throws Exception {
        String string = "Label, Button.special { color: black; }\nButton { color: blue; font-weight: bold; }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(string);
        TestElement testElement = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement), null);
        CascadeTest.assertEquals((String)"blue", (String)cSSStyleDeclaration.getPropertyCSSValue("color").getCssText());
        testElement.setClass("special");
        cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement), null);
        CascadeTest.assertEquals((String)"black", (String)cSSStyleDeclaration.getPropertyCSSValue("color").getCssText());
        CascadeTest.assertEquals((String)"bold", (String)cSSStyleDeclaration.getPropertyCSSValue("font-weight").getCssText());
    }

    public void testSpecificities() throws Exception {
        String string = "* { color: black; }\nButton { color: blue; }\nButton[BORDER] { color: gray; }\nButton.special { color: green; }\nButton#myid { color: red; }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(string);
        TestElement testElement = new TestElement("Label", (CSSEngine)this.engine);
        CSSStyleDeclaration cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement), null);
        CascadeTest.assertEquals((String)"black", (String)cSSStyleDeclaration.getPropertyCSSValue("color").getCssText());
        TestElement testElement2 = new TestElement("Button", (CSSEngine)this.engine);
        cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement2), null);
        CascadeTest.assertEquals((String)"blue", (String)cSSStyleDeclaration.getPropertyCSSValue("color").getCssText());
        testElement2.setAttribute("BORDER", "true");
        cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement2), null);
        CascadeTest.assertEquals((String)"gray", (String)cSSStyleDeclaration.getPropertyCSSValue("color").getCssText());
        testElement2.setClass("special");
        cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement2), null);
        CascadeTest.assertEquals((String)"green", (String)cSSStyleDeclaration.getPropertyCSSValue("color").getCssText());
        testElement2.setId("myid");
        cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement2), null);
        CascadeTest.assertEquals((String)"red", (String)cSSStyleDeclaration.getPropertyCSSValue("color").getCssText());
    }

    private static ViewCSS createViewCss(String string) throws IOException {
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        DocumentCSSImpl documentCSSImpl = new DocumentCSSImpl();
        documentCSSImpl.addStyleSheet((StyleSheet)cSSStyleSheet);
        return new ViewCSSImpl((DocumentCSS)documentCSSImpl);
    }

    public void testBug261081() throws Exception {
        String string = "Button, Label { color: blue; font-weight: bold; }\nButton { color: black }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(string);
        TestElement testElement = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement), null);
        CascadeTest.assertEquals((String)"black", (String)cSSStyleDeclaration.getPropertyCSSValue("color").getCssText());
        CascadeTest.assertEquals((String)"bold", (String)cSSStyleDeclaration.getPropertyCSSValue("font-weight").getCssText());
    }
}

