/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import junit.framework.TestCase;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class StyleRuleTest
extends TestCase {
    public void testSimpleStyleRule() throws Exception {
        String string = "Label { color: #FF0000 }";
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        StyleRuleTest.assertNotNull((Object)cSSStyleSheet);
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        StyleRuleTest.assertEquals((int)1, (int)cSSRuleList.getLength());
        CSSRule cSSRule = cSSRuleList.item(0);
        StyleRuleTest.assertEquals((short)1, (short)cSSRule.getType());
    }

    public void testHexColor() throws Exception {
        String string = "Label { color: #FF0220 }";
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        CSSRule cSSRule = cSSRuleList.item(0);
        StyleRuleTest.assertEquals((short)1, (short)cSSRule.getType());
        CSSStyleDeclaration cSSStyleDeclaration = ((CSSStyleRule)cSSRule).getStyle();
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("color");
        StyleRuleTest.assertTrue((boolean)(cSSValue instanceof CSSPrimitiveValue));
        RGBColor rGBColor = ((CSSPrimitiveValue)cSSValue).getRGBColorValue();
        StyleRuleTest.assertEquals((float)255.0f, (float)rGBColor.getRed().getFloatValue((short)1), (float)0.0f);
        StyleRuleTest.assertEquals((float)2.0f, (float)rGBColor.getGreen().getFloatValue((short)1), (float)0.0f);
        StyleRuleTest.assertEquals((float)32.0f, (float)rGBColor.getBlue().getFloatValue((short)1), (float)0.0f);
    }

    public void testNamedColor() throws Exception {
        String string = "Label { color: green }";
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        CSSRule cSSRule = cSSRuleList.item(0);
        StyleRuleTest.assertEquals((short)1, (short)cSSRule.getType());
        CSSStyleDeclaration cSSStyleDeclaration = ((CSSStyleRule)cSSRule).getStyle();
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("color");
        StyleRuleTest.assertTrue((boolean)(cSSValue instanceof CSSPrimitiveValue));
        String string2 = ((CSSPrimitiveValue)cSSValue).getStringValue();
        StyleRuleTest.assertEquals((String)"green", (String)string2);
    }

    public void testFont() throws Exception {
        String string = "Label { font: Verdana }";
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        CSSRule cSSRule = cSSRuleList.item(0);
        StyleRuleTest.assertEquals((short)1, (short)cSSRule.getType());
        CSSStyleDeclaration cSSStyleDeclaration = ((CSSStyleRule)cSSRule).getStyle();
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("font");
        StyleRuleTest.assertTrue((boolean)(cSSValue instanceof CSSPrimitiveValue));
        String string2 = ((CSSPrimitiveValue)cSSValue).getStringValue();
        StyleRuleTest.assertEquals((String)"Verdana", (String)string2);
    }

    public void testTestFontItalic() throws Exception {
        String string = "Label { font: Arial 12px; font-style: italic }";
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        CSSRule cSSRule = cSSRuleList.item(0);
        StyleRuleTest.assertEquals((short)1, (short)cSSRule.getType());
        CSSStyleDeclaration cSSStyleDeclaration = ((CSSStyleRule)cSSRule).getStyle();
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("font-style");
        StyleRuleTest.assertTrue((boolean)(cSSValue instanceof CSSPrimitiveValue));
        String string2 = ((CSSPrimitiveValue)cSSValue).getStringValue();
        StyleRuleTest.assertEquals((String)"italic", (String)string2);
    }

    public void testTestFontBold() throws Exception {
        String string = "Label { font: Arial 12px; font-style: bold }";
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        CSSRule cSSRule = cSSRuleList.item(0);
        StyleRuleTest.assertEquals((short)1, (short)cSSRule.getType());
        CSSStyleDeclaration cSSStyleDeclaration = ((CSSStyleRule)cSSRule).getStyle();
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("font-style");
        StyleRuleTest.assertTrue((boolean)(cSSValue instanceof CSSPrimitiveValue));
        String string2 = ((CSSPrimitiveValue)cSSValue).getStringValue();
        StyleRuleTest.assertEquals((String)"bold", (String)string2);
    }

    public void testBackgroundNameColor() throws Exception {
        String string = "Label { background-color: green }";
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        CSSRule cSSRule = cSSRuleList.item(0);
        StyleRuleTest.assertEquals((short)1, (short)cSSRule.getType());
        CSSStyleDeclaration cSSStyleDeclaration = ((CSSStyleRule)cSSRule).getStyle();
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("background-color");
        StyleRuleTest.assertTrue((boolean)(cSSValue instanceof CSSPrimitiveValue));
        String string2 = ((CSSPrimitiveValue)cSSValue).getStringValue();
        StyleRuleTest.assertEquals((String)"green", (String)string2);
    }

    public void testBackgroundHexColor() throws Exception {
        String string = "Label { background-color: #FF0220 }";
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        CSSRule cSSRule = cSSRuleList.item(0);
        StyleRuleTest.assertEquals((short)1, (short)cSSRule.getType());
        CSSStyleDeclaration cSSStyleDeclaration = ((CSSStyleRule)cSSRule).getStyle();
        CSSValue cSSValue = cSSStyleDeclaration.getPropertyCSSValue("background-color");
        StyleRuleTest.assertTrue((boolean)(cSSValue instanceof CSSPrimitiveValue));
        RGBColor rGBColor = ((CSSPrimitiveValue)cSSValue).getRGBColorValue();
        StyleRuleTest.assertEquals((float)255.0f, (float)rGBColor.getRed().getFloatValue((short)1), (float)0.0f);
        StyleRuleTest.assertEquals((float)2.0f, (float)rGBColor.getGreen().getFloatValue((short)1), (float)0.0f);
        StyleRuleTest.assertEquals((float)32.0f, (float)rGBColor.getBlue().getFloatValue((short)1), (float)0.0f);
    }
}

