/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public class ViewCSSTest
extends TestCase {
    private Display display;
    private CSSSWTEngineImpl engine;

    protected void setUp() throws Exception {
        this.display = Display.getDefault();
        this.engine = new CSSSWTEngineImpl(this.display);
    }

    public void testGetComputedStyle() throws Exception {
        String string = "Label { color: black; }Button { color: blue; font-weight: bold; }\nButton { color: green; }\n";
        ViewCSS viewCSS = ViewCSSTest.createViewCss(string);
        TestElement testElement = new TestElement("Shell", (CSSEngine)this.engine);
        CSSStyleDeclaration cSSStyleDeclaration = viewCSS.getComputedStyle((Element)((Object)testElement), null);
        ViewCSSTest.assertNull((Object)cSSStyleDeclaration);
        TestElement testElement2 = new TestElement("Label", (CSSEngine)this.engine);
        CSSStyleDeclaration cSSStyleDeclaration2 = viewCSS.getComputedStyle((Element)((Object)testElement2), null);
        ViewCSSTest.assertNotNull((Object)cSSStyleDeclaration2);
        ViewCSSTest.assertEquals((int)1, (int)cSSStyleDeclaration2.getLength());
        TestElement testElement3 = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration cSSStyleDeclaration3 = viewCSS.getComputedStyle((Element)((Object)testElement3), null);
        ViewCSSTest.assertNotNull((Object)cSSStyleDeclaration3);
        ViewCSSTest.assertEquals((int)2, (int)cSSStyleDeclaration3.getLength());
    }

    private static ViewCSS createViewCss(String string) throws IOException {
        CSSStyleSheet cSSStyleSheet = ParserTestUtil.parseCss(string);
        DocumentCSSImpl documentCSSImpl = new DocumentCSSImpl();
        documentCSSImpl.addStyleSheet((StyleSheet)cSSStyleSheet);
        return new ViewCSSImpl((DocumentCSS)documentCSSImpl);
    }
}

