/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.javascript.test;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.e4.internal.javascript.JSBundleData;
import org.eclipse.e4.internal.javascript.JSBundleImpl;
import org.eclipse.e4.internal.javascript.JSExport;
import org.eclipse.e4.internal.javascript.JSFrameworkImpl;
import org.eclipse.e4.internal.javascript.JSImport;
import org.eclipse.e4.internal.javascript.JSRequire;
import org.eclipse.e4.javascript.JSBundleException;
import org.osgi.framework.Version;

public class JSBundleTest
extends TestCase {
    public JSBundleTest(String string) {
        super(string);
    }

    public void testNullHeaders() {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        try {
            new JSBundleImpl(jSFrameworkImpl, null);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        JSBundleTest.fail();
    }

    public void testNameAndEmptyVersion() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        JSBundleData jSBundleData = new JSBundleData(0, "testloc", hashMap, null);
        JSBundleImpl jSBundleImpl = new JSBundleImpl(jSFrameworkImpl, jSBundleData);
        JSBundleTest.assertEquals((String)"test", (String)jSBundleImpl.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.emptyVersion, (Object)jSBundleImpl.getVersion());
    }

    public void testNameAndVersion() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        JSBundleData jSBundleData = new JSBundleData(0, "testloc", hashMap, null);
        JSBundleImpl jSBundleImpl = new JSBundleImpl(jSFrameworkImpl, jSBundleData);
        JSBundleTest.assertEquals((String)"test", (String)jSBundleImpl.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jSBundleImpl.getVersion());
    }

    public void testNoExportsImportsRequires() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        JSBundleData jSBundleData = new JSBundleData(0, "testloc", hashMap, null);
        JSBundleImpl jSBundleImpl = new JSBundleImpl(jSFrameworkImpl, jSBundleData);
        JSBundleTest.assertEquals((String)"test", (String)jSBundleImpl.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jSBundleImpl.getVersion());
        JSBundleTest.assertEquals((int)0, (int)jSBundleImpl.getExports().size());
        JSBundleTest.assertEquals((int)0, (int)jSBundleImpl.getImports().size());
        JSBundleTest.assertEquals((int)0, (int)jSBundleImpl.getRequires().size());
    }

    public void testOneExportsImportsRequires() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        hashMap.put("Exports", "a.a");
        hashMap.put("Imports", "c.c");
        hashMap.put("Requires", "test1");
        JSBundleData jSBundleData = new JSBundleData(0, "testloc", hashMap, null);
        JSBundleImpl jSBundleImpl = new JSBundleImpl(jSFrameworkImpl, jSBundleData);
        JSBundleTest.assertEquals((String)"test", (String)jSBundleImpl.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jSBundleImpl.getVersion());
        JSBundleTest.assertEquals((int)1, (int)jSBundleImpl.getExports().size());
        JSBundleTest.assertEquals((String)"a.a", (String)((JSExport)jSBundleImpl.getExports().get(0)).getName());
        JSBundleTest.assertEquals((int)1, (int)jSBundleImpl.getImports().size());
        JSBundleTest.assertEquals((String)"c.c", (String)((JSImport)jSBundleImpl.getImports().get(0)).getName());
        JSBundleTest.assertEquals((int)1, (int)jSBundleImpl.getRequires().size());
        JSBundleTest.assertEquals((String)"test1", (String)((JSRequire)jSBundleImpl.getRequires().get(0)).getName());
    }

    public void testTwoExportsImportsRequires() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        hashMap.put("Exports", "a.a, b.b");
        hashMap.put("Imports", "c.c, d.d");
        hashMap.put("Requires", "test1, test2");
        JSBundleData jSBundleData = new JSBundleData(0, "testloc", hashMap, null);
        JSBundleImpl jSBundleImpl = new JSBundleImpl(jSFrameworkImpl, jSBundleData);
        JSBundleTest.assertEquals((String)"test", (String)jSBundleImpl.getSymbolicName());
        JSBundleTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jSBundleImpl.getVersion());
        JSBundleTest.assertEquals((int)2, (int)jSBundleImpl.getExports().size());
        JSBundleTest.assertEquals((String)"a.a", (String)((JSExport)jSBundleImpl.getExports().get(0)).getName());
        JSBundleTest.assertEquals((String)"b.b", (String)((JSExport)jSBundleImpl.getExports().get(1)).getName());
        JSBundleTest.assertEquals((int)2, (int)jSBundleImpl.getImports().size());
        JSBundleTest.assertEquals((String)"c.c", (String)((JSImport)jSBundleImpl.getImports().get(0)).getName());
        JSBundleTest.assertEquals((String)"d.d", (String)((JSImport)jSBundleImpl.getImports().get(1)).getName());
        JSBundleTest.assertEquals((int)2, (int)jSBundleImpl.getRequires().size());
        JSBundleTest.assertEquals((String)"test1", (String)((JSRequire)jSBundleImpl.getRequires().get(0)).getName());
        JSBundleTest.assertEquals((String)"test2", (String)((JSRequire)jSBundleImpl.getRequires().get(1)).getName());
    }
}

