/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.javascript.test;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.e4.internal.javascript.JSBundleData;
import org.eclipse.e4.internal.javascript.JSBundleImpl;
import org.eclipse.e4.internal.javascript.JSExport;
import org.eclipse.e4.internal.javascript.JSFrameworkImpl;
import org.eclipse.e4.javascript.JSBundle;
import org.eclipse.e4.javascript.JSBundleException;
import org.osgi.framework.Version;

public class JSExportTest
extends TestCase {
    public JSExportTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testBothNull() {
        try {
            new JSExport(null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSExportTest.fail();
    }

    public void testNullHeader() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        JSBundleData jSBundleData = new JSBundleData(0, "testloc", hashMap, null);
        JSBundleImpl jSBundleImpl = new JSBundleImpl(jSFrameworkImpl, jSBundleData);
        try {
            new JSExport(null, (JSBundle)jSBundleImpl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSExportTest.fail();
    }

    public void testNullJSBundle() {
        try {
            new JSExport("a.a", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSExportTest.fail();
    }

    public void testNameAndEmptyVersion() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        JSBundleData jSBundleData = new JSBundleData(0, "testloc", hashMap, null);
        JSBundleImpl jSBundleImpl = new JSBundleImpl(jSFrameworkImpl, jSBundleData);
        JSExport jSExport = new JSExport("a.a", (JSBundle)jSBundleImpl);
        JSExportTest.assertEquals((String)"a.a", (String)jSExport.getName());
        JSExportTest.assertEquals((Object)Version.emptyVersion, (Object)jSExport.getVersion());
        JSExportTest.assertEquals((String)"test", (String)jSExport.getBundleSymbolicName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jSExport.getBundleVersion());
        JSExportTest.assertEquals((int)0, (int)jSExport.getAttributes().size());
        JSExportTest.assertEquals((int)0, (int)jSExport.getDirectives().size());
        JSExportTest.assertEquals((int)0, (int)jSExport.getMandatory().size());
    }

    public void testNameAndVersion() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        JSBundleData jSBundleData = new JSBundleData(0, "testloc", hashMap, null);
        JSBundleImpl jSBundleImpl = new JSBundleImpl(jSFrameworkImpl, jSBundleData);
        JSExport jSExport = new JSExport("a.a;version=1.2.1", (JSBundle)jSBundleImpl);
        JSExportTest.assertEquals((String)"a.a", (String)jSExport.getName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.2.1"), (Object)jSExport.getVersion());
        JSExportTest.assertEquals((String)"test", (String)jSExport.getBundleSymbolicName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jSExport.getBundleVersion());
        JSExportTest.assertEquals((int)1, (int)jSExport.getAttributes().size());
        JSExportTest.assertEquals((int)0, (int)jSExport.getDirectives().size());
        JSExportTest.assertEquals((int)0, (int)jSExport.getMandatory().size());
    }

    public void testMandatory() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        JSBundleData jSBundleData = new JSBundleData(0, "testloc", hashMap, null);
        JSBundleImpl jSBundleImpl = new JSBundleImpl(jSFrameworkImpl, jSBundleData);
        JSExport jSExport = new JSExport("a.a;i=1;j=2;mandatory:=i,j;version=1.2.1", (JSBundle)jSBundleImpl);
        JSExportTest.assertEquals((String)"a.a", (String)jSExport.getName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.2.1"), (Object)jSExport.getVersion());
        JSExportTest.assertEquals((String)"test", (String)jSExport.getBundleSymbolicName());
        JSExportTest.assertEquals((Object)Version.parseVersion((String)"1.8"), (Object)jSExport.getBundleVersion());
        JSExportTest.assertEquals((int)3, (int)jSExport.getAttributes().size());
        JSExportTest.assertEquals((int)1, (int)jSExport.getDirectives().size());
        JSExportTest.assertEquals((int)2, (int)jSExport.getMandatory().size());
    }
}

