/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.javascript.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.e4.internal.javascript.JSFrameworkImpl;
import org.eclipse.e4.internal.javascript.JSONUtil;
import org.eclipse.e4.internal.javascript.RhinoClassLoader;
import org.eclipse.e4.javascript.JSBundle;
import org.eclipse.e4.javascript.JSBundleException;
import org.eclipse.e4.javascript.test.Activator;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JSFrameworkTest
extends TestCase {
    public static String TEST = "test";
    static /* synthetic */ Class class$0;

    private static void writeToFile(String string, File file) throws FileNotFoundException, IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        try {
            bufferedWriter.write(string);
        }
        catch (Throwable throwable) {
            try {
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {}
    }

    public JSFrameworkTest(String string) {
        super(string);
    }

    public void testZeroBundles() {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        JSFrameworkTest.assertEquals((int)0, (int)jSFrameworkImpl.getBundles().length);
    }

    public void testInstallResolveBundle() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
    }

    public void testInstallResolveBundleFromLocation() throws JSBundleException, IOException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        String string = JSONUtil.write(hashMap);
        File file = File.createTempFile("temp", "js");
        try {
            JSFrameworkTest.writeToFile(string, file);
            jSFrameworkImpl.installBundle(file.toURI().toString(), hashMap);
            JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
            JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
            JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
            jSFrameworkImpl.resolve();
            JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        }
        finally {
            file.delete();
        }
    }

    public void testStartStopBundle() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        jSBundle.start();
        JSFrameworkTest.assertEquals((int)32, (int)jSBundle.getState());
        jSBundle.stop();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
    }

    public void testInstallUnresolveableBundle() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        hashMap.put("Imports", "some.test");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
    }

    public void testSingletonInstallResolveBundle() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test; singleton=true");
        hashMap.put("BundleVersion", "1.8");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("BundleSymbolicName", "test; singleton=true");
        hashMap2.put("BundleVersion", "1.9");
        hashMap2.put("Exports", "test");
        hashMap2.put("Script", "var test=\"test\";");
        jSFrameworkImpl.installBundle("testloc2", hashMap2);
        JSBundle jSBundle2 = jSFrameworkImpl.getBundles()[1];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle2.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle2.getState());
    }

    public void testScopedVariableBundle() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        hashMap.put("Script", "var test=\"test\";");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        Scriptable scriptable = jSBundle.getScope();
        Object object = scriptable.get("test", scriptable);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)object);
        JSFrameworkTest.assertEquals((Object)"test", (Object)object);
    }

    public void testScopedVariableBundleWithExtraPath() throws JSBundleException, IOException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        hashMap.put("Script", "var test=\"test\";");
        File file = File.createTempFile("temp1", "js");
        File file2 = File.createTempFile("temp2", "js");
        try {
            hashMap.put("ScriptPath", "., " + file2.getName());
            JSFrameworkTest.writeToFile(JSONUtil.write(hashMap), file);
            JSFrameworkTest.writeToFile("var test2=test +'x';", file2);
            jSFrameworkImpl.installBundle(file.toURI().toString());
            JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
            JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
            JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
            jSFrameworkImpl.resolve();
            JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
            Scriptable scriptable = jSBundle.getScope();
            Object object = scriptable.get("test", scriptable);
            JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)object);
            JSFrameworkTest.assertEquals((Object)"test", (Object)object);
            Object object2 = scriptable.get("test2", scriptable);
            JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)object2);
            JSFrameworkTest.assertEquals((Object)"testx", (Object)object2);
        }
        finally {
            file.delete();
            file2.delete();
        }
    }

    public void testStartStopActivatorBundle() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        String string = "";
        string = String.valueOf(string) + "var x = 1;";
        string = String.valueOf(string) + "var Activator = function() {";
        string = String.valueOf(string) + "this.start = function() {x = x + 1;}\n";
        string = String.valueOf(string) + "this.stop = function() {x = x + 2;}\n";
        string = String.valueOf(string) + "}";
        hashMap.put("Script", string);
        hashMap.put("Activator", "Activator");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        Scriptable scriptable = jSBundle.getScope();
        Object object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"1.0", (String)object.toString());
        jSBundle.start();
        object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"2.0", (String)object.toString());
        jSBundle.stop();
        object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"4.0", (String)object.toString());
        jSBundle.start();
        object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"5.0", (String)object.toString());
        jSBundle.stop();
        object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"7.0", (String)object.toString());
    }

    public void testStartStopScopedActivatorBundle() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        String string = "";
        string = String.valueOf(string) + "var x = 1;";
        string = String.valueOf(string) + "var z = {};";
        string = String.valueOf(string) + "z.Activator = function() {";
        string = String.valueOf(string) + "this.start = function() {x = x + 1;}\n";
        string = String.valueOf(string) + "this.stop = function() {x = x + 2;}\n";
        string = String.valueOf(string) + "}";
        hashMap.put("Script", string);
        hashMap.put("Activator", "z.Activator");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        Scriptable scriptable = jSBundle.getScope();
        Object object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"1.0", (String)object.toString());
        jSBundle.start();
        object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"2.0", (String)object.toString());
        jSBundle.stop();
        object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"4.0", (String)object.toString());
        jSBundle.start();
        object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"5.0", (String)object.toString());
        jSBundle.stop();
        object = scriptable.get("x", scriptable);
        JSFrameworkTest.assertEquals((String)"7.0", (String)object.toString());
    }

    public void testImportsBundle() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        hashMap.put("Imports", "test");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("BundleSymbolicName", "test2");
        hashMap2.put("BundleVersion", "1.8");
        hashMap2.put("Exports", "test");
        hashMap2.put("Script", "var test=\"test\";");
        jSFrameworkImpl.installBundle("testloc2", hashMap2);
        JSBundle jSBundle2 = jSFrameworkImpl.getBundles()[1];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle2.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle2.getState());
        Scriptable scriptable = jSBundle.getScope();
        Object object = scriptable.get("test", scriptable);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)object);
        JSFrameworkTest.assertEquals((Object)"test", (Object)object);
    }

    public void testRequiresBundle() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        hashMap.put("Requires", "test2");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("BundleSymbolicName", "test2");
        hashMap2.put("BundleVersion", "1.8");
        hashMap2.put("Exports", "a.test");
        hashMap2.put("Script", "var a = {}; a.test=\"test\";");
        jSFrameworkImpl.installBundle("testloc2", hashMap2);
        JSBundle jSBundle2 = jSFrameworkImpl.getBundles()[1];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle2.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle2.getState());
        Scriptable scriptable = jSBundle.getScope();
        Object object = scriptable.get("a", scriptable);
        JSFrameworkTest.assertTrue((boolean)(object instanceof Scriptable));
        scriptable = (Scriptable)object;
        object = scriptable.get("test", scriptable);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)object);
        JSFrameworkTest.assertEquals((Object)"test", (Object)object);
    }

    public void testCallFromJava() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        hashMap.put("Script", "var test=function() { return \"test\";}");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        Scriptable scriptable = jSBundle.getScope();
        Object object = scriptable.get("test", scriptable);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)object);
        JSFrameworkTest.assertTrue((boolean)(object instanceof Callable));
        Callable callable = (Callable)object;
        Context.enter();
        try {
            JSFrameworkTest.assertEquals((Object)"test", (Object)callable.call(Context.getCurrentContext(), scriptable, scriptable, null));
        }
        finally {
            Context.exit();
        }
    }

    public void testCallJavaFromJSCreateString() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        hashMap.put("Script", "var test=function() { return new java.lang.String(\"test\");}");
        jSFrameworkImpl.installBundle("testloc", hashMap);
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        Scriptable scriptable = jSBundle.getScope();
        Object object = scriptable.get("test", scriptable);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)object);
        JSFrameworkTest.assertTrue((boolean)(object instanceof Callable));
        Callable callable = (Callable)object;
        Context.enter();
        try {
            Object object2 = callable.call(Context.getCurrentContext(), scriptable, scriptable, null);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object object3 = Context.jsToJava((Object)object2, (Class)clazz);
            JSFrameworkTest.assertEquals((Object)"test", (Object)object3);
        }
        finally {
            Context.exit();
        }
    }

    public void testCallJavaFromJSGetBundleStatic() throws JSBundleException {
        JSFrameworkImpl jSFrameworkImpl = new JSFrameworkImpl();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("BundleSymbolicName", "test");
        hashMap.put("BundleVersion", "1.8");
        String string = "";
        string = String.valueOf(string) + "var test=function() {";
        string = String.valueOf(string) + "var clazz = Packages.org.eclipse.e4.javascript.test.JSFrameworkTest;";
        string = String.valueOf(string) + "return clazz.TEST;";
        string = String.valueOf(string) + "}";
        hashMap.put("Script", string);
        jSFrameworkImpl.installBundle("testloc", hashMap, new RhinoClassLoader(Activator.getBundleContext().getBundle()));
        JSFrameworkTest.assertEquals((int)1, (int)jSFrameworkImpl.getBundles().length);
        JSBundle jSBundle = jSFrameworkImpl.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jSBundle.getState());
        jSFrameworkImpl.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jSBundle.getState());
        Scriptable scriptable = jSBundle.getScope();
        Object object = scriptable.get("test", scriptable);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)object);
        JSFrameworkTest.assertTrue((boolean)(object instanceof Callable));
        Callable callable = (Callable)object;
        Context.enter();
        try {
            Object object2 = callable.call(Context.getCurrentContext(), scriptable, scriptable, null);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object object3 = Context.jsToJava((Object)object2, (Class)clazz);
            JSFrameworkTest.assertEquals((Object)"test", (Object)object3);
        }
        finally {
            Context.exit();
        }
    }
}

