/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.javascript.test;

import junit.framework.TestCase;
import org.eclipse.e4.internal.javascript.JSImport;
import org.eclipse.e4.internal.javascript.VersionRange;

public class JSImportTest
extends TestCase {
    public JSImportTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testNullHeader() {
        try {
            new JSImport(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSImportTest.fail();
    }

    public void testNameAndEmptyVersionRange() {
        JSImport jSImport = new JSImport("a.a");
        JSImportTest.assertEquals((String)"a.a", (String)jSImport.getName());
        JSImportTest.assertEquals((Object)VersionRange.emptyRange, (Object)jSImport.getVersionRange());
        JSImportTest.assertEquals(null, (String)jSImport.getBundleSymbolicName());
        JSImportTest.assertEquals((Object)VersionRange.emptyRange, (Object)jSImport.getBundleVersionRange());
        JSImportTest.assertEquals((int)0, (int)jSImport.getAttributes().size());
        JSImportTest.assertEquals((int)0, (int)jSImport.getDirectives().size());
        JSImportTest.assertEquals((boolean)false, (boolean)jSImport.isOptional());
    }

    public void testNameAndVersion() {
        JSImport jSImport = new JSImport("a.a;version=1.2.1");
        JSImportTest.assertEquals((String)"a.a", (String)jSImport.getName());
        JSImportTest.assertEquals((Object)new VersionRange("1.2.1"), (Object)jSImport.getVersionRange());
        JSImportTest.assertEquals(null, (String)jSImport.getBundleSymbolicName());
        JSImportTest.assertEquals((Object)VersionRange.emptyRange, (Object)jSImport.getBundleVersionRange());
        JSImportTest.assertEquals((int)1, (int)jSImport.getAttributes().size());
        JSImportTest.assertEquals((int)0, (int)jSImport.getDirectives().size());
        JSImportTest.assertEquals((boolean)false, (boolean)jSImport.isOptional());
    }

    public void testBundleNameAndVersion() {
        JSImport jSImport = new JSImport("a.a;version=1.2.1;bundle-symbolic-name=test1;bundle-version=1.8");
        JSImportTest.assertEquals((String)"a.a", (String)jSImport.getName());
        JSImportTest.assertEquals((Object)new VersionRange("1.2.1"), (Object)jSImport.getVersionRange());
        JSImportTest.assertEquals((String)"test1", (String)jSImport.getBundleSymbolicName());
        JSImportTest.assertEquals((Object)new VersionRange("1.8"), (Object)jSImport.getBundleVersionRange());
        JSImportTest.assertEquals((int)3, (int)jSImport.getAttributes().size());
        JSImportTest.assertEquals((int)0, (int)jSImport.getDirectives().size());
        JSImportTest.assertEquals((boolean)false, (boolean)jSImport.isOptional());
    }

    public void testIsOptional() {
        JSImport jSImport = new JSImport("a.a;version=1.2.1;bundle-symbolic-name=test1;bundle-version=1.8;resolution:=optional");
        JSImportTest.assertEquals((String)"a.a", (String)jSImport.getName());
        JSImportTest.assertEquals((Object)new VersionRange("1.2.1"), (Object)jSImport.getVersionRange());
        JSImportTest.assertEquals((String)"test1", (String)jSImport.getBundleSymbolicName());
        JSImportTest.assertEquals((Object)new VersionRange("1.8"), (Object)jSImport.getBundleVersionRange());
        JSImportTest.assertEquals((int)3, (int)jSImport.getAttributes().size());
        JSImportTest.assertEquals((int)1, (int)jSImport.getDirectives().size());
        JSImportTest.assertEquals((boolean)true, (boolean)jSImport.isOptional());
    }
}

