/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.javascript.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.e4.internal.javascript.JSONUtil;

public class JSONUtilTest
extends TestCase {
    public void testNull() {
        String string = JSONUtil.write(null);
        JSONUtilTest.assertEquals((String)string, (String)"null");
        JSONUtilTest.assertNull((Object)JSONUtil.read((String)string));
    }

    public void testTrue() {
        String string = JSONUtil.write((Object)Boolean.TRUE);
        JSONUtilTest.assertEquals((String)string, (String)Boolean.TRUE.toString());
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)string), (Object)Boolean.TRUE);
    }

    public void testFalse() {
        String string = JSONUtil.write((Object)Boolean.FALSE);
        JSONUtilTest.assertEquals((String)string, (String)Boolean.FALSE.toString());
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)string), (Object)Boolean.FALSE);
    }

    public void testNumber() {
        String string = JSONUtil.write((Object)new Integer(-38));
        JSONUtilTest.assertEquals((String)string, (String)"-38");
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)string), (Object)new BigDecimal(-38.0));
        string = JSONUtil.write((Object)new Double(-3.56E-5));
        JSONUtilTest.assertEquals((String)string, (String)"-3.56E-5");
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)string), (Object)new BigDecimal("-3.56E-5"));
    }

    public void testString() {
        String string = JSONUtil.write((Object)"test");
        JSONUtilTest.assertEquals((String)string, (String)"\"test\"");
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)string), (Object)"test");
        string = JSONUtil.write((Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals((String)string, (String)"\"\\\\\\/\\\"\\b\\f\\n\\r\\t\\u0000\"");
        JSONUtilTest.assertEquals((Object)JSONUtil.read((String)string), (Object)"\\/\"\b\f\n\r\t\u0000");
    }

    public void testMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("number", new Integer(8675309));
        hashMap.put("string", "goog");
        hashMap.put("escape", "\\/\"\b\f\n\r\t\u0000");
        hashMap.put("true", Boolean.TRUE);
        hashMap.put("false", Boolean.FALSE);
        hashMap.put("null", null);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("test", "test\n");
        hashMap.put("object", hashMap2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("anothertest");
        hashMap.put("array", arrayList);
        String string = JSONUtil.write(hashMap);
        Map map = (Map)JSONUtil.read((String)string);
        JSONUtilTest.assertEquals(map.get("number"), (Object)new BigDecimal(8675309.0));
        JSONUtilTest.assertEquals(map.get("string"), (Object)"goog");
        JSONUtilTest.assertEquals(map.get("escape"), (Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals(map.get("true"), (Object)Boolean.TRUE);
        JSONUtilTest.assertEquals(map.get("false"), (Object)Boolean.FALSE);
        JSONUtilTest.assertEquals(map.get("null"), null);
        Map map2 = (Map)map.get("object");
        JSONUtilTest.assertEquals(map2.get("test"), (Object)"test\n");
        JSONUtilTest.assertEquals((int)1, (int)map2.size());
        Collection collection = (Collection)map.get("array");
        JSONUtilTest.assertTrue((boolean)collection.contains("anothertest"));
        JSONUtilTest.assertEquals((int)1, (int)collection.size());
    }

    public void testWhiteSpaceMap() {
        String string = "\t\r\n  {\t\r\n  \"string\"\t\r\n  :\t\r\n  \"goog\"\t\r\n  ,\t\r\n  \"false\"\t\r\n  :\t\r\n  false\t\r\n  ,\t\r\n  \"true\"\t\r\n  :\t\r\n  true\t\r\n  ,\t\r\n  \"number\"\t\r\n  :\t\r\n  8675309\t\r\n  ,\t\r\n  \"object\"\t\r\n  :\t\r\n  {\t\r\n  \"test\"\t\r\n  :\t\r\n  \"test\\n\"\t\r\n  }\t\r\n  ,\t\r\n  \"null\"\t\r\n  :\t\r\n  null\t\r\n  ,\t\r\n  ";
        string = String.valueOf(string) + "\t\r\n  \"escape\"\t\r\n  :\t\r\n  \"\\\\\\/\\\"\\b\\f\\n\\r\\t\\u0000\"\t\r\n  ";
        string = String.valueOf(string) + "\t\r\n  ,\t\r\n  \"array\"\t\r\n  :\t\r\n  [\t\r\n  \"anothertest\"\t\r\n  ]\t\r\n  }\t\r\n  ";
        Map map = (Map)JSONUtil.read((String)string);
        JSONUtilTest.assertEquals(map.get("number"), (Object)new BigDecimal(8675309.0));
        JSONUtilTest.assertEquals(map.get("string"), (Object)"goog");
        JSONUtilTest.assertEquals(map.get("escape"), (Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals(map.get("true"), (Object)Boolean.TRUE);
        JSONUtilTest.assertEquals(map.get("false"), (Object)Boolean.FALSE);
        JSONUtilTest.assertEquals(map.get("null"), null);
        Map map2 = (Map)map.get("object");
        JSONUtilTest.assertEquals(map2.get("test"), (Object)"test\n");
        JSONUtilTest.assertEquals((int)1, (int)map2.size());
        Collection collection = (Collection)map.get("array");
        JSONUtilTest.assertTrue((boolean)collection.contains("anothertest"));
        JSONUtilTest.assertEquals((int)1, (int)collection.size());
    }

    public void testArray() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Integer(8675309));
        arrayList.add("goog");
        arrayList.add("\\/\"\b\f\n\r\t\u0000");
        arrayList.add(Boolean.TRUE);
        arrayList.add(Boolean.FALSE);
        arrayList.add(null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("test", "test\n");
        arrayList.add(hashMap);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("anothertest");
        arrayList.add(arrayList2);
        String string = JSONUtil.write(arrayList);
        List list = (List)JSONUtil.read((String)string);
        JSONUtilTest.assertEquals(list.get(0), (Object)new BigDecimal(8675309.0));
        JSONUtilTest.assertEquals(list.get(1), (Object)"goog");
        JSONUtilTest.assertEquals(list.get(2), (Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals(list.get(3), (Object)Boolean.TRUE);
        JSONUtilTest.assertEquals(list.get(4), (Object)Boolean.FALSE);
        JSONUtilTest.assertEquals(list.get(5), null);
        Map map = (Map)list.get(6);
        JSONUtilTest.assertEquals(map.get("test"), (Object)"test\n");
        JSONUtilTest.assertEquals((int)1, (int)map.size());
        Collection collection = (Collection)list.get(7);
        JSONUtilTest.assertTrue((boolean)collection.contains("anothertest"));
        JSONUtilTest.assertEquals((int)1, (int)collection.size());
    }

    public void testWhiteSpaceArray() {
        String string = "   \t\r\n   [   \t\r\n   8675309   \t\r\n   ,   \t\r\n   \"goog\"   \t\r\n   ,   \t\r\n   ";
        string = String.valueOf(string) + "\"\\\\\\/\\\"\\b\\f\\n\\r\\t\\u0000\"";
        string = String.valueOf(string) + "   \t\r\n   ,   \t\r\n   true   \t\r\n   ,   \t\r\n   false   \t\r\n   ,   \t\r\n   null   \t\r\n   ,{   \t\r\n   \"test\"   \t\r\n   :   \t\r\n   \"test\\n\"   \t\r\n   }   \t\r\n   ,   \t\r\n   [   \t\r\n   \"anothertest\"   \t\r\n   ]   \t\r\n   ]   \t\r\n   ";
        List list = (List)JSONUtil.read((String)string);
        JSONUtilTest.assertEquals(list.get(0), (Object)new BigDecimal(8675309.0));
        JSONUtilTest.assertEquals(list.get(1), (Object)"goog");
        JSONUtilTest.assertEquals(list.get(2), (Object)"\\/\"\b\f\n\r\t\u0000");
        JSONUtilTest.assertEquals(list.get(3), (Object)Boolean.TRUE);
        JSONUtilTest.assertEquals(list.get(4), (Object)Boolean.FALSE);
        JSONUtilTest.assertEquals(list.get(5), null);
        Map map = (Map)list.get(6);
        JSONUtilTest.assertEquals(map.get("test"), (Object)"test\n");
        JSONUtilTest.assertEquals((int)1, (int)map.size());
        Collection collection = (Collection)list.get(7);
        JSONUtilTest.assertTrue((boolean)collection.contains("anothertest"));
        JSONUtilTest.assertEquals((int)1, (int)collection.size());
    }
}

