/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.javascript.test;

import junit.framework.TestCase;
import org.eclipse.e4.internal.javascript.JSRequire;
import org.eclipse.e4.internal.javascript.VersionRange;

public class JSRequireTest
extends TestCase {
    public JSRequireTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testNullHeader() {
        try {
            new JSRequire(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        JSRequireTest.fail();
    }

    public void testNameAndEmptyVersionRange() {
        JSRequire jSRequire = new JSRequire("a.a");
        JSRequireTest.assertEquals((String)"a.a", (String)jSRequire.getName());
        JSRequireTest.assertEquals((Object)VersionRange.emptyRange, (Object)jSRequire.getBundleVersionRange());
        JSRequireTest.assertEquals((int)0, (int)jSRequire.getAttributes().size());
        JSRequireTest.assertEquals((int)0, (int)jSRequire.getDirectives().size());
        JSRequireTest.assertEquals((boolean)false, (boolean)jSRequire.isOptional());
    }

    public void testNameAndVersion() {
        JSRequire jSRequire = new JSRequire("a.a;bundle-version=1.2.1");
        JSRequireTest.assertEquals((String)"a.a", (String)jSRequire.getName());
        JSRequireTest.assertEquals((Object)new VersionRange("1.2.1"), (Object)jSRequire.getBundleVersionRange());
        JSRequireTest.assertEquals((int)1, (int)jSRequire.getAttributes().size());
        JSRequireTest.assertEquals((int)0, (int)jSRequire.getDirectives().size());
        JSRequireTest.assertEquals((boolean)false, (boolean)jSRequire.isOptional());
    }

    public void testIsOptional() {
        JSRequire jSRequire = new JSRequire("a.a;bundle-version=1.2.1;resolution:=optional");
        JSRequireTest.assertEquals((String)"a.a", (String)jSRequire.getName());
        JSRequireTest.assertEquals((Object)new VersionRange("1.2.1"), (Object)jSRequire.getBundleVersionRange());
        JSRequireTest.assertEquals((int)1, (int)jSRequire.getAttributes().size());
        JSRequireTest.assertEquals((int)1, (int)jSRequire.getDirectives().size());
        JSRequireTest.assertEquals((boolean)true, (boolean)jSRequire.isOptional());
    }
}

