/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filesystem;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class URIUtil {
    public static boolean equals(URI uRI, URI uRI2) {
        try {
            return EFS.getStore(uRI).equals(EFS.getStore(uRI2));
        }
        catch (CoreException coreException) {
            return uRI.equals(uRI2);
        }
    }

    public static IPath toPath(URI uRI) {
        Assert.isNotNull((Object)uRI);
        if ("file".equals(uRI.getScheme())) {
            return new Path(uRI.getSchemeSpecificPart());
        }
        if (uRI.getScheme() == null) {
            return new Path(uRI.getPath());
        }
        return null;
    }

    public static URI toURI(IPath iPath) {
        if (iPath == null) {
            return null;
        }
        if (iPath.isAbsolute()) {
            return URIUtil.toURI(iPath.toFile().getAbsolutePath(), true);
        }
        URI uRI = URIUtil.toURI(Path.ROOT.setDevice(iPath.getDevice()));
        return uRI.relativize(URIUtil.toURI(iPath.makeAbsolute()));
    }

    public static URI toURI(String string) {
        return URIUtil.toURI(string, true);
    }

    public static URI toURI(String string, boolean bl) {
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        if (n > 0 && string.charAt(0) != '/' && bl) {
            stringBuffer.append('/');
        }
        if (string.startsWith("//")) {
            stringBuffer.append('/').append('/');
        }
        stringBuffer.append(string);
        try {
            String string2 = null;
            if (n > 0 && stringBuffer.charAt(0) == '/') {
                string2 = "file";
            }
            return new URI(string2, null, stringBuffer.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return new File(string).toURI();
        }
    }

    public static String toDecodedString(URI uRI) {
        String string = uRI.getScheme();
        String string2 = uRI.getSchemeSpecificPart();
        if (string == null) {
            return string2;
        }
        return String.valueOf(string) + ':' + string2;
    }

    private URIUtil() {
    }
}

