/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filesystem.provider;

import org.eclipse.core.filesystem.IFileInfo;

public class FileInfo
implements IFileInfo {
    private static final int ATTRIBUTE_DIRECTORY = 1;
    private static final int ATTRIBUTE_EXISTS = 65536;
    private int attributes = 0;
    private long lastModified = 0L;
    private long length = 0L;
    private String name = "";
    private String linkTarget = null;

    public FileInfo() {
    }

    public FileInfo(String string) {
        this.name = string;
    }

    private void clear(int n) {
        this.attributes &= ~n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((FileInfo)object).name);
    }

    public boolean exists() {
        return this.getAttribute(65536);
    }

    public boolean getAttribute(int n) {
        return this.isSet(n);
    }

    public String getStringAttribute(int n) {
        if (n == 64) {
            return this.linkTarget;
        }
        return null;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.isSet(1L);
    }

    private boolean isSet(long l) {
        return ((long)this.attributes & l) != 0L;
    }

    private void set(int n) {
        this.attributes |= n;
    }

    public void setAttribute(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void setDirectory(boolean bl) {
        if (bl) {
            this.set(1);
        } else {
            this.clear(1);
        }
    }

    public void setExists(boolean bl) {
        if (bl) {
            this.set(65536);
        } else {
            this.clear(65536);
        }
    }

    public void setLastModified(long l) {
        this.lastModified = l;
    }

    public void setLength(long l) {
        this.length = l;
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.name = string;
    }

    public void setStringAttribute(int n, String string) {
        if (n == 64) {
            this.linkTarget = string;
        }
    }

    public String toString() {
        return this.name;
    }
}

