/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filesystem.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.FileCache;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.osgi.util.NLS;

public abstract class FileStore
extends PlatformObject
implements IFileStore {
    private static final byte[] buffer = new byte[8192];
    protected static final IFileInfo[] EMPTY_FILE_INFO_ARRAY = new IFileInfo[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void transferStreams(InputStream inputStream, OutputStream outputStream, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            byte[] byArray = buffer;
            synchronized (buffer) {
                while (true) {
                    String string2;
                    int n = -1;
                    try {
                        n = inputStream.read(buffer);
                    }
                    catch (IOException iOException) {
                        string2 = NLS.bind((String)Messages.failedReadDuringWrite, (Object)string);
                        Policy.error(271, string2, iOException);
                    }
                    if (n == -1) break;
                    try {
                        outputStream.write(buffer, 0, n);
                    }
                    catch (IOException iOException) {
                        string2 = NLS.bind((String)Messages.couldNotWrite, (Object)string);
                        Policy.error(272, string2, iOException);
                    }
                    iProgressMonitor.worked(1);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        finally {
            Policy.safeClose(inputStream);
            Policy.safeClose(outputStream);
        }
        {
            return;
        }
    }

    public IFileInfo[] childInfos(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        IFileStore[] iFileStoreArray = this.childStores(n, iProgressMonitor);
        IFileInfo[] iFileInfoArray = new IFileInfo[iFileStoreArray.length];
        int n2 = 0;
        while (n2 < iFileStoreArray.length) {
            iFileInfoArray[n2] = iFileStoreArray[n2].fetchInfo();
            ++n2;
        }
        return iFileInfoArray;
    }

    public abstract String[] childNames(int var1, IProgressMonitor var2) throws CoreException;

    public IFileStore[] childStores(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        String[] stringArray = this.childNames(n, iProgressMonitor);
        IFileStore[] iFileStoreArray = new IFileStore[stringArray.length];
        int n2 = 0;
        while (n2 < iFileStoreArray.length) {
            iFileStoreArray[n2] = this.getChild(stringArray[n2]);
            ++n2;
        }
        return iFileStoreArray;
    }

    public void copy(IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        Policy.checkCanceled(iProgressMonitor);
        IFileInfo iFileInfo = this.fetchInfo(0, null);
        if (iFileInfo.isDirectory()) {
            this.copyDirectory(iFileInfo, iFileStore, n, iProgressMonitor);
        } else {
            this.copyFile(iFileInfo, iFileStore, n, iProgressMonitor);
        }
    }

    protected void copyDirectory(IFileInfo iFileInfo, IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            IFileStore[] iFileStoreArray = null;
            int n2 = 1;
            if ((n & 4) == 0) {
                iFileStoreArray = this.childStores(0, null);
                n2 += iFileStoreArray.length;
            }
            iProgressMonitor.beginTask("", n2);
            iProgressMonitor.subTask(NLS.bind((String)Messages.copying, (Object)this.toString()));
            iFileStore.mkdir(0, Policy.subMonitorFor(iProgressMonitor, 1));
            this.transferAttributes(iFileInfo, iFileStore);
            if (iFileStoreArray == null) {
                return;
            }
            int n3 = 0;
            while (n3 < iFileStoreArray.length) {
                iFileStoreArray[n3].copy(iFileStore.getChild(iFileStoreArray[n3].getName()), n, Policy.subMonitorFor(iProgressMonitor, 1));
                ++n3;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void copyFile(IFileInfo iFileInfo, IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            long l;
            if ((n & 2) == 0 && iFileStore.fetchInfo().exists()) {
                Policy.error(268, NLS.bind((String)Messages.fileExists, (Object)iFileStore));
            }
            int n2 = (l = iFileInfo.getLength()) == -1L ? -1 : 1 + (int)(l / (long)buffer.length);
            String string = this.toString();
            iProgressMonitor.beginTask(NLS.bind((String)Messages.copying, (Object)string), n2);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = this.openInputStream(0, Policy.subMonitorFor(iProgressMonitor, 0));
                outputStream = iFileStore.openOutputStream(0, Policy.subMonitorFor(iProgressMonitor, 0));
                FileStore.transferStreams(inputStream, outputStream, string, iProgressMonitor);
                this.transferAttributes(iFileInfo, iFileStore);
            }
            catch (CoreException coreException) {
                Policy.safeClose(inputStream);
                Policy.safeClose(outputStream);
                if (!iFileStore.fetchInfo(0, null).exists()) {
                    iFileStore.delete(0, null);
                }
                throw coreException;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void delete(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Policy.error(273, NLS.bind((String)Messages.noImplDelete, (Object)this.toString()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FileStore)) {
            return false;
        }
        return this.toURI().equals(((FileStore)object).toURI());
    }

    public IFileInfo fetchInfo() {
        try {
            return this.fetchInfo(0, null);
        }
        catch (CoreException coreException) {
            FileInfo fileInfo = new FileInfo(this.getName());
            fileInfo.setExists(false);
            return fileInfo;
        }
    }

    public abstract IFileInfo fetchInfo(int var1, IProgressMonitor var2) throws CoreException;

    public IFileStore getChild(IPath iPath) {
        IFileStore iFileStore = this;
        int n = 0;
        int n2 = iPath.segmentCount();
        while (n < n2) {
            iFileStore = iFileStore.getChild(iPath.segment(n));
            ++n;
        }
        return iFileStore;
    }

    public IFileStore getFileStore(IPath iPath) {
        IFileStore iFileStore = this;
        String string = null;
        int n = 0;
        int n2 = iPath.segmentCount();
        while (n < n2) {
            string = iPath.segment(n);
            if (!string.equals(".")) {
                iFileStore = string.equals("..") && iFileStore.getParent() != null ? iFileStore.getParent() : iFileStore.getChild(string);
            }
            ++n;
        }
        return iFileStore;
    }

    public abstract IFileStore getChild(String var1);

    public IFileSystem getFileSystem() {
        try {
            return EFS.getFileSystem(this.toURI().getScheme());
        }
        catch (CoreException coreException) {
            throw new RuntimeException(coreException);
        }
    }

    public abstract String getName();

    public abstract IFileStore getParent();

    public int hashCode() {
        return this.toURI().hashCode();
    }

    public boolean isParentOf(IFileStore iFileStore) {
        do {
            if ((iFileStore = iFileStore.getParent()) != null) continue;
            return false;
        } while (!this.equals(iFileStore));
        return true;
    }

    public IFileStore mkdir(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Policy.error(272, NLS.bind((String)Messages.noImplWrite, (Object)this.toString()));
        return null;
    }

    public void move(IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            try {
                iProgressMonitor.beginTask(NLS.bind((String)Messages.moving, (Object)iFileStore.toString()), 100);
                this.copy(iFileStore, n & 2, Policy.subMonitorFor(iProgressMonitor, 70));
                this.delete(0, Policy.subMonitorFor(iProgressMonitor, 30));
            }
            catch (CoreException coreException) {
                String string = NLS.bind((String)Messages.couldNotMove, (Object)this.toString());
                Policy.error(272, string, coreException);
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public abstract InputStream openInputStream(int var1, IProgressMonitor var2) throws CoreException;

    public OutputStream openOutputStream(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Policy.error(272, NLS.bind((String)Messages.noImplWrite, (Object)this.toString()));
        return null;
    }

    public void putInfo(IFileInfo iFileInfo, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        Policy.error(272, NLS.bind((String)Messages.noImplWrite, (Object)this.toString()));
    }

    public File toLocalFile(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        if (n != 4096) {
            return null;
        }
        return FileCache.getCache().cache(this, iProgressMonitor);
    }

    public String toString() {
        return this.toURI().toString();
    }

    public abstract URI toURI();

    private void transferAttributes(IFileInfo iFileInfo, IFileStore iFileStore) throws CoreException {
        int n = 3072;
        iFileStore.putInfo(iFileInfo, n, null);
    }
}

