/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filesystem.Activator;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class FileCache {
    private static final String CACHE_DIR_NAME = "filecache";
    private static final Object creationLock = new Object();
    private static FileCache instance = null;
    private File cacheDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileCache getCache() throws CoreException {
        Object object = creationLock;
        synchronized (object) {
            if (instance == null) {
                instance = new FileCache();
            }
            return instance;
        }
    }

    private FileCache() throws CoreException {
        IPath iPath = Activator.getCacheLocation();
        File file = new File(iPath.toFile(), CACHE_DIR_NAME);
        this.cleanOldCache(file);
        file.mkdirs();
        this.cacheDir = this.getUniqueDirectory(file, true);
    }

    public File cache(IFileStore iFileStore, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iProgressMonitor.beginTask(NLS.bind((String)Messages.copying, (Object)this.toString()), 100);
            IFileInfo iFileInfo = iFileStore.fetchInfo(0, Policy.subMonitorFor(iProgressMonitor, 25));
            if (!iFileInfo.exists()) {
                File file = new File(this.cacheDir, "Non-Existent-" + System.currentTimeMillis());
                return file;
            }
            File file = iFileInfo.isDirectory() ? this.getUniqueDirectory(this.cacheDir, false) : File.createTempFile(iFileStore.getFileSystem().getScheme(), "efs", this.cacheDir);
            iProgressMonitor.worked(25);
            LocalFile localFile = new LocalFile(file);
            iFileStore.copy(localFile, 2, Policy.subMonitorFor(iProgressMonitor, 25));
            file.deleteOnExit();
            File file2 = file;
            return file2;
        }
        catch (IOException iOException) {
            Policy.error(272, NLS.bind((String)Messages.couldNotWrite, (Object)this.toString()));
            return null;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void cleanOldCache(File file) throws CoreException {
        new LocalFile(file).delete(0, null);
    }

    private File getUniqueDirectory(File file, boolean bl) {
        File file2;
        long l = 0L;
        while ((file2 = new File(file, Long.toString(System.currentTimeMillis() + l++))).exists()) {
        }
        if (bl) {
            file2.mkdir();
        }
        return file2;
    }
}

