/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

public class InternalFileSystemCore
implements IRegistryChangeListener {
    private static final InternalFileSystemCore INSTANCE = new InternalFileSystemCore();
    private HashMap fileSystems;

    public static InternalFileSystemCore getInstance() {
        return INSTANCE;
    }

    private InternalFileSystemCore() {
        RegistryFactory.getRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public IFileSystem getFileSystem(String string) throws CoreException {
        if (string == null) {
            throw new NullPointerException();
        }
        HashMap hashMap = this.getFileSystemRegistry();
        Object v = hashMap.get(string);
        if (v == null) {
            Policy.error(566, NLS.bind((String)Messages.noFileSystem, (Object)string));
        }
        if (v instanceof IFileSystem) {
            return (IFileSystem)v;
        }
        try {
            IConfigurationElement iConfigurationElement = (IConfigurationElement)v;
            FileSystem fileSystem = (FileSystem)iConfigurationElement.createExecutableExtension("run");
            fileSystem.initialize(string);
            hashMap.put(string, fileSystem);
            return fileSystem;
        }
        catch (CoreException coreException) {
            hashMap.remove(string);
            throw coreException;
        }
    }

    public IFileSystem getLocalFileSystem() {
        try {
            return this.getFileSystem("file");
        }
        catch (CoreException coreException) {
            throw new Error(coreException);
        }
    }

    public IFileStore getStore(URI uRI) throws CoreException {
        String string = uRI.getScheme();
        if (string == null) {
            Policy.error(566, String.valueOf(Messages.noScheme) + uRI);
        }
        return this.getFileSystem(string).getStore(uRI);
    }

    private synchronized HashMap getFileSystemRegistry() {
        if (this.fileSystems == null) {
            this.fileSystems = new HashMap();
            IExtensionPoint iExtensionPoint = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.core.filesystem", "filesystems");
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string;
                    if ("filesystem".equals(iConfigurationElementArray[n2].getName()) && (string = iConfigurationElementArray[n2].getAttribute("scheme")) != null) {
                        this.fileSystems.put(string, iConfigurationElementArray[n2]);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return this.fileSystems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.core.filesystem", "filesystems");
        if (iExtensionDeltaArray.length == 0) {
            return;
        }
        InternalFileSystemCore internalFileSystemCore = this;
        synchronized (internalFileSystemCore) {
            this.fileSystems = null;
        }
    }

    public IFileSystem getNullFileSystem() {
        try {
            return this.getFileSystem("null");
        }
        catch (CoreException coreException) {
            throw new Error(coreException);
        }
    }
}

