/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.filesystem.NullFileSystem;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class NullFileStore
extends FileStore {
    private IPath path;

    public NullFileStore(IPath iPath) {
        this.path = iPath;
    }

    public IFileInfo[] childInfos(int n, IProgressMonitor iProgressMonitor) {
        return EMPTY_FILE_INFO_ARRAY;
    }

    public String[] childNames(int n, IProgressMonitor iProgressMonitor) {
        return EMPTY_STRING_ARRAY;
    }

    public void delete(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        super.delete(n, iProgressMonitor);
    }

    public IFileInfo fetchInfo(int n, IProgressMonitor iProgressMonitor) {
        FileInfo fileInfo = new FileInfo(this.getName());
        fileInfo.setExists(false);
        return fileInfo;
    }

    public IFileStore getChild(String string) {
        return new NullFileStore(this.path.append(string));
    }

    public IFileSystem getFileSystem() {
        return NullFileSystem.getInstance();
    }

    public String getName() {
        return String.valueOf(this.path.lastSegment());
    }

    public IFileStore getParent() {
        return this.path.segmentCount() == 0 ? null : new NullFileStore(this.path.removeLastSegments(1));
    }

    public IFileStore mkdir(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        return super.mkdir(n, iProgressMonitor);
    }

    public InputStream openInputStream(int n, IProgressMonitor iProgressMonitor) {
        return new ByteArrayInputStream(new byte[0]);
    }

    public OutputStream openOutputStream(int n, IProgressMonitor iProgressMonitor) {
        return new OutputStream(){

            public void write(int n) {
            }
        };
    }

    public void putInfo(IFileInfo iFileInfo, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        super.putInfo(iFileInfo, n, iProgressMonitor);
    }

    public String toString() {
        return this.path.toString();
    }

    public URI toURI() {
        try {
            return new URI("null", null, this.path.isEmpty() ? "/" : this.path.toString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            Policy.log(4, "Invalid URI", uRISyntaxException);
            return null;
        }
    }
}

