/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class Policy {
    public static boolean DEBUG = false;
    public static final String PI_FILE_SYSTEM = "org.eclipse.core.filesystem";

    public static void checkCanceled(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static void debug(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new Date(System.currentTimeMillis()));
        stringBuffer.append(" - [");
        stringBuffer.append(Thread.currentThread().getName());
        stringBuffer.append("] ");
        stringBuffer.append(string);
        System.out.println(stringBuffer.toString());
    }

    public static void error(int n, String string) throws CoreException {
        Policy.error(n, string, null);
    }

    public static void error(int n, String string, Throwable throwable) throws CoreException {
        int n2 = n == 0 ? 0 : 1 << n % 100 / 33;
        throw new CoreException((IStatus)new Status(n2, PI_FILE_SYSTEM, n, string, throwable));
    }

    public static void log(int n, String string, Throwable throwable) {
        if (string == null) {
            string = "";
        }
        RuntimeLog.log((IStatus)new Status(n, PI_FILE_SYSTEM, 1, string, throwable));
    }

    public static IProgressMonitor monitorFor(IProgressMonitor iProgressMonitor) {
        return iProgressMonitor == null ? new NullProgressMonitor() : iProgressMonitor;
    }

    public static void safeClose(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void safeClose(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor iProgressMonitor, int n) {
        if (iProgressMonitor == null) {
            return new NullProgressMonitor();
        }
        if (iProgressMonitor instanceof NullProgressMonitor) {
            return iProgressMonitor;
        }
        return new SubProgressMonitor(iProgressMonitor, n);
    }
}

