/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.internal.filesystem.local.LocalFileSystem;

public class Convert {
    private static String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
    private static final boolean isWindows = "win32".equals(LocalFileSystem.getOS());
    private static final String WIN32_FILE_PREFIX = "\\\\?\\";
    private static final String WIN32_UNC_FILE_PREFIX = "\\\\?\\UNC";

    public static byte[] longToBytes(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < byArray.length) {
            byArray[byArray.length - 1 - n] = (byte)l;
            l >>>= 8;
            ++n;
        }
        return byArray;
    }

    public static long bytesToLong(byte[] byArray) {
        long l = 0L;
        int n = 0;
        while (n < byArray.length) {
            l <<= 8;
            l ^= (long)(byArray[n] & 0xFF);
            ++n;
        }
        return l;
    }

    public static String fromPlatformBytes(byte[] byArray) {
        if (defaultEncoding == null) {
            return new String(byArray);
        }
        try {
            return new String(byArray, defaultEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            defaultEncoding = null;
            return new String(byArray);
        }
    }

    public static byte[] toPlatformBytes(String string) {
        if (defaultEncoding == null) {
            return string.getBytes();
        }
        try {
            return string.getBytes(defaultEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            defaultEncoding = null;
            return string.getBytes();
        }
    }

    public static char[] toPlatformChars(String string) {
        if (!isWindows) {
            return string.toCharArray();
        }
        if (string.startsWith("\\\\")) {
            int n = string.length();
            int n2 = WIN32_UNC_FILE_PREFIX.length();
            char[] cArray = new char[n2 + n - 1];
            WIN32_UNC_FILE_PREFIX.getChars(0, n2, cArray, 0);
            string.getChars(1, n, cArray, n2);
            return cArray;
        }
        int n = string.length();
        int n3 = WIN32_FILE_PREFIX.length();
        char[] cArray = new char[n3 + n];
        WIN32_UNC_FILE_PREFIX.getChars(0, n3, cArray, 0);
        string.getChars(0, n, cArray, n3);
        return cArray;
    }
}

