/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.internal.filesystem.local.InfiniteProgress;
import org.eclipse.core.internal.filesystem.local.LocalFileNatives;
import org.eclipse.core.internal.filesystem.local.LocalFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class LocalFile
extends FileStore {
    protected final File file;
    protected final String filePath;

    private static int attributes(File file) {
        if (!file.exists() || file.canWrite()) {
            return 0;
        }
        return 2;
    }

    public LocalFile(File file) {
        this.file = file;
        this.filePath = file.getAbsolutePath();
    }

    private void checkReadOnlyParent(File file, Throwable throwable) throws CoreException {
        File file2 = file.getParentFile();
        if (file2 != null && (LocalFile.attributes(file2) & 2) != 0) {
            String string = NLS.bind((String)Messages.readOnlyParent, (Object)file.getAbsolutePath());
            Policy.error(277, string, throwable);
        }
    }

    private void checkTargetIsNotWritable(File file, Throwable throwable) throws CoreException {
        if (!file.canWrite()) {
            String string = NLS.bind((String)Messages.couldNotWrite, (Object)file.getAbsolutePath());
            Policy.error(272, string);
        }
    }

    public String[] childNames(int n, IProgressMonitor iProgressMonitor) {
        String[] stringArray = this.file.list();
        return stringArray == null ? EMPTY_STRING_ARRAY : stringArray;
    }

    public void copy(IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iFileStore instanceof LocalFile) {
            File file = this.file;
            File file2 = ((LocalFile)iFileStore).file;
            try {
                if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
                    return;
                }
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)Messages.couldNotRead, (Object)file.getAbsolutePath());
                Policy.error(271, string, iOException);
            }
        }
        super.copy(iFileStore, n, iProgressMonitor);
    }

    public void delete(int n, IProgressMonitor object) throws CoreException {
        object = object == null ? new NullProgressMonitor() : new InfiniteProgress((IProgressMonitor)object);
        try {
            object.beginTask(NLS.bind((String)Messages.deleting, (Object)this), 200);
            String string = Messages.deleteProblem;
            MultiStatus multiStatus = new MultiStatus("org.eclipse.core.filesystem", 273, string, null);
            this.internalDelete(this.file, this.filePath, multiStatus, (IProgressMonitor)object);
            if (!multiStatus.isOK()) {
                throw new CoreException((IStatus)multiStatus);
            }
        }
        finally {
            object.done();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalFile)) {
            return false;
        }
        LocalFile localFile = (LocalFile)object;
        if (LocalFileSystem.MACOSX) {
            return this.filePath.toLowerCase().equals(localFile.filePath.toLowerCase());
        }
        return this.file.equals(localFile.file);
    }

    public IFileInfo fetchInfo(int n, IProgressMonitor iProgressMonitor) {
        if (LocalFileNatives.usingNatives()) {
            FileInfo fileInfo = LocalFileNatives.fetchFileInfo(this.filePath);
            if (fileInfo.getName().length() == 0) {
                fileInfo.setName(this.file.getName());
            }
            return fileInfo;
        }
        FileInfo fileInfo = new FileInfo(this.file.getName());
        long l = this.file.lastModified();
        if (l <= 0L) {
            fileInfo.setExists(false);
            return fileInfo;
        }
        fileInfo.setLastModified(l);
        fileInfo.setExists(true);
        fileInfo.setLength(this.file.length());
        fileInfo.setDirectory(this.file.isDirectory());
        fileInfo.setAttribute(2, this.file.exists() && !this.file.canWrite());
        fileInfo.setAttribute(16, this.file.isHidden());
        return fileInfo;
    }

    public IFileStore getChild(IPath iPath) {
        return new LocalFile(new File(this.file, iPath.toOSString()));
    }

    public IFileStore getFileStore(IPath iPath) {
        return new LocalFile(new Path(this.file.getPath()).append(iPath).toFile());
    }

    public IFileStore getChild(String string) {
        return new LocalFile(new File(this.file, string));
    }

    public IFileSystem getFileSystem() {
        return LocalFileSystem.getInstance();
    }

    public String getName() {
        return this.file.getName();
    }

    public IFileStore getParent() {
        File file = this.file.getParentFile();
        return file == null ? null : new LocalFile(file);
    }

    public int hashCode() {
        if (LocalFileSystem.MACOSX) {
            return this.filePath.toLowerCase().hashCode();
        }
        return this.file.hashCode();
    }

    private boolean internalDelete(File file, String string, MultiStatus multiStatus, IProgressMonitor iProgressMonitor) {
        Object object;
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (file.delete() || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            iProgressMonitor.subTask(NLS.bind((String)Messages.deleting, (Object)file));
            object = file.list();
            if (object == null) {
                object = EMPTY_STRING_ARRAY;
            }
            int n = string.length();
            boolean bl = false;
            int n2 = 0;
            int n3 = ((String[])object).length;
            while (n2 < n3) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                StringBuffer stringBuffer = new StringBuffer(n + object[n2].length() + 1);
                stringBuffer.append(string);
                stringBuffer.append(File.separatorChar);
                stringBuffer.append(object[n2]);
                String string2 = stringBuffer.toString();
                bl = !this.internalDelete(new File(string2), string2, multiStatus, iProgressMonitor) || bl;
                iProgressMonitor.worked(1);
                ++n2;
            }
            try {
                if (!bl && file.delete()) {
                    return true;
                }
            }
            catch (Exception exception) {
                String string3 = NLS.bind((String)Messages.couldnotDelete, (Object)file.getAbsolutePath());
                multiStatus.add((IStatus)new Status(4, "org.eclipse.core.filesystem", 273, string3, (Throwable)exception));
                return false;
            }
        }
        object = null;
        object = this.fetchInfo().getAttribute(2) ? NLS.bind((String)Messages.couldnotDeleteReadOnly, (Object)file.getAbsolutePath()) : NLS.bind((String)Messages.couldnotDelete, (Object)file.getAbsolutePath());
        multiStatus.add((IStatus)new Status(4, "org.eclipse.core.filesystem", 273, (String)object, null));
        return false;
    }

    public boolean isParentOf(IFileStore iFileStore) {
        int n;
        if (!(iFileStore instanceof LocalFile)) {
            return false;
        }
        String string = this.filePath;
        String string2 = ((LocalFile)iFileStore).filePath;
        int n2 = string.length();
        if (n2 >= (n = string2.length())) {
            return false;
        }
        if (this.getFileSystem().isCaseSensitive() ? string2.indexOf(string) != 0 : string2.toLowerCase().indexOf(string.toLowerCase()) != 0) {
            return false;
        }
        return string.charAt(n2 - 1) == File.separatorChar || string2.charAt(n2) == File.separatorChar;
    }

    public IFileStore mkdir(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl;
        boolean bl2 = bl = (n & 4) != 0;
        if (bl) {
            this.file.mkdir();
        } else {
            this.file.mkdirs();
        }
        if (!this.file.isDirectory()) {
            this.checkReadOnlyParent(this.file, null);
            this.checkTargetIsNotWritable(this.file, null);
            String string = NLS.bind((String)Messages.failedCreateWrongType, (Object)this.filePath);
            Policy.error(276, string);
        }
        return this;
    }

    public void move(IFileStore iFileStore, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!(iFileStore instanceof LocalFile)) {
            super.move(iFileStore, n, iProgressMonitor);
            return;
        }
        File file = this.file;
        File file2 = ((LocalFile)iFileStore).file;
        boolean bl = (n & 2) != 0;
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            String string;
            iProgressMonitor.beginTask(NLS.bind((String)Messages.moving, (Object)file.getAbsolutePath()), 10);
            boolean bl2 = false;
            try {
                bl2 = file.getCanonicalFile().equals(file2.getCanonicalFile());
            }
            catch (IOException iOException) {
                String string2 = NLS.bind((String)Messages.couldNotMove, (Object)file.getAbsolutePath());
                Policy.error(272, string2, iOException);
            }
            if (!bl2 && !bl && file2.exists()) {
                string = NLS.bind((String)Messages.fileExists, (Object)file2.getAbsolutePath());
                Policy.error(268, string);
            }
            if (file.renameTo(file2)) {
                if (!bl2 && file.exists()) {
                    if (file2.exists()) {
                        new LocalFile(file2).delete(0, null);
                        string = NLS.bind((String)Messages.couldnotDelete, (Object)file.getAbsolutePath());
                        Policy.error(273, string);
                    }
                } else {
                    if (!file2.exists()) {
                        string = NLS.bind((String)Messages.failedMove, (Object)file.getAbsolutePath(), (Object)file2.getAbsolutePath());
                        Policy.error(272, string);
                    }
                    iProgressMonitor.worked(10);
                    return;
                }
            }
            if (bl2) {
                string = NLS.bind((String)Messages.couldNotMove, (Object)file.getAbsolutePath());
                Policy.error(272, string, null);
            }
            super.move(iFileStore, n, Policy.subMonitorFor(iProgressMonitor, 10));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public InputStream openInputStream(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1);
            FileInputStream fileInputStream = new FileInputStream(this.file);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = !this.file.exists() ? NLS.bind((String)Messages.fileNotFound, (Object)this.filePath) : (this.file.isDirectory() ? NLS.bind((String)Messages.notAFile, (Object)this.filePath) : NLS.bind((String)Messages.couldNotRead, (Object)this.filePath));
            Policy.error(271, string, fileNotFoundException);
            return null;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public OutputStream openOutputStream(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor = Policy.monitorFor(iProgressMonitor);
        try {
            iProgressMonitor.beginTask("", 1);
            FileOutputStream fileOutputStream = new FileOutputStream(this.file, (n & 1) != 0);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.checkReadOnlyParent(this.file, fileNotFoundException);
            String string = this.filePath;
            String string2 = this.file.isDirectory() ? NLS.bind((String)Messages.notAFile, (Object)string) : NLS.bind((String)Messages.couldNotWrite, (Object)string);
            Policy.error(272, string2, fileNotFoundException);
            return null;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void putInfo(IFileInfo iFileInfo, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl = true;
        if ((n & 0x400) != 0 && LocalFileNatives.usingNatives()) {
            bl &= LocalFileNatives.setFileInfo(this.filePath, iFileInfo, n);
        }
        if ((n & 0x800) != 0) {
            bl &= this.file.setLastModified(iFileInfo.getLastModified());
        }
        if (!bl && !this.file.exists()) {
            Policy.error(269, NLS.bind((String)Messages.fileNotFound, (Object)this.filePath));
        }
    }

    public File toLocalFile(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (n == 4096) {
            return super.toLocalFile(n, iProgressMonitor);
        }
        return this.file;
    }

    public String toString() {
        return this.file.toString();
    }

    public URI toURI() {
        return URIUtil.toURI(this.filePath);
    }
}

