/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.Messages;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.internal.filesystem.local.Convert;
import org.eclipse.osgi.util.NLS;

abstract class LocalFileNatives {
    private static boolean hasNatives = false;
    private static boolean isUnicode = false;
    private static final String LIBRARY_NAME = "localfile_1_0_0";

    static {
        try {
            System.loadLibrary(LIBRARY_NAME);
            hasNatives = true;
            isUnicode = LocalFileNatives.internalIsUnicode();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            LocalFileNatives.logMissingNativeLibrary(unsatisfiedLinkError);
        }
    }

    LocalFileNatives() {
    }

    private static final native int nativeAttributes();

    public static int attributes() {
        try {
            return LocalFileNatives.nativeAttributes();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return -1;
        }
    }

    public static boolean copyAttributes(String string, String string2, boolean bl) {
        if (hasNatives) {
            return isUnicode ? LocalFileNatives.internalCopyAttributesW(Convert.toPlatformChars(string), Convert.toPlatformChars(string2), bl) : LocalFileNatives.internalCopyAttributes(Convert.toPlatformBytes(string), Convert.toPlatformBytes(string2), bl);
        }
        return false;
    }

    public static FileInfo fetchFileInfo(String string) {
        FileInfo fileInfo = new FileInfo();
        if (isUnicode) {
            LocalFileNatives.internalGetFileInfoW(Convert.toPlatformChars(string), fileInfo);
        } else {
            LocalFileNatives.internalGetFileInfo(Convert.toPlatformBytes(string), fileInfo);
        }
        return fileInfo;
    }

    private static final native boolean internalCopyAttributes(byte[] var0, byte[] var1, boolean var2);

    private static final native boolean internalCopyAttributesW(char[] var0, char[] var1, boolean var2);

    private static final native boolean internalGetFileInfo(byte[] var0, IFileInfo var1);

    private static final native boolean internalGetFileInfoW(char[] var0, IFileInfo var1);

    private static final native boolean internalIsUnicode();

    private static final native boolean internalSetFileInfo(byte[] var0, IFileInfo var1);

    private static final native boolean internalSetFileInfoW(char[] var0, IFileInfo var1, int var2);

    private static void logMissingNativeLibrary(UnsatisfiedLinkError unsatisfiedLinkError) {
        String string = System.mapLibraryName(LIBRARY_NAME);
        String string2 = NLS.bind((String)Messages.couldNotLoadLibrary, (Object)string);
        Policy.log(1, string2, unsatisfiedLinkError);
    }

    public static boolean setFileInfo(String string, IFileInfo iFileInfo, int n) {
        if (isUnicode) {
            return LocalFileNatives.internalSetFileInfoW(Convert.toPlatformChars(string), iFileInfo, n);
        }
        return LocalFileNatives.internalSetFileInfo(Convert.toPlatformBytes(string), iFileInfo);
    }

    public static boolean usingNatives() {
        return hasNatives;
    }
}

