/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.internal.filesystem.local.LocalFileNatives;
import org.eclipse.core.runtime.IPath;

public class LocalFileSystem
extends FileSystem {
    static final boolean MACOSX = LocalFileSystem.getOS().equals("macosx");
    private static final boolean caseSensitive = MACOSX ? false : new File("a").compareTo(new File("A")) != 0;
    private int attributes = -1;
    private static IFileSystem instance;

    public static IFileSystem getInstance() {
        return instance;
    }

    static String getOS() {
        return System.getProperty("osgi.os", "");
    }

    public LocalFileSystem() {
        instance = this;
    }

    public int attributes() {
        if (this.attributes != -1) {
            return this.attributes;
        }
        this.attributes = 0;
        if (!LocalFileNatives.usingNatives()) {
            return this.attributes;
        }
        int n = LocalFileNatives.attributes();
        if (n >= 0) {
            this.attributes = n;
            return this.attributes;
        }
        this.attributes |= 2;
        String string = LocalFileSystem.getOS();
        String string2 = System.getProperty("osgi.arch", "");
        if (string.equals("win32")) {
            this.attributes |= 0x18;
        } else if (string.equals("linux") || string.equals("solaris") && string2.equals("sparc")) {
            this.attributes |= 0x64;
        } else if (string.equals("macosx") || string.equals("hpux") || string.equals("qnx")) {
            this.attributes |= 4;
        }
        return this.attributes;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileStore fromLocalFile(File file) {
        return new LocalFile(file);
    }

    public IFileStore getStore(IPath iPath) {
        return new LocalFile(iPath.toFile());
    }

    public IFileStore getStore(URI uRI) {
        return new LocalFile(new File(uRI.getSchemeSpecificPart()));
    }

    public boolean isCaseSensitive() {
        return caseSensitive;
    }
}

