/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.internal.context.ObjectBasic;

public class ContextDynamicTest
extends TestCase {
    public ContextDynamicTest() {
    }

    public ContextDynamicTest(String string) {
        super(string);
    }

    public synchronized void testAddRemove() {
        Integer n = new Integer(123);
        String string = new String("abc");
        String string2 = new String("abcd");
        Object object = new Object();
        IEclipseContext iEclipseContext = EclipseContextFactory.create();
        iEclipseContext.set("Integer", (Object)n);
        iEclipseContext.set("StringViaMethod", (Object)string2);
        iEclipseContext.set("objectViaMethod", null);
        iEclipseContext.set("string", null);
        ObjectBasic objectBasic = new ObjectBasic();
        ContextInjectionFactory.inject((Object)objectBasic, (IEclipseContext)iEclipseContext);
        ContextDynamicTest.assertEquals((Object)n, (Object)objectBasic.getInteger());
        ContextDynamicTest.assertEquals((String)string2, (String)objectBasic.getStringViaMethod());
        ContextDynamicTest.assertEquals((int)1, (int)objectBasic.setStringCalled);
        ContextDynamicTest.assertNull((Object)objectBasic.getString());
        ContextDynamicTest.assertNull((Object)objectBasic.getObjectViaMethod());
        ContextDynamicTest.assertEquals((int)1, (int)objectBasic.setObjectCalled);
        iEclipseContext.set("string", (Object)string);
        iEclipseContext.set("objectViaMethod", object);
        ContextDynamicTest.assertEquals((String)string, (String)objectBasic.getString());
        ContextDynamicTest.assertEquals((Object)n, (Object)objectBasic.getInteger());
        ContextDynamicTest.assertEquals((int)1, (int)objectBasic.setStringCalled);
        ContextDynamicTest.assertEquals((int)2, (int)objectBasic.setObjectCalled);
        ContextDynamicTest.assertEquals((String)string2, (String)objectBasic.getStringViaMethod());
        ContextDynamicTest.assertEquals((Object)object, (Object)objectBasic.getObjectViaMethod());
        iEclipseContext.remove("Integer");
        iEclipseContext.remove("StringViaMethod");
        ContextDynamicTest.assertNull((Object)objectBasic.getInteger());
        ContextDynamicTest.assertEquals((String)string, (String)objectBasic.getString());
        ContextDynamicTest.assertEquals((int)2, (int)objectBasic.setStringCalled);
        ContextDynamicTest.assertEquals((int)2, (int)objectBasic.setObjectCalled);
        ContextDynamicTest.assertNull((Object)objectBasic.getStringViaMethod());
        ContextDynamicTest.assertEquals((Object)object, (Object)objectBasic.getObjectViaMethod());
    }

    public synchronized void testParentAddRemove() {
        Integer n = new Integer(123);
        String string = new String("abc");
        String string2 = new String("abcd");
        Object object = new Object();
        IEclipseContext iEclipseContext = EclipseContextFactory.create();
        iEclipseContext.set("Integer", (Object)n);
        iEclipseContext.set("StringViaMethod", (Object)string2);
        iEclipseContext.set("objectViaMethod", null);
        iEclipseContext.set("string", null);
        IEclipseContext iEclipseContext2 = EclipseContextFactory.create((IEclipseContext)iEclipseContext, null);
        ObjectBasic objectBasic = new ObjectBasic();
        ContextInjectionFactory.inject((Object)objectBasic, (IEclipseContext)iEclipseContext2);
        ContextDynamicTest.assertEquals((Object)n, (Object)objectBasic.getInteger());
        ContextDynamicTest.assertEquals((String)string2, (String)objectBasic.getStringViaMethod());
        ContextDynamicTest.assertEquals((int)1, (int)objectBasic.setStringCalled);
        ContextDynamicTest.assertNull((Object)objectBasic.getString());
        ContextDynamicTest.assertNull((Object)objectBasic.getObjectViaMethod());
        ContextDynamicTest.assertEquals((int)1, (int)objectBasic.setObjectCalled);
        iEclipseContext.set("string", (Object)string);
        iEclipseContext.set("objectViaMethod", object);
        ContextDynamicTest.assertEquals((String)string, (String)objectBasic.getString());
        ContextDynamicTest.assertEquals((Object)n, (Object)objectBasic.getInteger());
        ContextDynamicTest.assertEquals((int)1, (int)objectBasic.setStringCalled);
        ContextDynamicTest.assertEquals((int)2, (int)objectBasic.setObjectCalled);
        ContextDynamicTest.assertEquals((String)string2, (String)objectBasic.getStringViaMethod());
        ContextDynamicTest.assertEquals((Object)object, (Object)objectBasic.getObjectViaMethod());
        iEclipseContext.remove("Integer");
        iEclipseContext.remove("StringViaMethod");
        ContextDynamicTest.assertNull((Object)objectBasic.getInteger());
        ContextDynamicTest.assertEquals((String)string, (String)objectBasic.getString());
        ContextDynamicTest.assertEquals((int)2, (int)objectBasic.setStringCalled);
        ContextDynamicTest.assertEquals((int)2, (int)objectBasic.setObjectCalled);
        ContextDynamicTest.assertNull((Object)objectBasic.getStringViaMethod());
        ContextDynamicTest.assertEquals((Object)object, (Object)objectBasic.getObjectViaMethod());
    }

    public synchronized void testContextAware() {
        IEclipseContext iEclipseContext = EclipseContextFactory.create();
        iEclipseContext.set("stringViaMethod", null);
        iEclipseContext.set("objectViaMethod", null);
        iEclipseContext.set("string", null);
        iEclipseContext.set("integer", null);
        ObjectBasic objectBasic = new ObjectBasic();
        ContextInjectionFactory.inject((Object)objectBasic, (IEclipseContext)iEclipseContext);
        ContextDynamicTest.assertTrue((boolean)objectBasic.isFinalized());
    }

    public static Test suite() {
        return new TestSuite(ContextDynamicTest.class);
    }
}

