/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.internal.context.ObjectBasic;
import org.eclipse.e4.core.services.internal.context.ObjectSubClass;
import org.eclipse.e4.core.services.internal.context.ObjectWithAnnotations;

public class ContextInjectionTest
extends TestCase {
    public ContextInjectionTest() {
    }

    public ContextInjectionTest(String string) {
        super(string);
    }

    public synchronized void testInjection() {
        Integer n = new Integer(123);
        String string = new String("abc");
        Boolean bl = new Boolean(true);
        String string2 = new String("abcd");
        Object object = new Object();
        IEclipseContext iEclipseContext = EclipseContextFactory.create();
        iEclipseContext.set("Integer", (Object)n);
        iEclipseContext.set("string", (Object)string);
        iEclipseContext.set("Boolean", (Object)bl);
        iEclipseContext.set("StringViaMethod", (Object)string2);
        iEclipseContext.set("objectViaMethod", object);
        ObjectBasic objectBasic = new ObjectBasic();
        ContextInjectionFactory.inject((Object)objectBasic, (IEclipseContext)iEclipseContext);
        ContextInjectionTest.assertEquals((String)string, (String)objectBasic.getString());
        ContextInjectionTest.assertEquals((Object)n, (Object)objectBasic.getInteger());
        ContextInjectionTest.assertEquals((Object)iEclipseContext, (Object)objectBasic.getContext());
        ContextInjectionTest.assertEquals((int)1, (int)objectBasic.setStringCalled);
        ContextInjectionTest.assertEquals((int)1, (int)objectBasic.setObjectCalled);
        ContextInjectionTest.assertEquals((String)string2, (String)objectBasic.getStringViaMethod());
        ContextInjectionTest.assertEquals((Object)object, (Object)objectBasic.getObjectViaMethod());
        ContextInjectionTest.assertTrue((boolean)objectBasic.isFinalized());
    }

    public void testOptionalInjection() {
        Integer n = new Integer(123);
        String string = new String("abc");
        Boolean bl = new Boolean(true);
        String string2 = new String("abcd");
        Object object = new Object();
        IEclipseContext iEclipseContext = EclipseContextFactory.create();
        iEclipseContext.set("Integer", (Object)n);
        iEclipseContext.set("string", (Object)string);
        iEclipseContext.set("Boolean", (Object)bl);
        iEclipseContext.set("StringViaMethod", (Object)string2);
        iEclipseContext.set("objectViaMethod", object);
        ObjectWithAnnotations objectWithAnnotations = new ObjectWithAnnotations();
        ContextInjectionFactory.inject((Object)objectWithAnnotations, (IEclipseContext)iEclipseContext);
        ContextInjectionTest.assertEquals((String)string, (String)objectWithAnnotations.getString());
        ContextInjectionTest.assertEquals((Object)n, (Object)objectWithAnnotations.getInteger());
        ContextInjectionTest.assertEquals((Object)iEclipseContext, (Object)objectWithAnnotations.getContext());
        ContextInjectionTest.assertEquals((int)1, (int)objectWithAnnotations.setStringCalled);
        ContextInjectionTest.assertEquals((int)1, (int)objectWithAnnotations.setObjectCalled);
        ContextInjectionTest.assertEquals((String)string2, (String)objectWithAnnotations.getStringViaMethod());
        ContextInjectionTest.assertEquals((Object)object, (Object)objectWithAnnotations.getObjectViaMethod());
        ContextInjectionTest.assertNull((Object)objectWithAnnotations.diMissing);
        ContextInjectionTest.assertNull((Object)objectWithAnnotations.myMissing);
        ContextInjectionTest.assertEquals((int)0, (int)objectWithAnnotations.setMissingCalled);
        ContextInjectionTest.assertNull((Object)objectWithAnnotations.diBoolean);
        ContextInjectionTest.assertNull((Object)objectWithAnnotations.myBoolean);
        ContextInjectionTest.assertEquals((int)0, (int)objectWithAnnotations.setBooleanCalled);
        ContextInjectionTest.assertNull((Object)objectWithAnnotations.diBoolean);
        ContextInjectionTest.assertNull((Object)objectWithAnnotations.myBoolean);
        ContextInjectionTest.assertEquals((int)0, (int)objectWithAnnotations.setBooleanCalled);
        ContextInjectionTest.assertTrue((boolean)objectWithAnnotations.isFinalized());
    }

    public synchronized void testInjectionAndInheritance() {
        Integer n = new Integer(123);
        String string = new String("abc");
        String string2 = new String("abcd");
        Object object = new Object();
        IEclipseContext iEclipseContext = EclipseContextFactory.create();
        iEclipseContext.set("Integer", (Object)n);
        iEclipseContext.set("string", (Object)string);
        iEclipseContext.set("StringViaMethod", (Object)string2);
        iEclipseContext.set("objectViaMethod", object);
        ObjectSubClass objectSubClass = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)objectSubClass, (IEclipseContext)iEclipseContext);
        ContextInjectionTest.assertEquals((String)string, (String)objectSubClass.getString());
        ContextInjectionTest.assertEquals((Object)iEclipseContext, (Object)objectSubClass.getContext());
        ContextInjectionTest.assertEquals((String)string2, (String)objectSubClass.getStringViaMethod());
        ContextInjectionTest.assertEquals((int)1, (int)objectSubClass.setStringCalled);
        ContextInjectionTest.assertEquals((Object)n, (Object)objectSubClass.getInteger());
        ContextInjectionTest.assertEquals((Object)object, (Object)objectSubClass.getObjectViaMethod());
        ContextInjectionTest.assertEquals((int)1, (int)objectSubClass.setObjectCalled);
        ContextInjectionTest.assertEquals((int)1, (int)objectSubClass.getFinalizedCalled());
    }

    public synchronized void testInjectionFromParent() {
        Integer n = new Integer(123);
        String string = new String("abcd");
        Object object = new Object();
        IEclipseContext iEclipseContext = EclipseContextFactory.create();
        iEclipseContext.set("Integer", (Object)n);
        iEclipseContext.set("StringViaMethod", (Object)string);
        IEclipseContext iEclipseContext2 = EclipseContextFactory.create((IEclipseContext)iEclipseContext, null);
        iEclipseContext2.set("objectViaMethod", object);
        iEclipseContext2.set("string", (Object)"foo");
        ObjectBasic objectBasic = new ObjectBasic();
        ContextInjectionFactory.inject((Object)objectBasic, (IEclipseContext)iEclipseContext2);
        ContextInjectionTest.assertEquals((Object)n, (Object)objectBasic.getInteger());
        ContextInjectionTest.assertEquals((Object)iEclipseContext2, (Object)objectBasic.getContext());
        ContextInjectionTest.assertEquals((String)string, (String)objectBasic.getStringViaMethod());
        ContextInjectionTest.assertEquals((Object)object, (Object)objectBasic.getObjectViaMethod());
        ContextInjectionTest.assertEquals((int)1, (int)objectBasic.setStringCalled);
        ContextInjectionTest.assertEquals((int)1, (int)objectBasic.setObjectCalled);
        ContextInjectionTest.assertTrue((boolean)objectBasic.isFinalized());
    }

    public static Test suite() {
        return new TestSuite(ContextInjectionTest.class);
    }
}

