/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.TestCase;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IComputedValue;
import org.eclipse.e4.core.services.context.IEclipseContext;

public class EclipseContextTest
extends TestCase {
    private IEclipseContext context;
    private IEclipseContext parentContext;
    private int runCounter;

    protected void setUp() throws Exception {
        super.setUp();
        this.parentContext = EclipseContextFactory.create();
        this.parentContext.set("DEBUG_STRING", (Object)(String.valueOf(this.getName()) + "-parent"));
        this.context = EclipseContextFactory.create((IEclipseContext)this.parentContext, null);
        this.context.set("DEBUG_STRING", (Object)this.getName());
    }

    public void testContainsKey() {
        EclipseContextTest.assertFalse((String)"1.0", (boolean)this.context.containsKey("function"));
        EclipseContextTest.assertFalse((String)"1.1", (boolean)this.context.containsKey("separator"));
        this.context.set("function", (Object)new ConcatFunction());
        this.context.set("separator", (Object)",");
        EclipseContextTest.assertTrue((String)"2.0", (boolean)this.context.containsKey("function"));
        EclipseContextTest.assertTrue((String)"2.1", (boolean)this.context.containsKey("separator"));
        this.context.set("separator", null);
        EclipseContextTest.assertTrue((String)"3.0", (boolean)this.context.containsKey("separator"));
        this.context.remove("separator");
        EclipseContextTest.assertFalse((String)"4.0", (boolean)this.context.containsKey("separator"));
    }

    public void testFunctions() {
        this.context.set("function", (Object)new ConcatFunction());
        this.context.set("separator", (Object)",");
        EclipseContextTest.assertEquals((Object)"x", (Object)this.context.get("function", (Object[])new String[]{"x"}));
        EclipseContextTest.assertEquals((Object)"x,y", (Object)this.context.get("function", (Object[])new String[]{"x", "y"}));
    }

    public void testGet() {
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        EclipseContextTest.assertNull((Object)this.parentContext.get("foo"));
        this.context.remove("foo");
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.parentContext.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.get("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        EclipseContextTest.assertNull((Object)this.context.get("foo"));
        this.context.set("bar", (Object)"baz");
        EclipseContextTest.assertEquals((Object)"baz", (Object)this.context.get("foo"));
    }

    public void testGetLocal() {
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((Object)"bar", (Object)this.context.getLocal("foo"));
        EclipseContextTest.assertNull((Object)this.parentContext.getLocal("foo"));
        this.context.remove("foo");
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.parentContext.set("foo", (Object)"bar");
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("foo", (Object)new ComputedValueBar());
        EclipseContextTest.assertNull((Object)this.context.getLocal("foo"));
        this.context.set("bar", (Object)"baz");
        EclipseContextTest.assertEquals((Object)"baz", (Object)this.context.getLocal("foo"));
    }

    public void testRunAndTrack() {
        final Object[] objectArray = new Object[1];
        this.context.runAndTrack(new Runnable(){

            public void run() {
                EclipseContextTest eclipseContextTest = EclipseContextTest.this;
                eclipseContextTest.runCounter = eclipseContextTest.runCounter + 1;
                objectArray[0] = EclipseContextTest.this.context.get("foo");
            }
        }, "runnable");
        EclipseContextTest.assertEquals((int)1, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)objectArray[0]);
        this.context.set("foo", (Object)"bar");
        EclipseContextTest.assertEquals((int)2, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"bar", (Object)objectArray[0]);
        this.context.remove("foo");
        EclipseContextTest.assertEquals((int)3, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)objectArray[0]);
        this.context.set("foo", (Object)new IComputedValue(){

            public Object compute(IEclipseContext iEclipseContext, Object[] objectArray) {
                return iEclipseContext.get("bar");
            }
        });
        EclipseContextTest.assertEquals((int)4, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)objectArray[0]);
        this.context.set("bar", (Object)"baz");
        EclipseContextTest.assertEquals((int)5, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"baz", (Object)objectArray[0]);
        this.context.set("bar", (Object)"baf");
        EclipseContextTest.assertEquals((int)6, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"baf", (Object)objectArray[0]);
        this.context.remove("bar");
        EclipseContextTest.assertEquals((int)7, (int)this.runCounter);
        EclipseContextTest.assertEquals(null, (Object)objectArray[0]);
        this.parentContext.set("bar", (Object)"bam");
        EclipseContextTest.assertEquals((int)8, (int)this.runCounter);
        EclipseContextTest.assertEquals((Object)"bam", (Object)objectArray[0]);
    }

    private static class ComputedValueBar
    implements IComputedValue {
        private ComputedValueBar() {
        }

        public Object compute(IEclipseContext iEclipseContext, Object[] objectArray) {
            return iEclipseContext.get("bar");
        }
    }

    private static class ConcatFunction
    implements IComputedValue {
        private ConcatFunction() {
        }

        public Object compute(IEclipseContext iEclipseContext, Object[] objectArray) {
            String string = (String)iEclipseContext.get("separator");
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < objectArray.length) {
                if (n > 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(objectArray[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

