/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import junit.framework.TestCase;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.internal.context.PrintService;
import org.eclipse.e4.core.services.internal.context.StringPrintService;
import org.eclipse.e4.core.services.osgi.IServiceAliasRegistry;
import org.eclipse.e4.core.tests.services.TestActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceContextTest
extends TestCase {
    private IEclipseContext context;

    protected void setUp() throws Exception {
        super.setUp();
        this.context = EclipseContextFactory.createServiceContext((BundleContext)TestActivator.bundleContext);
        ((IServiceAliasRegistry)this.context.get(IServiceAliasRegistry.SERVICE_NAME)).registerAlias("Printer", PrintService.SERVICE_NAME);
    }

    protected void tearDown() throws Exception {
        ((IServiceAliasRegistry)this.context.get(IServiceAliasRegistry.SERVICE_NAME)).unregisterAlias("Printer");
        if (this.context instanceof IDisposable) {
            ((IDisposable)this.context).dispose();
        }
        super.tearDown();
    }

    public void testServiceContextAsParent() {
        IEclipseContext iEclipseContext = EclipseContextFactory.create((IEclipseContext)this.context, null);
        iEclipseContext.set("DEBUG_STRING", (Object)"child");
        IServiceAliasRegistry iServiceAliasRegistry = (IServiceAliasRegistry)iEclipseContext.get(IServiceAliasRegistry.SERVICE_NAME);
        ServiceContextTest.assertNotNull((Object)iServiceAliasRegistry);
    }

    public void testServiceInjection() {
        Printer printer = new Printer();
        StringPrintService stringPrintService = new StringPrintService();
        ServiceRegistration serviceRegistration = TestActivator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrintService, null);
        ContextInjectionFactory.inject((Object)printer, (IEclipseContext)this.context);
        printer.print("test");
        ServiceContextTest.assertEquals((String)"1.0", (String)"test", (String)stringPrintService.toString());
        serviceRegistration.unregister();
        printer.print("another test");
        ServiceContextTest.assertEquals((String)"1.1", (String)"test", (String)stringPrintService.toString());
        ServiceContextTest.assertNull((String)"1.2", (Object)printer.di_Printer);
        StringPrintService stringPrintService2 = new StringPrintService();
        ServiceRegistration serviceRegistration2 = TestActivator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrintService2, null);
        printer.print("yet another test");
        ServiceContextTest.assertEquals((String)"2.0", (String)"test", (String)stringPrintService.toString());
        ServiceContextTest.assertEquals((String)"2.1", (String)"yet another test", (String)stringPrintService2.toString());
        serviceRegistration2.unregister();
        ServiceContextTest.assertNull((String)"2.2", (Object)printer.di_Printer);
    }

    public void testServiceRemovalOnContextDispose() {
        StringPrintService stringPrintService = new StringPrintService();
        ServiceRegistration serviceRegistration = TestActivator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrintService, null);
        ServiceReference serviceReference = serviceRegistration.getReference();
        PrintService printService = (PrintService)this.context.get(PrintService.SERVICE_NAME);
        ServiceContextTest.assertEquals((String)"1.0", (Object)stringPrintService, (Object)printService);
        ServiceContextTest.assertEquals((String)"1.1", (int)1, (int)serviceReference.getUsingBundles().length);
        printService = null;
        ((IDisposable)this.context).dispose();
        ServiceContextTest.assertNull((String)"2.0", (Object)serviceReference.getUsingBundles());
        serviceRegistration.unregister();
    }

    public void testServiceRemovalOnChildContextDispose() {
        StringPrintService stringPrintService = new StringPrintService();
        ServiceRegistration serviceRegistration = TestActivator.bundleContext.registerService(PrintService.SERVICE_NAME, (Object)stringPrintService, null);
        ServiceReference serviceReference = serviceRegistration.getReference();
        IEclipseContext iEclipseContext = EclipseContextFactory.create((IEclipseContext)this.context, null);
        iEclipseContext.set("DEBUG_STRING", (Object)"child");
        PrintService printService = (PrintService)iEclipseContext.get(PrintService.SERVICE_NAME);
        ServiceContextTest.assertEquals((String)"1.0", (Object)stringPrintService, (Object)printService);
        ServiceContextTest.assertEquals((String)"1.1", (int)1, (int)serviceReference.getUsingBundles().length);
        ServiceContextTest.assertTrue((String)"1.2", (boolean)this.context.containsKey(PrintService.SERVICE_NAME));
        printService = null;
        iEclipseContext = null;
        System.gc();
        System.runFinalization();
        System.gc();
        ServiceContextTest.assertTrue((String)"2.0", (boolean)this.context.containsKey(IServiceAliasRegistry.SERVICE_NAME));
        ServiceContextTest.assertNull((String)"2.1", (Object)serviceReference.getUsingBundles());
        serviceRegistration.unregister();
    }

    static class Printer {
        PrintService di_Printer;

        Printer() {
        }

        public void print(String string) {
            if (this.di_Printer != null) {
                this.di_Printer.print(string);
            } else {
                System.out.println(string);
            }
        }
    }
}

