/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MHandledItem;
import org.eclipse.e4.ui.model.application.MHandler;
import org.eclipse.e4.ui.model.application.MItem;
import org.eclipse.e4.ui.model.application.MItemPart;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.model.application.MToolBarItem;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtiltities;
import org.eclipse.e4.workbench.ui.IHandlerService;
import org.eclipse.e4.workbench.ui.ILegacyHook;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.e4.workbench.ui.renderers.PartFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SWTPartFactory
extends PartFactory {
    public void createMenu(MPart<?> mPart, Object object, MMenu mMenu) {
        Menu menu;
        Widget widget = (Widget)object;
        if (mMenu != null && mMenu.getId() != null && mMenu.getId().equals("org.eclipse.ui.main.menu") && mMenu.getItems().size() == 0) {
            ILegacyHook iLegacyHook = (ILegacyHook)this.context.get(ILegacyHook.class.getName());
            iLegacyHook.loadMenu(mMenu);
        }
        if (widget instanceof MenuItem) {
            menu = new Menu((Decorations)((MenuItem)widget).getParent().getShell(), 4);
            ((MenuItem)widget).setMenu(menu);
        } else if (widget instanceof Decorations) {
            menu = new Menu((Decorations)widget, 2);
            ((Decorations)widget).setMenuBar(menu);
        } else if (widget instanceof Control) {
            menu = new Menu((Control)widget);
            ((Control)widget).setMenu(menu);
        } else {
            throw new IllegalArgumentException("The widget must be MenuItem, Decorations, or Control but is: " + object);
        }
        for (ILegacyHook iLegacyHook : mMenu.getItems()) {
            this.createMenuItem(mPart, menu, (MHandledItem)iLegacyHook);
        }
    }

    public void createToolBar(MPart<?> mPart, Object object, MToolBar mToolBar) {
        Composite composite;
        if (mToolBar != null && mToolBar.getId() != null && mToolBar.getId().equals("org.eclipse.ui.main.toolbar") && mToolBar.getItems().size() == 0) {
            composite = (ILegacyHook)this.context.get(ILegacyHook.class.getName());
            composite.loadToolbar(mToolBar);
        }
        composite = (Composite)object;
        ToolBar toolBar = new ToolBar(composite, 0x880000);
        for (MToolBarItem mToolBarItem : mToolBar.getItems()) {
            this.createToolBarItem(mPart, toolBar, mToolBarItem);
        }
    }

    private MHandler getHandler(Display display, MHandledItem mHandledItem) {
        IHandlerService iHandlerService;
        MHandler mHandler = null;
        MCommand mCommand = mHandledItem.getCommand();
        if (mCommand == null) {
            return mHandler;
        }
        Control control = display.getFocusControl();
        MPart mPart = null;
        while (control != null && mPart == null) {
            mPart = (MPart)control.getData("modelElement");
            control = control.getParent();
        }
        if (mPart == null) {
            return null;
        }
        IEclipseContext iEclipseContext = this.getContext(mPart);
        if (iEclipseContext != null && (iHandlerService = (IHandlerService)iEclipseContext.get(IHandlerService.class.getName())) != null) {
            mHandler = iHandlerService.getHandler(mCommand);
        }
        return mHandler;
    }

    private void createToolBarItem(MPart<?> mPart, ToolBar toolBar, final MToolBarItem mToolBarItem) {
        int n = 8;
        final ToolItem toolItem = new ToolItem(toolBar, n);
        if (mToolBarItem.getName() != null) {
            toolItem.setText(mToolBarItem.getName());
        }
        toolItem.setToolTipText(mToolBarItem.getTooltip());
        toolItem.setImage(this.getImage((MApplicationElement)mToolBarItem));
        mToolBarItem.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (ApplicationPackage.Literals.MITEM__NAME.equals(notification.getFeature())) {
                    final MHandledItem mHandledItem = (MHandledItem)notification.getNotifier();
                    toolItem.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!toolItem.isDisposed()) {
                                toolItem.setText(mHandledItem.getName());
                                toolItem.getParent().pack();
                            }
                        }
                    });
                } else if (ApplicationPackage.Literals.MITEM__ICON_URI.equals(notification.getFeature())) {
                    final MHandledItem mHandledItem = (MHandledItem)notification.getNotifier();
                    toolItem.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!toolItem.isDisposed()) {
                                toolItem.setImage(SWTPartFactory.this.getImage((MApplicationElement)mHandledItem));
                                toolItem.getParent().pack();
                            }
                        }
                    });
                }
            }
        });
        if (mToolBarItem.getCommand() != null) {
            final IEclipseContext iEclipseContext = this.getContext(mPart);
            toolItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Object object = SWTPartFactory.this.canExecuteItem(iEclipseContext, toolItem.getDisplay(), (MHandledItem)mToolBarItem);
                    if (Boolean.TRUE.equals(object)) {
                        SWTPartFactory.this.executeItem(iEclipseContext, toolItem.getDisplay(), (MHandledItem)mToolBarItem);
                    }
                }
            });
            toolItem.getDisplay().timerExec(250, new Runnable(){

                public void run() {
                    if (toolItem.isDisposed()) {
                        return;
                    }
                    Object object = SWTPartFactory.this.canExecuteItem(iEclipseContext, toolItem.getDisplay(), (MHandledItem)mToolBarItem);
                    toolItem.setEnabled(Boolean.TRUE.equals(object));
                    toolItem.getDisplay().timerExec(100, (Runnable)this);
                }
            });
        }
    }

    protected Object canExecuteItem(IEclipseContext iEclipseContext, Display display, MHandledItem mHandledItem) {
        MHandler mHandler = this.getHandler(display, mHandledItem);
        if (mHandler == null) {
            return Boolean.TRUE;
        }
        Object object = this.contributionFactory.call(mHandler.getObject(), mHandler.getURI(), "canExecute", iEclipseContext, (Object)Boolean.TRUE);
        return object;
    }

    protected void executeItem(IEclipseContext iEclipseContext, Display display, MHandledItem mHandledItem) {
        MHandler mHandler = this.getHandler(display, mHandledItem);
        if (mHandler == null) {
            return;
        }
        this.contributionFactory.call(mHandler.getObject(), mHandler.getURI(), "execute", iEclipseContext, null);
    }

    private void createMenuItem(MPart<?> mPart, Menu menu, final MHandledItem mHandledItem) {
        int n = 8;
        if (mHandledItem instanceof MMenuItem) {
            if (((MMenuItem)mHandledItem).isSeparator()) {
                n = 2;
            } else if (((MMenuItem)mHandledItem).getMenu() != null) {
                n = 64;
            }
        }
        final MenuItem menuItem = new MenuItem(menu, n);
        if (n != 2) {
            menuItem.setText(mHandledItem.getName());
            menuItem.setImage(this.getImage((MApplicationElement)mHandledItem));
            menuItem.setEnabled(true);
            mHandledItem.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (ApplicationPackage.Literals.MITEM__NAME.equals(notification.getFeature())) {
                        final MHandledItem mHandledItem = (MHandledItem)notification.getNotifier();
                        menuItem.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (!menuItem.isDisposed()) {
                                    menuItem.setText(mHandledItem.getName());
                                }
                            }
                        });
                    } else if (ApplicationPackage.Literals.MITEM__ICON_URI.equals(notification.getFeature())) {
                        final MHandledItem mHandledItem = (MHandledItem)notification.getNotifier();
                        menuItem.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (!menuItem.isDisposed()) {
                                    menuItem.setImage(SWTPartFactory.this.getImage((MApplicationElement)mHandledItem));
                                }
                            }
                        });
                    }
                }
            });
        }
        if (mHandledItem.getMenu() != null) {
            this.createMenu(mPart, menuItem, mHandledItem.getMenu());
        }
        final IEclipseContext iEclipseContext = this.getContext(mPart);
        if (mHandledItem.getCommand() != null) {
            menuItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Object object = SWTPartFactory.this.canExecuteItem(iEclipseContext, menuItem.getDisplay(), mHandledItem);
                    if (Boolean.TRUE.equals(object)) {
                        SWTPartFactory.this.executeItem(iEclipseContext, menuItem.getDisplay(), mHandledItem);
                    }
                }
            });
            menu.addListener(22, new Listener(){

                public void handleEvent(Event event) {
                    if (menuItem.isDisposed()) {
                        return;
                    }
                    Object object = SWTPartFactory.this.canExecuteItem(iEclipseContext, menuItem.getDisplay(), mHandledItem);
                    menuItem.setEnabled(Boolean.TRUE.equals(object));
                }
            });
        }
    }

    public <P extends MPart<?>> void processContents(MPart<P> mPart) {
        Widget widget = (Widget)mPart.getWidget();
        if (widget == null) {
            return;
        }
        EList eList = mPart.getChildren();
        if (eList != null) {
            for (MPart mPart2 : eList) {
                this.renderer.createGui(mPart2);
            }
        }
    }

    public void bindWidget(MPart<?> mPart, Object object) {
        mPart.setWidget(object);
        ((Widget)object).setData("modelElement", mPart);
    }

    protected Widget getParentWidget(MPart<?> mPart) {
        return mPart.getParent() instanceof MPart ? (Widget)mPart.getParent().getWidget() : null;
    }

    public void disposeWidget(MPart<?> mPart) {
        Widget widget = (Widget)mPart.getWidget();
        mPart.setWidget(null);
        if (widget != null) {
            widget.dispose();
        }
    }

    public void hookControllerLogic(final MPart<?> mPart) {
        Widget widget = (Widget)mPart.getWidget();
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                MPart mPart = (MPart)disposeEvent.widget.getData("modelElement");
                mPart.setWidget(null);
            }
        });
        if (widget instanceof Control && mPart instanceof MItemPart) {
            ((Control)widget).getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent accessibleEvent) {
                    accessibleEvent.result = ((MItemPart)mPart).getName();
                }
            });
        }
    }

    public void childAdded(MPart<?> mPart, MPart<?> mPart2) {
        if (mPart.getWidget() instanceof Composite && mPart2.getWidget() instanceof Control) {
            Composite composite = (Composite)mPart.getWidget();
            Control control = (Control)mPart2.getWidget();
            control.setParent(composite);
        }
    }

    protected Image getImage(MApplicationElement mApplicationElement) {
        if (mApplicationElement instanceof MItem) {
            ISWTResourceUtiltities iSWTResourceUtiltities;
            ImageDescriptor imageDescriptor;
            String string;
            IEclipseContext iEclipseContext = this.context;
            if (mApplicationElement instanceof MPart) {
                iEclipseContext = this.getContext((MPart)mApplicationElement);
            }
            if ((string = ((MItem)mApplicationElement).getIconURI()) != null && !string.equals("null") && (imageDescriptor = (ImageDescriptor)(iSWTResourceUtiltities = (ISWTResourceUtiltities)iEclipseContext.get(IResourceUtiltities.class.getName())).imageDescriptorFromURI(URI.createURI((String)string))) != null) {
                return imageDescriptor.createImage();
            }
        }
        return null;
    }
}

