/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.xwt.vex.VEXCodeSynchronizer;
import org.eclipse.e4.xwt.vex.VEXEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCodeSynchronizer
implements VEXCodeSynchronizer {
    private final Map<Node, String> node2name = new HashMap<Node, String>();
    private String oldAttrValue;
    private VEXEditor editor;
    private String cacheContent = "";

    public AbstractCodeSynchronizer(VEXEditor vEXEditor) {
        this.editor = vEXEditor;
    }

    public String getOldAttrValue() {
        return this.oldAttrValue;
    }

    public void setOldAttrValue(String string) {
        this.oldAttrValue = string;
    }

    public String getCacheContent() {
        return this.cacheContent;
    }

    public void setCacheContent(String string) {
        this.cacheContent = string;
    }

    public Map<Node, String> getNode2name() {
        return this.node2name;
    }

    public VEXEditor getEditor() {
        return this.editor;
    }

    @Override
    public void add(final IDOMNode iDOMNode, final String string) {
        if (iDOMNode != null && string != null && !string.equals("")) {
            String string2 = this.node2name.get(iDOMNode);
            if (string2 != null) {
                if (string2.equals(string)) {
                    return;
                }
                this.remove(iDOMNode);
                this.add(iDOMNode, string);
            }
            this.node2name.put((Node)iDOMNode, string);
            Display display = Display.getDefault();
            if (display != null) {
                display.syncExec(new Runnable(){

                    public void run() {
                        String string2 = AbstractCodeSynchronizer.this.getFullTypeName(iDOMNode);
                        if (string2 == null) {
                            return;
                        }
                        AbstractCodeSynchronizer.this.generateFields(string2, string);
                        AbstractCodeSynchronizer.this.buildInitialization();
                    }
                });
            }
        }
    }

    protected abstract String getFullTypeName(IDOMNode var1);

    protected void updateCodeManager() {
        StructuredTextViewer structuredTextViewer = this.editor.getTextEditor().getTextViewer();
        int n = structuredTextViewer.getTextWidget().getCaretOffset();
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)n);
        Node node = (Node)indexedRegion;
        while (node != null && node.getParentNode() != null && !(node.getParentNode() instanceof Document)) {
            node = node.getParentNode();
        }
        this.update((IDOMNode)node);
    }

    @Override
    public void update(IDOMNode iDOMNode) {
        if (iDOMNode.getNodeType() == 3) {
            return;
        }
        if (!this.editor.getContext().hasType((Node)iDOMNode)) {
            return;
        }
        boolean bl = false;
        NamedNodeMap namedNodeMap = iDOMNode.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = namedNodeMap.item(n2);
            String string = node.getNodeName();
            if ("Name".equals(string)) {
                bl = true;
                if (this.oldAttrValue != null) {
                    this.remove(iDOMNode);
                }
                this.add(iDOMNode, node.getNodeValue());
            }
            ++n2;
        }
        if (!bl) {
            this.remove(iDOMNode);
        }
        NodeList nodeList = iDOMNode.getChildNodes();
        int n3 = nodeList.getLength();
        int n4 = 0;
        while (n4 < n3) {
            Node node = nodeList.item(n4);
            this.update((IDOMNode)node);
            ++n4;
        }
    }

    @Override
    public boolean codeAboutToBeChanged() {
        StructuredTextViewer structuredTextViewer = this.editor.getTextEditor().getTextViewer();
        int n = structuredTextViewer.getTextWidget().getCaretOffset();
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)n);
        Node node = (Node)indexedRegion;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode iDOMNode = (IDOMNode)node;
        if (iDOMNode != null && this.editor.getContext().hasType((Node)iDOMNode)) {
            NamedNodeMap namedNodeMap = iDOMNode.getAttributes();
            int n2 = namedNodeMap.getLength() - 1;
            while (n2 >= 0) {
                IDOMAttr iDOMAttr = (IDOMAttr)namedNodeMap.item(n2);
                String string = iDOMAttr.getName();
                String string2 = iDOMAttr.getValue();
                int n3 = iDOMAttr.getStartOffset();
                int n4 = n3 + string.length() + string2.length() + 3;
                if (n >= n3 && n < n4) {
                    this.oldAttrValue = string2;
                    return true;
                }
                --n2;
            }
        }
        this.oldAttrValue = null;
        return false;
    }

    protected String updateCacheContent(IDocument iDocument) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = iDocument.get();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected boolean checkContent(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        if (string2.equals(this.cacheContent)) {
            return true;
        }
        this.cacheContent = string2;
        return false;
    }

    protected String resolveHostClass(Node node) {
        return null;
    }

    protected IProgressMonitor getProgressMonitor() {
        ProgressManager progressManager = (ProgressManager)this.editor.getTextEditor().getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        IProgressMonitor iProgressMonitor = progressManager.getDefaultMonitor();
        return iProgressMonitor;
    }

    protected IProject getProject() {
        IResource iResource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        if (iResource != null) {
            return iResource.getProject();
        }
        return null;
    }
}

