/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex;

import org.eclipse.e4.xwt.vex.EditorMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.w3c.dom.Node;

public abstract class AbstractEventHandlerDialog {
    protected Operation operation = Operation.Cancel;
    protected String inputHandler = "";
    protected String oldHandler;
    protected String attrValue;
    protected String[] handlers;
    protected StructuredTextViewer textViewer;
    protected int count;

    public AbstractEventHandlerDialog(StructuredTextViewer structuredTextViewer, String string, String string2, String[] stringArray) {
        this.textViewer = structuredTextViewer;
        this.oldHandler = string;
        this.attrValue = string2;
        this.handlers = stringArray;
    }

    public void run(Shell shell, String string, Point point) {
        Shell shell2 = new Shell(shell, 0);
        shell2.setText(string);
        this.createContents(shell2);
        shell2.setLocation(point);
        shell2.pack();
        shell2.open();
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group((Composite)shell, 16384);
        group.setText(EditorMessages.EventHandleDialog_Operation);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        final Button button = new Button((Composite)group, 16);
        button.setText(EditorMessages.EventHandleDialog_New_Handler);
        button.setSelection(true);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        button.setLayoutData((Object)gridData2);
        RBSelectionAdapter rBSelectionAdapter = new RBSelectionAdapter(1);
        button.addSelectionListener((SelectionListener)rBSelectionAdapter);
        button.setToolTipText(EditorMessages.EventHandleDialog_New_Handler_ToolTip);
        button.setForeground(button.getDisplay().getSystemColor(10));
        final Button button2 = new Button((Composite)group, 16);
        button2.setText(EditorMessages.EventHandleDialog_Rename_Handler);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 2;
        button2.setLayoutData((Object)gridData3);
        RBSelectionAdapter rBSelectionAdapter2 = new RBSelectionAdapter(2);
        button2.addSelectionListener((SelectionListener)rBSelectionAdapter2);
        button2.setToolTipText(EditorMessages.EventHandleDialog_Rename_Handler_ToolTip);
        button2.setForeground(button2.getDisplay().getSystemColor(10));
        button2.setEnabled(this.oldHandler != null && this.oldHandler.length() > 0);
        final Button button3 = new Button((Composite)group, 16);
        button3.setText(EditorMessages.EventHandleDialog_Select_Existing_Handler);
        GridData gridData4 = new GridData(768);
        gridData4.horizontalSpan = 2;
        button3.setLayoutData((Object)gridData4);
        RBSelectionAdapter rBSelectionAdapter3 = new RBSelectionAdapter(3);
        button3.addSelectionListener((SelectionListener)rBSelectionAdapter3);
        button3.setToolTipText(EditorMessages.EventHandleDialog_Select_Existing_Handler_ToolTip);
        button3.setForeground(button3.getDisplay().getSystemColor(10));
        button3.setEnabled(this.handlers != null && this.handlers.length > 0);
        Label label = new Label((Composite)shell, 16384);
        label.setText(EditorMessages.EventHandleDialog_Input_Handler_Name);
        final Text text = new Text((Composite)shell, 2048);
        text.setText(this.attrValue);
        GridData gridData5 = new GridData();
        gridData5.widthHint = 100;
        text.setLayoutData((Object)gridData5);
        rBSelectionAdapter.setText(text);
        rBSelectionAdapter2.setText(text);
        rBSelectionAdapter3.setText(text);
        Label label2 = new Label((Composite)shell, 16384);
        label2.setText(EditorMessages.EventHandleDialog_Select_Handler);
        GridData gridData6 = new GridData(768);
        label2.setLayoutData((Object)gridData6);
        final Combo combo = new Combo((Composite)shell, 12);
        if (this.handlers != null && this.handlers.length != 0) {
            combo.setItems(this.handlers);
            combo.setText(this.handlers[0]);
        }
        combo.setEnabled(false);
        GridData gridData7 = new GridData(768);
        gridData7.horizontalAlignment = 16384;
        combo.setLayoutData((Object)gridData7);
        rBSelectionAdapter.setCombo(combo);
        rBSelectionAdapter2.setCombo(combo);
        rBSelectionAdapter3.setCombo(combo);
        Button button4 = new Button((Composite)shell, 13);
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = false;
                if (!button3.getSelection()) {
                    if (text.getText().trim().equals("")) {
                        MessageDialog.openInformation((Shell)shell, (String)"Dialog", (String)EditorMessages.EventHandleDialog_Error_Handler_Name_Null);
                        text.forceFocus();
                        return;
                    }
                    bl = this.handlerExists(text.getText(), AbstractEventHandlerDialog.this.handlers);
                    if (bl) {
                        int n = text.getText().length();
                        text.setSelection(0, n);
                        text.forceFocus();
                        return;
                    }
                }
                if (button.getSelection()) {
                    AbstractEventHandlerDialog.this.operation = Operation.New;
                    AbstractEventHandlerDialog.this.inputHandler = text.getText();
                } else if (button2.getSelection()) {
                    String string;
                    boolean bl2;
                    AbstractEventHandlerDialog.this.inputHandler = text.getText();
                    Node node = (Node)ContentAssistUtils.getNodeAt((ITextViewer)AbstractEventHandlerDialog.this.textViewer, (int)0);
                    AbstractEventHandlerDialog.this.count = 0;
                    boolean bl3 = AbstractEventHandlerDialog.this.usedByOther(node, AbstractEventHandlerDialog.this.oldHandler);
                    if (bl3 && !(bl2 = MessageDialog.openConfirm((Shell)shell, (String)"Dialog", (String)(string = NLS.bind((String)EditorMessages.EventHandleDialog_Question_Handler_Name_Refactoring, (Object)AbstractEventHandlerDialog.this.oldHandler))))) {
                        int n = text.getText().length();
                        text.setSelection(0, n);
                        text.forceFocus();
                        return;
                    }
                    AbstractEventHandlerDialog.this.operation = Operation.Rename;
                } else if (button3.getSelection()) {
                    AbstractEventHandlerDialog.this.operation = Operation.Select;
                    AbstractEventHandlerDialog.this.inputHandler = combo.getText();
                }
                if (!bl) {
                    shell.dispose();
                }
            }

            private boolean handlerExists(String string, String[] stringArray) {
                int n = 0;
                while (n < stringArray.length) {
                    if (string != null && string.equals(stringArray[n])) {
                        MessageDialog.openInformation((Shell)shell, (String)"Dialog", (String)EditorMessages.EventHandleDialog_Error_Handler_Name_Exists);
                        return true;
                    }
                    ++n;
                }
                return false;
            }
        });
        button4.setText("OK");
        GridData gridData8 = new GridData();
        gridData8.horizontalAlignment = 2;
        button4.setLayoutData((Object)gridData8);
        Button button5 = new Button((Composite)shell, 8);
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.dispose();
            }
        });
        button5.setText("Cancel");
        GridData gridData9 = new GridData();
        gridData9.horizontalAlignment = 2;
        gridData9.grabExcessHorizontalSpace = true;
        shell.setDefaultButton(button4);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getInputHandler() {
        return this.inputHandler;
    }

    protected abstract boolean usedByOther(Node var1, String var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        Cancel,
        New,
        Select,
        Rename;

    }

    private class RBSelectionAdapter
    extends SelectionAdapter {
        private Text text;
        private Combo combo;
        private int number;

        protected RBSelectionAdapter(int n) {
            this.number = n;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (this.number == 3) {
                this.text.setEnabled(false);
                this.combo.setEnabled(true);
            } else {
                this.text.setEnabled(true);
                this.combo.setEnabled(false);
            }
        }

        protected void setText(Text text) {
            this.text = text;
        }

        protected void setCombo(Combo combo) {
            this.combo = combo;
        }
    }
}

