/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.xwt.vex.EditorMessages;
import org.eclipse.e4.xwt.vex.ResourceManager;
import org.eclipse.e4.xwt.vex.VEXCodeSynchronizer;
import org.eclipse.e4.xwt.vex.VEXContext;
import org.eclipse.e4.xwt.vex.VEXFileChecker;
import org.eclipse.e4.xwt.vex.VEXRenderRegistry;
import org.eclipse.e4.xwt.vex.VEXRenderer;
import org.eclipse.e4.xwt.vex.VEXTextEditorHelper;
import org.eclipse.e4.xwt.vex.palette.CustomPalettePage;
import org.eclipse.e4.xwt.vex.palette.PaletteResourceManager;
import org.eclipse.e4.xwt.vex.palette.PaletteViewManager;
import org.eclipse.e4.xwt.vex.palette.part.DynamicPaletteViewer;
import org.eclipse.e4.xwt.vex.swt.AnimatedImage;
import org.eclipse.e4.xwt.vex.swt.CustomSashForm;
import org.eclipse.e4.xwt.vex.toolpalette.Entry;
import org.eclipse.e4.xwt.vex.toolpalette.ToolPalette;
import org.eclipse.e4.xwt.vex.toolpalette.ToolPaletteFactory;
import org.eclipse.e4.xwt.vex.util.ImageHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VEXEditor
extends XMLMultiPageEditorPart {
    static boolean toolViewShown = false;
    protected VEXContext context;
    private VEXCodeSynchronizer codeSynchronizer;
    private VEXFileChecker fileChecker;
    protected VEXRenderer render;
    protected Canvas container;
    protected ScrolledComposite scrolledComposite;
    protected SashForm sashForm;
    protected AnimatedImage loadingMessage;
    private StructuredTextEditor fTextEditor;
    private Refresher refresher = new Refresher();
    private PaletteResourceManager tResourceManager;
    private static PalettePage palettePage;
    protected PropertyChangeListener changeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            VEXEditor.this.invokeInputChanged();
        }
    };
    private KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent keyEvent) {
            super.keyPressed(keyEvent);
            VEXEditor.this.handleKeyEvent(keyEvent);
        }
    };
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseDown(MouseEvent mouseEvent) {
            super.mouseDown(mouseEvent);
            VEXEditor.this.handleMouseEvent(mouseEvent);
        }
    };
    protected DragSourceListener dragSourceAdapter = new DragSourceListener(){
        private String dragDataText;

        public void dragFinished(DragSourceEvent dragSourceEvent) {
            this.dragDataText = null;
        }

        public void dragSetData(DragSourceEvent dragSourceEvent) {
            if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
                dragSourceEvent.data = this.dragDataText;
            }
        }

        public void dragStart(DragSourceEvent dragSourceEvent) {
            this.dragDataText = VEXEditor.this.getTextWidget().getSelectionText();
        }
    };

    public void handleMouseEvent(MouseEvent mouseEvent) {
        this.doDynamicPalette(new Point(mouseEvent.x, mouseEvent.y));
    }

    public void handleKeyEvent(KeyEvent keyEvent) {
        StyledText styledText = (StyledText)keyEvent.widget;
        Caret caret = styledText.getCaret();
        if (caret != null) {
            this.doDynamicPalette(caret.getLocation());
        }
    }

    public void doDynamicPalette(Point point) {
        IDOMNode iDOMNode = this.getDOMNode(point);
        if (iDOMNode != null) {
            List<Entry> list;
            Object object4;
            Entry entry3;
            Node node = iDOMNode.getParentNode();
            this.tResourceManager = this.getPaletteResourceManager();
            Resource resource = this.tResourceManager.getDynamicResource();
            Resource resource2 = this.tResourceManager.getResource();
            ToolPalette toolPalette = (ToolPalette)resource2.getContents().get(0);
            EList<Entry> eList = toolPalette.getEntries();
            Entry entry2 = null;
            for (Entry entry3 : eList) {
                if (!entry3.getName().equals(EditorMessages.VEXEditor_Dynamic)) continue;
                entry2 = entry3;
                break;
            }
            if (entry2 != null) {
                eList.remove(entry2);
            }
            entry2 = ToolPaletteFactory.eINSTANCE.createEntry();
            entry2.setName(EditorMessages.VEXEditor_Dynamic);
            entry2.setToolTip(EditorMessages.VEXEditor_DynamicCategory);
            eList.add((Object)entry2);
            entry3 = ((CustomPalettePage)palettePage).getPaletteViewer();
            Object object2 = null;
            Object object3 = entry3.getProperty("Dynamic_PaletteViewer");
            if (object3 instanceof DynamicPaletteViewer) {
                object2 = (DynamicPaletteViewer)((Object)object3);
            }
            if (object2 == null) {
                return;
            }
            PaletteRoot paletteRoot = object2.getPaletteRoot();
            List list2 = paletteRoot.getChildren();
            PaletteGroup paletteGroup = null;
            for (Object object4 : list2) {
                if (!((PaletteGroup)object4).getLabel().equals(EditorMessages.VEXEditor_Dynamic)) continue;
                paletteGroup = (PaletteGroup)object4;
                break;
            }
            if (paletteGroup == null) {
                paletteGroup = new PaletteGroup(EditorMessages.VEXEditor_Dynamic);
            }
            object4 = paletteGroup.getChildren();
            int n = object4.size();
            int n2 = 0;
            while (n2 < n) {
                paletteGroup.remove((PaletteEntry)object4.get(0));
                ++n2;
            }
            paletteRoot.remove((PaletteEntry)paletteGroup);
            if (node.getLocalName() != null && !node.getLocalName().equals("") && (list = this.getSubEntries(node, (List<Entry>)eList)) != null) {
                for (Entry entry4 : list) {
                    if (entry4.getScope() == null || !entry4.getScope().equals(node.getLocalName())) continue;
                    Entry entry5 = (Entry)EcoreUtil.copy((EObject)entry4);
                    entry2.getEntries().add((Object)entry5);
                    CombinedTemplateCreationEntry combinedTemplateCreationEntry = new CombinedTemplateCreationEntry(entry5.getName(), entry5.getToolTip(), (Object)entry5, (CreationFactory)new SimpleFactory(resource.getClass()), ImageHelper.getImageDescriptor(this.tResourceManager, entry5.getIcon()), ImageHelper.getImageDescriptor(this.tResourceManager, entry5.getLargeIcon()));
                    paletteGroup.add((PaletteEntry)combinedTemplateCreationEntry);
                }
            }
            paletteRoot.add((PaletteEntry)paletteGroup);
            RootEditPart rootEditPart = object2.getRootEditPart();
            this.refreshAllEditParts((EditPart)rootEditPart);
            System.out.println();
        }
    }

    private void refreshAllEditParts(EditPart editPart) {
        editPart.refresh();
        List list = editPart.getChildren();
        for (EditPart editPart2 : list) {
            this.refreshAllEditParts(editPart2);
        }
    }

    private IDOMNode getDOMNode(Point point) {
        int[] nArray;
        Method method;
        StructuredTextViewer structuredTextViewer = this.fTextEditor.getTextViewer();
        StyledText styledText = structuredTextViewer.getTextWidget();
        Point point2 = new Point(point.x, point.y);
        int n = 0;
        try {
            method = StyledText.class.getDeclaredMethod("getOffsetAtPoint", Integer.TYPE, Integer.TYPE, int[].class, Boolean.TYPE);
            method.setAccessible(true);
            nArray = new int[1];
            n = (Integer)method.invoke((Object)styledText, point2.x, point2.y, nArray, false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        method = VEXTextEditorHelper.getNode((ITextViewer)structuredTextViewer, n += nArray[0]);
        return method;
    }

    private List<Entry> getSubEntries(Node node, List<Entry> list) {
        Object object = null;
        for (Entry entry : list) {
            if (entry.getName().equals(node.getLocalName())) {
                object = entry.getEntries();
            }
            if (object != null) continue;
            object = this.getSubEntries(node, (List<Entry>)entry.getEntries());
        }
        return object;
    }

    public VEXEditor(VEXContext vEXContext) {
        this.context = vEXContext;
    }

    public IProject getProject() {
        IResource iResource = (IResource)this.getEditorInput().getAdapter(IResource.class);
        if (iResource != null) {
            return iResource.getProject();
        }
        throw new IllegalStateException();
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        IWorkbenchPage iWorkbenchPage = this.getSite().getWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null && !toolViewShown) {
            iWorkbenchPage.showView(this.context.getToolViewID());
            toolViewShown = true;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fileChecker != null) {
            this.fileChecker.deleteMarkers();
        }
        if (this.render != null) {
            this.render.dispose();
        }
    }

    protected Composite createPageContainer(Composite composite) {
        this.sashForm = new CustomSashForm(composite, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.sashForm.setBackgroundMode(1);
        this.scrolledComposite = new ScrolledComposite((Composite)this.sashForm, 2816);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackgroundMode(1);
        this.scrolledComposite.setBackground(this.scrolledComposite.getDisplay().getSystemColor(1));
        this.container = new Canvas((Composite)this.scrolledComposite, 768);
        this.container.setBackground(this.container.getDisplay().getSystemColor(1));
        this.container.setBackgroundMode(1);
        this.container.setLayout((Layout)new GridLayout());
        this.loadingMessage = new AnimatedImage((Composite)this.container, 0x1000000);
        this.loadingMessage.setLayoutData(new GridData(1808));
        this.loadingMessage.setHorizontalAlignment(0x1000000);
        this.loadingMessage.setVerticalAlignment(0x1000000);
        this.loadingMessage.setBackgroundMode(1);
        this.loadingMessage.setBackground(this.container.getDisplay().getSystemColor(1));
        this.scrolledComposite.setContent((Control)this.container);
        try {
            this.loadingMessage.setImageFile(ResourceManager.getImageURL(ResourceManager.URL_PATH_BUSY));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Composite composite2 = super.createPageContainer((Composite)this.sashForm);
        this.render = VEXRenderRegistry.getRender((Composite)this.container);
        if (this.render == null) {
            this.render = this.createRender(this.container);
        }
        return composite2;
    }

    protected VEXRenderer createRender(Canvas canvas) {
        return null;
    }

    protected abstract VEXFileChecker createFileChecker();

    public VEXFileChecker getFileChecker() {
        if (this.fileChecker == null) {
            this.fileChecker = this.createFileChecker();
        }
        return this.fileChecker;
    }

    protected void codeAboutToBeChanged() {
        VEXCodeSynchronizer vEXCodeSynchronizer = this.getCodeSynchronizer();
        if (vEXCodeSynchronizer != null) {
            vEXCodeSynchronizer.codeAboutToBeChanged();
        }
    }

    protected void invokeInputChanged() {
        long l = this.refresher.getTime();
        if (this.fTextEditor.getTextViewer() != null) {
            this.refresher.setDocument(this.fTextEditor.getTextViewer().getDocument());
            if (l == -1L) {
                Display.getDefault().timerExec(1000, (Runnable)this.refresher);
            }
        }
    }

    public int addPage(IEditorPart iEditorPart, IEditorInput iEditorInput) throws PartInitException {
        if (iEditorPart instanceof StructuredTextEditor) {
            this.fTextEditor = (StructuredTextEditor)iEditorPart;
        }
        this.sashForm.setWeights(new int[]{60, 40});
        return super.addPage(iEditorPart, iEditorInput);
    }

    protected void createPages() {
        super.createPages();
        if (this.fTextEditor != null) {
            StructuredTextViewer structuredTextViewer = this.fTextEditor.getTextViewer();
            structuredTextViewer.getTextWidget().addMouseListener((MouseListener)this.mouseAdapter);
            structuredTextViewer.getTextWidget().addKeyListener((KeyListener)this.keyAdapter);
            IDocument iDocument = structuredTextViewer.getDocument();
            iDocument.addDocumentListener((IDocumentListener)new DocumentListener());
            this.invokeInputChanged();
            this.initializeDND(this);
            Composite composite = this.getContainer();
            if (composite instanceof CTabFolder) {
                CTabFolder cTabFolder = (CTabFolder)composite;
                this.createToolBar(cTabFolder);
            }
            int n = 0;
            while (n < this.getPageCount()) {
                if (this.getPageText(n).equals("")) {
                    this.setPageImage(n, ResourceManager.getImage("org.eclipse.e4.xwt.vex.obj16.Element.png"));
                }
                if (this.getPageText(n).equals("")) {
                    this.setPageImage(n, ResourceManager.getImage("org.eclipse.e4.xwt.vex.obj16.Table.gif"));
                }
                ++n;
            }
        }
    }

    public void initializeDND(VEXEditor vEXEditor) {
        DragSource dragSource;
        StyledText styledText = this.getTextWidget();
        if (styledText != null && (dragSource = (DragSource)styledText.getData("DragSource")) != null) {
            dragSource.removeDragListener(this.dragSourceAdapter);
        }
        if ((dragSource = (DragSource)styledText.getData("DragSource")) == null) {
            dragSource = new DragSource((Control)styledText, 3);
            Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance()};
            dragSource.setTransfer(transferArray);
        }
        dragSource.addDragListener(this.dragSourceAdapter);
    }

    public Object getAdapter(Class clazz) {
        if (clazz == PalettePage.class) {
            return this.getPalettePage();
        }
        if (clazz == PaletteResourceManager.class) {
            return this.getPaletteResourceManager();
        }
        return super.getAdapter(clazz);
    }

    public PaletteResourceManager getPaletteResourceManager() {
        if (this.tResourceManager == null) {
            this.tResourceManager = new PaletteResourceManager(this);
        }
        return this.tResourceManager;
    }

    private PalettePage getPalettePage() {
        if (palettePage == null) {
            PaletteViewManager paletteViewManager = new PaletteViewManager((IEditorPart)this);
            palettePage = new CustomPalettePage(paletteViewManager.getPaletteViewerProvider());
        }
        return palettePage;
    }

    public PalettePage getVEXEditorPalettePage() {
        return palettePage;
    }

    protected abstract void createToolBar(CTabFolder var1);

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            this.updateCodeManager();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fTextEditor.doSave(iProgressMonitor);
    }

    protected boolean handleInputChanged(IDocument iDocument) {
        boolean bl;
        VEXCodeSynchronizer vEXCodeSynchronizer = this.getCodeSynchronizer();
        if (vEXCodeSynchronizer != null && !(bl = vEXCodeSynchronizer.handleInputChanged(iDocument))) {
            return false;
        }
        try {
            ApplicationWindow applicationWindow = (ApplicationWindow)this.getSite().getPage().getWorkbenchWindow();
            MenuManager menuManager = applicationWindow.getMenuBarManager();
            if (menuManager != null) {
                menuManager.updateAll(true);
            }
            String string = iDocument.get();
            IFile iFile = (IFile)this.getEditorInput().getAdapter(IFile.class);
            this.container.setCursor(this.container.getDisplay().getSystemCursor(1));
            while (!this.container.getDisplay().readAndDispatch()) {
            }
            if (this.render != null && this.render.updateView(string, iFile)) {
                if (this.loadingMessage != null && !this.loadingMessage.isDisposed()) {
                    this.loadingMessage.dispose();
                    this.loadingMessage = null;
                }
                return true;
            }
            try {
                if (this.loadingMessage != null && !this.loadingMessage.isDisposed()) {
                    this.loadingMessage.stop();
                    this.loadingMessage.setText("No window found or an error occurs.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            this.container.setCursor(null);
            if (this.render != null) {
                this.getFileChecker().doCheck(this.render.getHostClassName());
            }
        }
        return false;
    }

    protected VEXCodeSynchronizer getCodeSynchronizer() {
        if (this.codeSynchronizer == null) {
            this.codeSynchronizer = this.createCodeSynchronizer();
        }
        return this.codeSynchronizer;
    }

    protected abstract VEXCodeSynchronizer createCodeSynchronizer();

    public void generateCLRCodeAction() {
        this.getCodeSynchronizer().generateHandles();
    }

    public void openDefinitionAction() {
        this.getCodeSynchronizer().openDefinition();
    }

    protected void updateCodeManager() {
        StructuredTextViewer structuredTextViewer = this.fTextEditor.getTextViewer();
        int n = structuredTextViewer.getTextWidget().getCaretOffset();
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)n);
        Node node = (Node)indexedRegion;
        while (node != null && node.getParentNode() != null && !(node.getParentNode() instanceof Document)) {
            node = node.getParentNode();
        }
        this.updateCodeManager((IDOMNode)node);
    }

    protected void updateCodeManager(IDOMNode iDOMNode) {
        VEXCodeSynchronizer vEXCodeSynchronizer = this.getCodeSynchronizer();
        if (vEXCodeSynchronizer == null) {
            return;
        }
        vEXCodeSynchronizer.update(iDOMNode);
    }

    public StyledText getTextWidget() {
        if (this.fTextEditor == null || this.fTextEditor.getTextViewer() == null) {
            return null;
        }
        return this.fTextEditor.getTextViewer().getTextWidget();
    }

    private String updateCacheContent(IDocument iDocument) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = iDocument.get();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public StructuredTextEditor getTextEditor() {
        return this.fTextEditor;
    }

    private void modifyAllRelativeHandlerName(StructuredTextViewer structuredTextViewer, int n, String string, String string2) {
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)n);
        Node node = (Node)indexedRegion;
        this.modifyHandlerName(string, node, string2);
    }

    private void modifyHandlerName(String string, Node node, String string2) {
        Object object;
        int n;
        Object object2;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode iDOMNode = (IDOMNode)node;
        if (node.getNodeType() == 1 && this.context.hasType((Node)iDOMNode)) {
            object2 = node.getAttributes();
            n = object2.getLength() - 1;
            while (n >= 0) {
                IDOMAttr iDOMAttr = (IDOMAttr)object2.item(n);
                object = iDOMAttr.getName();
                String string3 = iDOMAttr.getValue();
                if (this.context.isEventHandle((Node)iDOMNode, (String)object) && string3.equals(string2)) {
                    iDOMAttr.setNodeValue(string);
                }
                --n;
            }
        }
        object2 = node.getChildNodes();
        n = object2.getLength();
        int n2 = 0;
        while (n2 < n) {
            object = object2.item(n2);
            if (object.getNodeType() == 1) {
                this.modifyHandlerName(string, (Node)object, string2);
            }
            ++n2;
        }
    }

    public VEXContext getContext() {
        return this.context;
    }

    public void defaultCreation(Entry entry) {
        System.out.println(entry.getId());
        System.out.println(entry.getName());
        System.out.println(entry.getScope());
        System.out.println(entry.getIcon());
        System.out.println(entry.getLargeIcon());
        System.out.println(entry.getToolTip());
        System.out.println(entry.getContent());
        StyledText styledText = this.fTextEditor.getTextViewer().getTextWidget();
        Caret caret = styledText.getCaret();
        if (caret != null) {
            IDOMNode iDOMNode;
            Point point = caret.getLocation();
            Point point2 = this.getAddEntryPosition(point, iDOMNode = this.getDOMNode(point));
            if (point2 != null) {
                this.insertEntry(point2, iDOMNode);
                this.updateStatusBarMessage("node " + entry.getName() + " has been insert");
            } else {
                this.updateStatusBarMessage("node " + entry.getName() + " can not be insert");
            }
        }
    }

    private Point getAddEntryPosition(Point point, IDOMNode iDOMNode) {
        return null;
    }

    private void insertEntry(Point point, IDOMNode iDOMNode) {
    }

    private void updateStatusBarMessage(String string) {
    }

    class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            VEXEditor.this.invokeInputChanged();
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            VEXEditor.this.codeAboutToBeChanged();
        }
    }

    class Refresher
    implements Runnable {
        private IDocument document;
        private long time = -1L;

        Refresher() {
        }

        public void run() {
            if (System.currentTimeMillis() - this.time < 800L || Display.getDefault().getActiveShell() == null) {
                Display.getDefault().timerExec(1000, (Runnable)this);
                return;
            }
            try {
                VEXEditor.this.handleInputChanged(this.document);
            }
            finally {
                this.document = null;
                this.time = -1L;
            }
        }

        public IDocument getDocument() {
            return this.document;
        }

        public void setDocument(IDocument iDocument) {
            this.document = iDocument;
            this.time = System.currentTimeMillis();
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long l) {
            this.time = l;
        }
    }
}

