/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex;

import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.xwt.vex.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VEXSharedImages {
    public static final String[] IMAGE_SUFFIX = new String[]{".png", ".gif"};
    public static final IPath ICONS_PATH = new Path("icons");
    private static ImageRegistry fgImageRegistry;

    public static Image get(String string) {
        Image image = VEXSharedImages.getImageRegistry().get(string);
        if (image == null) {
            image = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = VEXSharedImages.getImageRegistry().getDescriptor(string);
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    private static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            VEXSharedImages.loadImages();
        }
        return fgImageRegistry;
    }

    private static void loadImages() {
        Bundle bundle = Activator.getDefault().getBundle();
        String string = "platform:/plugin/" + bundle.getSymbolicName() + "/" + ICONS_PATH + "/";
        try {
            URL uRL = FileLocator.find((Bundle)bundle, (IPath)ICONS_PATH, null);
            URL uRL2 = FileLocator.toFileURL((URL)uRL);
            String string2 = uRL2.toString();
            File file = new File(new Path(uRL2.getPath()).toOSString());
            LinkedList<File> linkedList = new LinkedList<File>();
            VEXSharedImages.retreiveImages(file, linkedList);
            for (File file2 : linkedList) {
                URL uRL3 = file2.toURI().toURL();
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL3);
                String string3 = uRL3.toString();
                if (!string3.startsWith(string2)) continue;
                String string4 = string3.substring(string2.length());
                String string5 = String.valueOf(string) + string4;
                fgImageRegistry.put(string5, imageDescriptor);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void retreiveImages(File file, List<File> list) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                VEXSharedImages.retreiveImages(file2, list);
                ++n2;
            }
        } else {
            String string = file.getName();
            if (string.endsWith(IMAGE_SUFFIX[0]) || string.endsWith(IMAGE_SUFFIX[1])) {
                list.add(file);
            }
        }
    }

    public static void initialize() {
        VEXSharedImages.getImageRegistry();
    }
}

