/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex;

import java.lang.reflect.Method;
import org.eclipse.e4.xwt.vex.toolpalette.ContextType;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class VEXTextEditorHelper {
    public static int getOffsetAtPoint(ITextViewer iTextViewer, Point point) {
        StyledText styledText = iTextViewer.getTextWidget();
        Point point2 = styledText.toControl(point);
        try {
            Method method = StyledText.class.getDeclaredMethod("getOffsetAtPoint", Integer.TYPE, Integer.TYPE, int[].class, Boolean.TYPE);
            method.setAccessible(true);
            int[] nArray = new int[1];
            int n = (Integer)method.invoke((Object)styledText, point2.x, point2.y, nArray, false);
            return n += nArray[0];
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static IDOMNode getCurrentNode(ITextViewer iTextViewer, Point point) {
        return VEXTextEditorHelper.getNode(iTextViewer, VEXTextEditorHelper.getOffsetAtPoint(iTextViewer, point));
    }

    public static IDOMNode getNode(ITextViewer iTextViewer, int n) {
        return (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)iTextViewer, (int)n);
    }

    public static int findContextTypeOffset(ITextViewer iTextViewer, ContextType contextType) {
        int n = iTextViewer.getTextWidget().getCaretOffset();
        return VEXTextEditorHelper.findContextTypeOffset(iTextViewer, n, contextType);
    }

    public static int findContextTypeOffset(ITextViewer iTextViewer, int n, ContextType contextType) {
        IDOMNode iDOMNode = VEXTextEditorHelper.getNode(iTextViewer, n);
        ITextRegion iTextRegion = VEXTextEditorHelper.getCompletionRegion(n, (Node)iDOMNode);
        System.out.println(String.valueOf(iTextRegion.getStart()) + ", " + iTextRegion.getEnd() + ", " + iTextRegion.getLength());
        iTextRegion.getType();
        return n;
    }

    public static ContextType getCurrentContextType(ITextViewer iTextViewer) {
        int n = iTextViewer.getTextWidget().getCaretOffset();
        return VEXTextEditorHelper.getContextType(iTextViewer, n);
    }

    public static ContextType getContextType(ITextViewer iTextViewer, int n) {
        IDOMNode iDOMNode = VEXTextEditorHelper.getNode(iTextViewer, n);
        ITextRegion iTextRegion = VEXTextEditorHelper.getCompletionRegion(n, (Node)iDOMNode);
        System.out.println(String.valueOf(iTextRegion.getStart()) + ", " + iTextRegion.getEnd() + ", " + iTextRegion.getLength());
        iTextRegion.getType();
        ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)iTextViewer, (int)n);
        return ContextType.NONE;
    }

    public static ITextRegion getCompletionRegion(int n, Node node) {
        if (node == null) {
            return null;
        }
        ITextRegion iTextRegion = null;
        int n2 = n;
        IStructuredDocumentRegion iStructuredDocumentRegion = null;
        IDOMNode iDOMNode = (IDOMNode)node;
        if (iDOMNode.getNodeType() == 9) {
            if (iDOMNode.getStructuredDocument().getLength() == 0) {
                return null;
            }
            ITextRegion iTextRegion2 = iDOMNode.getStructuredDocument().getRegionAtCharacterOffset(n2).getRegionAtCharacterOffset(n2);
            while (iTextRegion2 == null) {
                iTextRegion2 = iDOMNode.getStructuredDocument().getRegionAtCharacterOffset(--n2).getRegionAtCharacterOffset(n2);
            }
            return iTextRegion2;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion2 = iDOMNode.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion iStructuredDocumentRegion3 = iDOMNode.getEndStructuredDocumentRegion();
        if (iStructuredDocumentRegion2 != null && iStructuredDocumentRegion2.getStartOffset() <= n2 && n2 < iStructuredDocumentRegion2.getStartOffset() + iStructuredDocumentRegion2.getLength()) {
            iStructuredDocumentRegion = iStructuredDocumentRegion2;
        } else if (iStructuredDocumentRegion3 != null && iStructuredDocumentRegion3.getStartOffset() <= n2 && n2 < iStructuredDocumentRegion3.getStartOffset() + iStructuredDocumentRegion3.getLength()) {
            iStructuredDocumentRegion = iStructuredDocumentRegion3;
        }
        iTextRegion = iStructuredDocumentRegion != null ? VEXTextEditorHelper.getCompletionRegion(n2, iStructuredDocumentRegion) : ((iStructuredDocumentRegion = iDOMNode.getStructuredDocument().getRegionAtCharacterOffset(n2)).getStartOffset() <= n && iStructuredDocumentRegion.getEndOffset() >= n ? (n2 == iStructuredDocumentRegion.getStartOffset() && iStructuredDocumentRegion.getPrevious() != null && (iStructuredDocumentRegion.getRegionAtCharacterOffset(n) != null && iStructuredDocumentRegion.getRegionAtCharacterOffset(n).getType() != "XML_CONTENT" || iStructuredDocumentRegion.getPrevious().getLastRegion().getType() == "XML_TAG_OPEN" || iStructuredDocumentRegion.getPrevious().getLastRegion().getType() == "XML_END_TAG_OPEN") ? iStructuredDocumentRegion.getPrevious().getLastRegion() : (iStructuredDocumentRegion.getEndOffset() == n ? iStructuredDocumentRegion.getLastRegion() : iStructuredDocumentRegion.getFirstRegion())) : iStructuredDocumentRegion.getLastRegion());
        return iTextRegion;
    }

    protected static ITextRegion getCompletionRegion(int n, IStructuredDocumentRegion iStructuredDocumentRegion) {
        ITextRegion iTextRegion;
        ITextRegion iTextRegion2 = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion2 == null) {
            return null;
        }
        if (iStructuredDocumentRegion.getStartOffset(iTextRegion2) == n) {
            if (iStructuredDocumentRegion.getStartOffset(iTextRegion2) == iStructuredDocumentRegion.getStartOffset() && iStructuredDocumentRegion.getPrevious() != null && !iStructuredDocumentRegion.getPrevious().isEnded()) {
                iTextRegion2 = iStructuredDocumentRegion.getPrevious().getRegionAtCharacterOffset(n - 1);
            } else {
                iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n - 1);
                if (iTextRegion != null && iTextRegion != iTextRegion2 && iTextRegion.getTextLength() == iTextRegion.getLength()) {
                    iTextRegion2 = iTextRegion;
                }
            }
        } else if (n > iStructuredDocumentRegion.getStartOffset(iTextRegion2) + iTextRegion2.getTextLength() && (iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iStructuredDocumentRegion.getStartOffset(iTextRegion2) + iTextRegion2.getLength())) != null) {
            iTextRegion2 = iTextRegion;
        }
        if (iTextRegion2 != null && iTextRegion2.getType() == "WHITE_SPACE" && (iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iStructuredDocumentRegion.getStartOffset(iTextRegion2) - 1)) != null) {
            iTextRegion2 = iTextRegion;
        }
        return iTextRegion2;
    }
}

