/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.vex.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SelectionCompletionProposal
implements ICompletionProposal {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private int fSelectionlength;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;

    public SelectionCompletionProposal(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, 0, null, null, null, null);
    }

    public SelectionCompletionProposal(String string, int n, int n2, int n3, int n4, Image image, String string2, IContextInformation iContextInformation, String string3) {
        Assert.isNotNull((Object)string);
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n3 >= 0 ? 1 : 0) != 0);
        this.fReplacementString = string;
        this.fReplacementOffset = n;
        this.fReplacementLength = n2;
        this.fCursorPosition = n3;
        this.fSelectionlength = n4;
        this.fImage = image;
        this.fDisplayString = string2;
        this.fContextInformation = iContextInformation;
        this.fAdditionalProposalInfo = string3;
    }

    public void apply(IDocument iDocument) {
        try {
            iDocument.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument iDocument) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, this.fSelectionlength);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public void setDisplayString(String string) {
        this.fDisplayString = string;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String string) {
        this.fReplacementString = string;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int n) {
        this.fReplacementOffset = n;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int n) {
        this.fReplacementLength = n;
    }

    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    public void setCursorPosition(int n) {
        this.fCursorPosition = n;
    }

    public int getSelectionlength() {
        return this.fSelectionlength;
    }

    public void setSelectionlength(int n) {
        this.fSelectionlength = n;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public void setContextInformation(IContextInformation iContextInformation) {
        this.fContextInformation = iContextInformation;
    }

    public void setAdditionalProposalInfo(String string) {
        this.fAdditionalProposalInfo = string;
    }
}

